/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine;

import java.io.Serializable;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.CannotAcquireLockException;

public abstract class LockableEntityPersister
extends EntityPersister {
    public static int DEFAULT_TIMEOUT = 30;

    public LockableEntityPersister(MappingContext mappingContext, PersistentEntity entity, Session session, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, session, publisher);
    }

    public abstract Object lock(Serializable var1) throws CannotAcquireLockException;

    public abstract Object lock(Serializable var1, int var2) throws CannotAcquireLockException;

    public abstract boolean isLocked(Object var1);

    public abstract void unlock(Object var1);

    @Override
    public Object proxy(Serializable key) {
        PersistentEntity entity = this.getPersistentEntity();
        PersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            key = (Serializable)this.getMappingContext().getConversionService().convert((Object)key, identity.getType());
        }
        return this.getProxyFactory().createProxy(this.session, entity.getJavaClass(), key);
    }
}

