/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.viewer.JC;

public class CIPDataTracker
extends CIPData {
    public Map<String, CIPTracker> htTracker = new Hashtable<String, CIPTracker>();
    private int lastIndex = -1;
    private Map<String, Object> lastInfo;

    @Override
    boolean isTracker() {
        return true;
    }

    @Override
    void track(CIPChirality cip, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, int sphere, int finalScore, int mode) {
        CIPChirality.CIPAtom b1;
        CIPChirality.CIPAtom a1;
        if (a.rootSubstituent == b.rootSubstituent) {
            return;
        }
        System.out.println(a + " " + b + " " + sphere);
        if (finalScore > 0) {
            a1 = b;
            b1 = a;
        } else {
            a1 = a;
            b1 = b;
        }
        CIPTracker t = new CIPTracker(cip.currentRule, a1, b1, sphere, Math.abs(finalScore), mode);
        this.htTracker.put(CIPDataTracker.getTrackerKey(cip.root, a1, b1), t);
        switch (mode) {
            case 1: 
            case 4: {
                break;
            }
        }
    }

    @Override
    String getRootTrackerResult(CIPChirality.CIPAtom root) {
        String s = "";
        for (int i = 0; i < 3; ++i) {
            s = s + "\t" + root.atoms[i] + "\t--------------\n";
            CIPTracker t = this.htTracker.get(CIPDataTracker.getTrackerKey(root, root.atoms[i], root.atoms[i + 1]));
            if (t == null) continue;
            s = s + t.getTrackerLine(t.a, t.bsa);
            s = s + "\t   " + JC.getCIPRuleName(t.rule) + "\n";
            s = s + t.getTrackerLine(t.b, t.bsb);
        }
        s = s + "\t" + root.atoms[3] + "\t--------------\n";
        System.out.println(s);
        this.setCIPInfo(s, root.atom.getIndex(), root.atom.getAtomName());
        return s;
    }

    private void setCIPInfo(String s, int index, String name) {
        Map<String, Object> modelInfo = this.getModelAuxiliaryInfoForAtom(index);
        if (modelInfo != null) {
            Hashtable<String, String> cipInfo = (Hashtable<String, String>)modelInfo.get("CIPInfo");
            if (cipInfo == null) {
                cipInfo = new Hashtable<String, String>();
                modelInfo.put("CIPInfo", cipInfo);
            }
            cipInfo.put(name, s);
        }
    }

    private Map<String, Object> getModelAuxiliaryInfoForAtom(int index) {
        Map<String, Object> map;
        if (index == this.lastIndex) {
            map = this.lastInfo;
        } else {
            this.lastIndex = index;
            map = this.lastInfo = this.vwr.ms.getModelAuxiliaryInfo(this.vwr.ms.at[this.lastIndex].getModelIndex());
        }
        return map;
    }

    private static String getTrackerKey(CIPChirality.CIPAtom root, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b) {
        return b.rootSubstituent == null ? "" : root.atom.getAtomName() + "." + a.rootSubstituent.atom.getAtomName() + "-" + b.rootSubstituent.atom.getAtomName();
    }

    class CIPTracker {
        CIPChirality.CIPAtom a;
        CIPChirality.CIPAtom b;
        int sphere;
        int score;
        int mode;
        int rule;
        public BS bsa;
        public BS bsb;

        CIPTracker(int rule, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, int sphere, int score, int mode) {
            this.rule = rule;
            this.a = a;
            this.b = b;
            this.sphere = sphere;
            this.score = score;
            this.mode = mode;
            this.bsa = a.listRS == null ? null : a.listRS[0];
            this.bsb = b.listRS == null ? null : b.listRS[0];
        }

        String getTrackerLine(CIPChirality.CIPAtom b, BS bsb) {
            return "\t\t" + b.myPath + (this.mode != 3 ? "" : (b.isTerminal ? "-o" : "-" + b.atoms[0].atom.getAtomName())) + (this.rule == 8 || bsb == null ? "" : "\t" + this.getLikeUnlike(bsb, b.listRS)) + "\n";
        }

        private String getLikeUnlike(BS bsa, BS[] listRS) {
            if (this.rule > 8) {
                return "";
            }
            int n = Math.max(listRS[1].length(), listRS[2].length());
            String s = this.rule == 8 ? "" : (bsa == listRS[1] ? "(R)" : "(S)");
            String l = this.rule == 8 ? "R" : "l";
            String u = this.rule == 8 ? "S" : "u";
            for (int i = 0; i < n; ++i) {
                s = s + (bsa.get(i) ? l : u);
            }
            return s;
        }
    }
}

