/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.symmetry.CIPData;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class CIPChirality {
    static final String RULE_2_nXX_EQ_XX = ";9Be;19F;23Na;27Al;31P;45Sc;55Mn;59Co;75As;89Y;93Nb;98Tc;103Rh;127I;133Cs;141Pr;145Pm;159Tb;165Ho;169Tm;197Au;209Bi;209Po;210At;222Rn;223Fr;226Ra;227Ac;231Pa;232Th;and all > U (atomno > 92)";
    static final String RULE_2_REDUCE_ISOTOPE_MASS_NUMBER = ";16O;52Cr;96Mo;175Lu;";
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int A_WINS = -1;
    static final int B_WINS = 1;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int UNDETERMINED = -1;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_M = 17;
    static final int STEREO_P = 18;
    static final int STEREO_Z = 13;
    static final int STEREO_E = 14;
    static final int STEREO_BOTH_RS = 3;
    static final int STEREO_BOTH_EZ = 15;
    static final int RULE_1a = 1;
    static final int RULE_1b = 2;
    static final int RULE_2 = 3;
    static final int RULE_3 = 4;
    static final int RULE_4a = 5;
    static final int RULE_4b = 6;
    static final int RULE_4c = 7;
    static final int RULE_5 = 8;
    static final int RULE_6 = 9;
    static final int RULE_RS = 99;
    static final String[] ruleNames = new String[]{"", "1a", "1b", "2", "3", "4a", "4b", "4c", "5", "6"};
    static final int MAX_PATH = 50;
    static final int SMALL_RING_MAX = 7;
    public static final int TRACK_ATOM = 1;
    public static final int TRACK_DUPLICATE = 2;
    public static final int TRACK_TERMINAL = 3;
    public static final int TRACK_RS = 4;
    int currentRule = 1;
    CIPAtom root;
    CIPData data;
    boolean doTrack;
    boolean isAux;
    BS bsNeedRule = new BS();
    int ptIDLogger;

    public String getRuleName(int rule) {
        if (rule == 99) {
            return "RS";
        }
        return ruleNames[rule];
    }

    public void getChiralityForAtoms(CIPData data) {
        if (data.bsAtoms.cardinality() == 0) {
            return;
        }
        this.data = data;
        this.doTrack = data.isTracker();
        this.ptIDLogger = 0;
        BS bsToDo = (BS)data.bsMolecule.clone();
        boolean haveAlkenes = this.preFilterAtomList(data.atoms, bsToDo, data.bsEnes);
        if (!data.bsEnes.isEmpty()) {
            data.getEneKekule();
        }
        Logger.info("bsKekule:" + data.bsKekuleAmbiguous);
        bsToDo = (BS)data.bsAtoms.clone();
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            SimpleNode a = data.atoms[i];
            a.setCIPChirality(0);
            this.ptIDLogger = 0;
            int c = this.getAtomChiralityLimited(a, null, null);
            a.setCIPChirality(c == 0 ? 3 : c | this.currentRule - 1 << 5);
            if (this.doTrack && c != 0) {
                data.getRootTrackerResult(this.root);
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        if (haveAlkenes) {
            Lst<int[]> lstEZ = new Lst<int[]>();
            int i2 = bsToDo.nextSetBit(0);
            while (i2 >= 0) {
                this.getAtomBondChirality(data.atoms[i2], lstEZ, bsToDo);
                i2 = bsToDo.nextSetBit(i2 + 1);
            }
            if (data.lstSmallRings.length > 0 && lstEZ.size() > 0) {
                this.clearSmallRingEZ(data.atoms, lstEZ);
            }
            this.setStereoFromSmiles(data.bsHelixM, 17, data.atoms);
            this.setStereoFromSmiles(data.bsHelixP, 18, data.atoms);
        }
        if (Logger.debugging) {
            Logger.info("Kekule ambiguous = " + data.bsKekuleAmbiguous);
            Logger.info("small rings = " + PT.toJSON(null, data.lstSmallRings));
        }
    }

    private void setStereoFromSmiles(BS bsHelix, int stereo, SimpleNode[] atoms) {
        if (bsHelix != null) {
            int i = bsHelix.nextSetBit(0);
            while (i >= 0) {
                atoms[i].setCIPChirality(stereo);
                i = bsHelix.nextSetBit(i + 1);
            }
        }
    }

    private boolean preFilterAtomList(SimpleNode[] atoms, BS bsToDo, BS bsEnes) {
        boolean haveAlkenes = false;
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            if (!this.data.couldBeChiralAtom(atoms[i])) {
                bsToDo.clear(i);
            } else {
                switch (this.data.couldBeChiralAlkene(atoms[i], null)) {
                    case -1: {
                        break;
                    }
                    case 13: {
                        bsEnes.set(i);
                    }
                    case 17: {
                        haveAlkenes = true;
                    }
                }
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        return haveAlkenes;
    }

    static boolean isFirstRow(SimpleNode a) {
        int n = a.getElementNumber();
        return n > 2 && n <= 10;
    }

    private void clearSmallRingEZ(SimpleNode[] atoms, Lst<int[]> lstEZ) {
        int j = this.data.lstSmallRings.length;
        while (--j >= 0) {
            this.data.lstSmallRings[j].andNot(this.data.bsAtropisomeric);
        }
        int i = lstEZ.size();
        while (--i >= 0) {
            int[] ab = (int[])lstEZ.get(i);
            int j2 = this.data.lstSmallRings.length;
            while (--j2 >= 0) {
                BS ring = this.data.lstSmallRings[j2];
                if (!ring.get(ab[0]) || !ring.get(ab[1])) continue;
                atoms[ab[0]].setCIPChirality(3);
                atoms[ab[1]].setCIPChirality(3);
            }
        }
    }

    private void getAtomBondChirality(SimpleNode atom, Lst<int[]> lstEZ, BS bsToDo) {
        int index = atom.getIndex();
        SimpleEdge[] bonds = atom.getEdges();
        int c = 0;
        boolean isAtropic = this.data.bsAtropisomeric.get(index);
        int j = bonds.length;
        while (--j >= 0) {
            int index1;
            SimpleNode atom1;
            SimpleEdge bond = bonds[j];
            if (isAtropic) {
                atom1 = bonds[j].getOtherNode(atom);
                index1 = atom1.getIndex();
                if (!this.data.bsAtropisomeric.get(index1)) continue;
                c = this.setBondChirality(atom, atom1, atom, atom1, true);
            } else {
                if (this.data.getBondOrder(bond) != 2 || (index1 = (atom1 = this.getLastCumuleneAtom(bond, atom, null, null)).getIndex()) < index) continue;
                c = this.getBondChiralityLimited(bond, atom);
            }
            if (c != 0) {
                if (!isAtropic) {
                    lstEZ.addLast(new int[]{index, index1});
                }
                bsToDo.clear(index);
                bsToDo.clear(index1);
            }
            if (!isAtropic) continue;
            break;
        }
    }

    private SimpleNode getLastCumuleneAtom(SimpleEdge bond, SimpleNode atom, int[] nSP2, SimpleNode[] parents) {
        SimpleNode atom2 = bond.getOtherNode(atom);
        if (parents != null) {
            parents[0] = atom2;
            parents[1] = atom;
        }
        if (nSP2 != null) {
            nSP2[0] = 2;
        }
        boolean ppt = false;
        block0: while (atom2.getCovalentBondCount() == 2) {
            SimpleNode atom3;
            SimpleEdge[] edges = atom2.getEdges();
            int i = edges.length;
            do {
                if (--i < 0) continue block0;
            } while ((atom3 = (bond = edges[i]).getOtherNode(atom2)) == atom);
            if (this.data.getBondOrder(bond) != 2) {
                return atom2;
            }
            if (parents != null) {
                if (!ppt) {
                    parents[0] = atom2;
                    ppt = true;
                }
                parents[1] = atom2;
            }
            if (nSP2 != null) {
                nSP2[0] = nSP2[0] + 1;
            }
            atom = atom2;
            atom2 = atom3;
        }
        return atom2;
    }

    /*
     * Unable to fully structure code
     */
    private int getAtomChiralityLimited(SimpleNode atom, CIPAtom cipAtom, SimpleNode parentAtom) {
        block19: {
            rs = 0;
            this.bsNeedRule.clearAll();
            this.bsNeedRule.set(1);
            try {
                v0 = isAlkeneEndCheck = atom == null;
                if (isAlkeneEndCheck) {
                    this.root = cipAtom;
                    atom = this.root.atom;
                    cipAtom.parent = new CIPAtom().create(parentAtom, null, true, false, false);
                    cipAtom.htPathPoints = cipAtom.parent.htPathPoints;
                } else {
                    this.root = cipAtom = new CIPAtom().create(atom, null, false, false, false);
                    if (!cipAtom.isSP3) {
                        return 0;
                    }
                }
                if (!cipAtom.setNode()) break block19;
                this.currentRule = 1;
                while (this.currentRule <= 9) {
                    switch (this.currentRule) {
                        case 4: {
                            this.isAux = true;
                            this.doTrack = false;
                            cipAtom.createAuxiliaryDescriptors(null, null);
                            this.doTrack = this.data.isTracker();
                            this.isAux = false;
                            ** GOTO lbl40
                        }
                        case 5: {
                            if (!this.bsNeedRule.get(5)) {
                                this.currentRule = 8;
                                break;
                            }
                        }
                        case 6: 
                        case 7: {
                            cipAtom.sortSubstituents(-2147483648);
                        }
                        case 8: {
                            this.bsNeedRule.set(this.currentRule);
                            ** GOTO lbl40
                        }
                        case 9: {
                            rs = cipAtom.setupRule6(false);
                            this.bsNeedRule.setBitTo(9, rs != 0);
                        }
lbl40:
                        // 4 sources

                        default: {
                            if (!this.bsNeedRule.get(this.currentRule)) break;
                            nPrioritiesPrev = cipAtom.nPriorities;
                            if (rs != 0 || !cipAtom.sortSubstituents(0)) break;
                            if (Logger.debuggingHigh && cipAtom.h1Count < 2) {
                                for (i = 0; i < cipAtom.bondCount; ++i) {
                                    if (cipAtom.atoms[i] == null) continue;
                                    Logger.info(cipAtom.atoms[i] + " " + cipAtom.priorities[i]);
                                }
                            }
                            if (isAlkeneEndCheck) {
                                return cipAtom.atoms[0].isDuplicate != false ? 2 : 1;
                            }
                            rs = this.data.checkHandedness(cipAtom);
                            if (this.currentRule == 8 && (cipAtom.nPriorities != 4 || nPrioritiesPrev != 2)) {
                                rs |= 8;
                            }
                            if (Logger.debugging) {
                                Logger.info(atom + " " + JC.getCIPChiralityName(rs) + " by Rule " + this.getRuleName(this.currentRule) + "\n----------------------------------");
                            }
                            return rs;
                        }
                    }
                    ++this.currentRule;
                }
            }
            catch (Throwable e) {
                System.out.println(e + " in CIPChirality " + this.currentRule);
                e.printStackTrace();
                return 3;
            }
        }
        return rs;
    }

    private int getBondChiralityLimited(SimpleEdge bond, SimpleNode a) {
        boolean isAxial;
        if (a == null) {
            a = bond.getOtherNode(null);
        }
        if (this.data.couldBeChiralAlkene(a, bond) == -1) {
            return 0;
        }
        int[] nSP2 = new int[1];
        SimpleNode[] parents = new SimpleNode[2];
        SimpleNode b = this.getLastCumuleneAtom(bond, a, nSP2, parents);
        boolean bl = isAxial = nSP2[0] % 2 == 1;
        if (!isAxial && this.data.bsAromatic.get(a.getIndex())) {
            return -1;
        }
        int c = this.setBondChirality(a, parents[0], parents[1], b, isAxial);
        if (Logger.debugging) {
            Logger.info("get Bond Chirality " + JC.getCIPChiralityName(c) + " " + bond);
        }
        return c;
    }

    private int setBondChirality(SimpleNode a, SimpleNode pa, SimpleNode pb, SimpleNode b, boolean isAxial) {
        int c;
        CIPAtom a1 = new CIPAtom().create(a, null, true, false, false);
        int atop = this.getAtomChiralityLimited(null, a1, pa) - 1;
        int ruleA = this.currentRule;
        CIPAtom b2 = new CIPAtom().create(b, null, true, false, false);
        int btop = this.getAtomChiralityLimited(null, b2, pb) - 1;
        int ruleB = this.currentRule;
        int n = c = atop >= 0 && btop >= 0 ? this.getEneChirality(b2.atoms[btop], b2, a1, a1.atoms[atop], isAxial, true) : 0;
        if (c != 0 && (isAxial || !this.data.bsAtropisomeric.get(a.getIndex()) && !this.data.bsAtropisomeric.get(b.getIndex()))) {
            if (isAxial && ruleA >= 8 != ruleB >= 8) {
                c |= 8;
            }
            a.setCIPChirality(c | ruleA - 1 << 5);
            b.setCIPChirality(c | ruleB - 1 << 5);
            if (Logger.debugging) {
                Logger.info(a + "-" + b + " " + JC.getCIPChiralityName(c));
            }
        }
        return c;
    }

    int getEneChirality(CIPAtom winner1, CIPAtom end1, CIPAtom end2, CIPAtom winner2, boolean isAxial, boolean allowPseudo) {
        return winner1 == null || winner2 == null || winner1.atom == null || winner2.atom == null ? 0 : (isAxial ? this.data.isPositiveTorsion(winner1, end1, end2, winner2) : this.data.isCis(winner1, end1, end2, winner2));
    }

    class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        private int id;
        private int sphere;
        private int rootDistance;
        private boolean isSet;
        boolean isDuplicate = true;
        boolean isTerminal;
        private boolean isAlkene;
        SimpleNode atom;
        int atomIndex;
        int bondCount;
        float elemNo;
        private float mass = -1.0f;
        CIPAtom parent;
        CIPAtom rootSubstituent;
        int h1Count;
        CIPAtom[] atoms = new CIPAtom[4];
        private int nAtoms;
        private BS bsPath;
        String myPath = "";
        int[] oldPriorities;
        int[] priorities = new int[4];
        int oldNPriorities;
        int nPriorities;
        private int nRootDuplicates;
        Map<Integer, Integer> htPathPoints;
        private CIPAtom alkeneParent;
        private CIPAtom alkeneChild;
        private boolean isAlkeneAtom2;
        private boolean isKekuleAmbiguous;
        private CIPAtom nextSP2;
        private boolean multipleBondDuplicate;
        private boolean isEvenEne = true;
        private int auxEZ = -1;
        boolean isSP3 = true;
        private char auxChirality = (char)126;
        private CIPAtom nextChiralBranch;
        private boolean isChiralPath;
        int rule4Type;
        private BS bsTemp = new BS();
        private int rule4Ref;
        BS[] listRS;
        private CIPAtom[] newAtoms;
        private int rule6refIndex = -1;

        CIPAtom() {
        }

        public int setupRule6(boolean isAux) {
            if (this.nPriorities > 2 || (isAux ? this.countDuplicates(this.atomIndex) : this.nRootDuplicates) <= 2) {
                return 0;
            }
            boolean checkS4 = this.nPriorities == 1 && !isAux;
            CIPChirality.this.root.rule6refIndex = this.atoms[this.priorities[2]].atomIndex;
            if (checkS4) {
                this.saveRestorePriorities(false);
            }
            this.sortSubstituents(Integer.MIN_VALUE);
            int rs = 0;
            if (!this.sortSubstituents(0)) {
                return 0;
            }
            rs = CIPChirality.this.data.checkHandedness(this);
            if (rs == 0 || !checkS4) {
                return rs;
            }
            CIPChirality.this.root.rule6refIndex = this.atoms[1].atomIndex;
            this.saveRestorePriorities(true);
            this.sortSubstituents(Integer.MIN_VALUE);
            this.sortSubstituents(0);
            int rs1 = CIPChirality.this.data.checkHandedness(this);
            return rs1 == rs ? rs : 0;
        }

        private void saveRestorePriorities(boolean isRestore) {
            if (isRestore) {
                this.priorities = this.oldPriorities;
                this.nPriorities = this.oldNPriorities;
            } else {
                this.oldPriorities = Arrays.copyOf(this.priorities, 4);
                this.oldNPriorities = this.nPriorities;
            }
            for (int i = 0; i < this.nAtoms; ++i) {
                this.atoms[i].saveRestorePriorities(isRestore);
            }
        }

        private int countDuplicates(int index) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null) continue;
                if (this.atoms[i].isDuplicate) {
                    if (this.atoms[i].atomIndex != index) continue;
                    ++n;
                    continue;
                }
                n += this.atoms[i].countDuplicates(index);
            }
            return n;
        }

        CIPAtom create(SimpleNode atom, CIPAtom parent, boolean isAlkene, boolean isDuplicate, boolean isParentBond) {
            this.id = ++CIPChirality.this.ptIDLogger;
            this.parent = parent;
            if (atom == null) {
                return this;
            }
            this.isAlkene = isAlkene;
            this.atom = atom;
            this.atomIndex = atom.getIndex();
            if (atom.getIsotopeNumber() > 0) {
                CIPChirality.this.bsNeedRule.set(3);
            }
            this.isDuplicate = this.multipleBondDuplicate = isDuplicate;
            this.isKekuleAmbiguous = CIPChirality.this.data.bsKekuleAmbiguous != null && CIPChirality.this.data.bsKekuleAmbiguous.get(this.atomIndex);
            this.elemNo = isDuplicate && this.isKekuleAmbiguous ? parent.getKekuleElementNumber() : (float)atom.getElementNumber();
            this.bondCount = atom.getCovalentBondCount();
            boolean bl = this.isSP3 = this.bondCount == 4 || this.bondCount == 3 && !isAlkene && (this.elemNo > 10.0f || CIPChirality.this.data.bsAzacyclic != null && CIPChirality.this.data.bsAzacyclic.get(this.atomIndex));
            if (parent != null) {
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.rootSubstituent = this;
                this.htPathPoints = new Hashtable<Integer, Integer>();
            } else if (parent != null) {
                this.rootSubstituent = parent.rootSubstituent;
                this.htPathPoints = (Map)((Hashtable)parent.htPathPoints).clone();
            }
            BS bS = this.bsPath = parent == null ? new BS() : (BS)parent.bsPath.clone();
            if (isDuplicate) {
                CIPChirality.this.bsNeedRule.set(4);
            }
            this.rootDistance = this.sphere;
            if (parent == null) {
                this.bsPath.set(this.atomIndex);
            } else if (this.multipleBondDuplicate) {
                --this.rootDistance;
            } else if (this.bsPath.get(this.atomIndex)) {
                this.isDuplicate = true;
                CIPChirality.this.bsNeedRule.setBitTo(2, true);
                if ((atom == CIPChirality.this.root.atom ? 0 : (this.rootDistance = isParentBond ? parent.sphere : this.htPathPoints.get(this.atomIndex))) == 0) {
                    ++CIPChirality.this.root.nRootDuplicates;
                }
            } else {
                this.bsPath.set(this.atomIndex);
                this.htPathPoints.put(this.atomIndex, this.rootDistance);
            }
            if (CIPChirality.this.doTrack) {
                if (this.sphere < 50) {
                    this.myPath = (parent != null ? parent.myPath + "-" : "") + this;
                }
                if (Logger.debuggingHigh) {
                    Logger.info("new CIPAtom " + this.myPath);
                }
            }
            return this;
        }

        private float getMass() {
            if (this.mass == -1.0f) {
                if (this.isDuplicate || (this.mass = this.atom.getMass()) != (float)((int)this.mass) || this.isType(CIPChirality.RULE_2_nXX_EQ_XX)) {
                    return this.mass == -1.0f ? (this.mass = Elements.getAtomicMass((int)this.elemNo)) : this.mass;
                }
                if (this.isType(CIPChirality.RULE_2_REDUCE_ISOTOPE_MASS_NUMBER)) {
                    this.mass -= 0.1f;
                }
            }
            return this.mass;
        }

        private boolean isType(String rule2Type) {
            return PT.isOneOf((int)this.mass + Elements.elementSymbolFromNumber((int)this.elemNo), rule2Type);
        }

        private float getKekuleElementNumber() {
            SimpleEdge[] edges = this.atom.getEdges();
            float ave = 0.0f;
            int n = 0;
            int i = edges.length;
            while (--i >= 0) {
                SimpleNode other;
                SimpleEdge bond = edges[i];
                if (!bond.isCovalent() || !CIPChirality.this.data.bsKekuleAmbiguous.get((other = bond.getOtherNode(this.atom)).getIndex())) continue;
                ++n;
                ave += (float)other.getElementNumber();
            }
            return ave / (float)n;
        }

        boolean setNode() {
            block25: {
                block24: {
                    if (this.isSet) break block24;
                    this.isSet = true;
                    if (!true || !this.isDuplicate) break block25;
                }
                return true;
            }
            int index = this.atom.getIndex();
            SimpleEdge[] bonds = this.atom.getEdges();
            int nBonds = bonds.length;
            if (Logger.debuggingHigh) {
                Logger.info("set " + this);
            }
            int pt = 0;
            block10: for (int i = 0; i < nBonds; ++i) {
                SimpleEdge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                SimpleNode other = bond.getOtherNode(this.atom);
                boolean isParentBond = this.parent != null && this.parent.atom == other;
                int order = CIPChirality.this.data.getBondOrder(bond);
                if (order == 2) {
                    if (this.elemNo > 10.0f || !CIPChirality.isFirstRow(other)) {
                        order = 1;
                    } else {
                        this.isAlkene = true;
                        if (isParentBond) {
                            this.setEne();
                        }
                    }
                }
                if (nBonds == 1 && order == 1 && isParentBond) {
                    this.isTerminal = true;
                    return true;
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParentBond, false, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParentBond, order == 2, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 1: {
                        if (isParentBond || this.addAtom(pt++, other, order != 1 && this.elemNo <= 10.0f, false, false) != null) continue block10;
                    }
                    default: {
                        this.isTerminal = true;
                        return !true;
                    }
                }
            }
            this.nAtoms = pt;
            switch (pt) {
                case 2: 
                case 3: {
                    if ((this.elemNo != 6.0f || !CIPChirality.this.data.bsCMinus.get(index)) && !CIPChirality.this.data.bsXAromatic.get(index)) break;
                    ++this.nAtoms;
                    this.addAtom(pt++, this.atom, true, false, false);
                }
            }
            if (pt < 4) {
                while (pt < this.atoms.length) {
                    this.atoms[pt] = new CIPAtom().create(null, this, false, true, false);
                    ++pt;
                }
            }
            try {
                Arrays.sort(this.atoms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }

        private void setEne() {
            this.parent.alkeneChild = null;
            this.alkeneParent = this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent;
            this.alkeneParent.alkeneChild = this;
            this.nextSP2 = this.parent;
            if (this.parent.alkeneParent == null) {
                this.parent.nextSP2 = this;
            }
            if (this.atom.getCovalentBondCount() == 2 && this.atom.getValence() == 4) {
                this.parent.isAlkeneAtom2 = false;
                this.alkeneParent.isEvenEne = !this.alkeneParent.isEvenEne;
            } else {
                this.isAlkeneAtom2 = true;
            }
        }

        CIPAtom addAtom(int i, SimpleNode other, boolean isDuplicate, boolean isAlkene, boolean isParentBond) {
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info(" too many bonds on " + this.atom);
                }
                return null;
            }
            if (other.getElementNumber() == 1 && other.getIsotopeNumber() == 0 && ++this.h1Count > 1 && this.parent == null) {
                if (Logger.debuggingHigh) {
                    Logger.info(" second H atom found on " + this.atom);
                }
                return null;
            }
            this.atoms[i] = new CIPAtom().create(other, this, isAlkene, isDuplicate, isParentBond);
            return this.atoms[i];
        }

        boolean sortSubstituents(int sphere) {
            CIPAtom a;
            int i;
            boolean ignoreTies;
            if (CIPChirality.this.currentRule != 99 && this.nPriorities == (sphere < 1 ? 4 : 3)) {
                return true;
            }
            boolean bl = ignoreTies = sphere == Integer.MIN_VALUE;
            if (ignoreTies) {
                if (this.isTerminal) {
                    return false;
                }
                switch (CIPChirality.this.currentRule) {
                    case 9: {
                        int i2;
                        for (i2 = 0; i2 < 4; ++i2) {
                            if (this.atoms[i2] == null || this.atoms[i2].isDuplicate || this.atoms[i2].atom == null || !this.atoms[i2].setNode()) continue;
                            this.atoms[i2].sortSubstituents(Integer.MIN_VALUE);
                        }
                        break;
                    }
                    case 5: 
                    case 7: {
                        int i2;
                        for (i2 = 0; i2 < 4; ++i2) {
                            if (this.atoms[i2] == null || !this.atoms[i2].isChiralPath) continue;
                            this.atoms[i2].sortSubstituents(Integer.MIN_VALUE);
                        }
                        if (this.isSP3) break;
                        return false;
                    }
                }
            }
            ignoreTies |= CIPChirality.this.currentRule == 6 || CIPChirality.this.currentRule == 8;
            int[] indices = new int[4];
            int[] newPriorities = new int[4];
            if (Logger.debuggingHigh && this.h1Count < 2) {
                Logger.info(CIPChirality.this.root + "---sortSubstituents---" + this);
                for (int i3 = 0; i3 < 4; ++i3) {
                    Logger.info(CIPChirality.this.getRuleName(CIPChirality.this.currentRule) + ": " + this + "[" + i3 + "]=" + this.atoms[i3].myPath + " " + Integer.toHexString(this.priorities[i3]));
                }
                Logger.info("---" + this.nPriorities);
            }
            if (CIPChirality.this.currentRule == 99) {
                for (i = 0; i < 4; ++i) {
                    a = this.atoms[i];
                    if (a.nextChiralBranch == null) continue;
                    a.nextChiralBranch.sortSubstituents(sphere);
                }
            }
            for (i = 0; i < 3; ++i) {
                a = this.atoms[i];
                boolean aLoses = a.isDuplicate && CIPChirality.this.currentRule > 2;
                block14: for (int j = i + 1; j < 4; ++j) {
                    int loser = j;
                    CIPAtom b = this.atoms[loser];
                    int score = 0;
                    switch (b.atom == null || this.priorities[i] < this.priorities[j] ? -1 : (aLoses || a.atom == null || this.priorities[j] < this.priorities[i] ? 1 : ((score = a.checkCurrentRule(b)) != 0 && score != Integer.MIN_VALUE || ignoreTies ? score : this.sign(a.breakTie(b, sphere + 1))))) {
                        case 1: {
                            loser = i;
                        }
                        case -1: {
                            int n = loser;
                            newPriorities[n] = newPriorities[n] + 1;
                            if (CIPChirality.this.doTrack && score != 0 && (sphere == 0 || ignoreTies)) {
                                CIPChirality.this.data.track(CIPChirality.this, a, b, 1, score, 0);
                            }
                        }
                        case -2147483648: 
                        case 0: {
                            int n = loser;
                            indices[n] = indices[n] + 1;
                            continue block14;
                        }
                    }
                }
            }
            this.bsTemp.clearAll();
            this.newAtoms = new CIPAtom[4];
            for (i = 0; i < 4; ++i) {
                int pt = indices[i];
                CIPAtom a2 = this.newAtoms[pt] = this.atoms[i];
                if (a2.atom != null) {
                    this.bsTemp.set(newPriorities[i]);
                }
                if (CIPChirality.this.currentRule == 99) continue;
                this.priorities[pt] = newPriorities[i];
            }
            if (CIPChirality.this.currentRule == 99) {
                return false;
            }
            this.atoms = this.newAtoms;
            this.nPriorities = this.bsTemp.cardinality();
            if (Logger.debuggingHigh && this.atoms[2].atom != null && this.atoms[2].elemNo != 1.0f) {
                Logger.info(this.dots() + this.atom + " nPriorities = " + this.nPriorities);
                for (i = 0; i < 4; ++i) {
                    Logger.info(this.dots() + this.myPath + "[" + i + "]=" + this.atoms[i] + " " + this.priorities[i] + " " + Integer.toHexString(this.priorities[i]));
                }
                Logger.info(this.dots() + "-------" + this.nPriorities);
            }
            return this.nPriorities == this.bondCount;
        }

        private String dots() {
            return ".....................".substring(0, Math.min(20, this.sphere));
        }

        private int breakTie(CIPAtom b, int sphere) {
            int finalScore = 0;
            if (!(this.isDuplicate && (CIPChirality.this.currentRule > 2 || b.isDuplicate && this.atom == b.atom && this.rootDistance == b.rootDistance) || !this.setNode() || !b.setNode() || this.isTerminal && b.isTerminal || this.isDuplicate && b.isDuplicate)) {
                if (this.isTerminal != b.isTerminal) {
                    finalScore = (this.isTerminal ? 1 : -1) * (sphere + (b.isDuplicate || this.isDuplicate ? 0 : 1));
                    if (CIPChirality.this.doTrack) {
                        CIPChirality.this.data.track(CIPChirality.this, this, b, sphere, finalScore, 3);
                    }
                } else {
                    int score;
                    int n = score = CIPChirality.this.currentRule > 1 ? 0 : this.unlikeDuplicates(b);
                    if (score != 0) {
                        finalScore = score * (sphere + 1);
                        if (CIPChirality.this.doTrack) {
                            CIPChirality.this.data.track(CIPChirality.this, this, b, sphere, finalScore, 2);
                        }
                    } else {
                        int i;
                        for (i = 0; i < this.nAtoms; ++i) {
                            score = this.atoms[i].checkCurrentRule(b.atoms[i]);
                            if (score == 0) continue;
                            finalScore = score * (sphere + 1);
                            if (!CIPChirality.this.doTrack) break;
                            CIPChirality.this.data.track(CIPChirality.this, this.atoms[i], b.atoms[i], sphere, finalScore, 1);
                            break;
                        }
                        if (finalScore == 0) {
                            this.sortSubstituents(sphere);
                            b.sortSubstituents(sphere);
                            int absScore = Integer.MAX_VALUE;
                            for (i = 0; i < this.nAtoms; ++i) {
                                int abs;
                                score = this.atoms[i].breakTie(b.atoms[i], sphere + 1);
                                if (score == 0 || (abs = Math.abs(score)) >= absScore) continue;
                                absScore = abs;
                                finalScore = score;
                            }
                        }
                    }
                }
            }
            return finalScore;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score;
            int n = b == null ? -1 : (this.atom == null != (b.atom == null) ? (this.atom == null ? 1 : -1) : ((score = this.compareRule1a(b)) != 0 ? score : ((score = this.unlikeDuplicates(b)) != 0 || !this.isDuplicate ? score : this.compareRule1b(b))));
            return n;
        }

        private boolean auxSort(int rule) {
            int current = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = rule;
            int rule6ref = CIPChirality.this.root.rule6refIndex;
            int nDup = CIPChirality.this.root.nRootDuplicates;
            boolean isChiral = rule == 9 ? this.setupRule6(true) != 0 : this.sortSubstituents(0);
            CIPChirality.this.root.nRootDuplicates = nDup;
            CIPChirality.this.root.rule6refIndex = rule6ref;
            CIPChirality.this.currentRule = current;
            return isChiral;
        }

        private int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.compareRule1a(b);
                }
                case 2: {
                    return this.compareRule1b(b);
                }
                case 3: {
                    return this.compareRule2(b);
                }
                case 4: {
                    return this.compareRule3(b);
                }
                case 5: {
                    return this.compareRules4ac(b, " sr SR PM");
                }
                case 6: 
                case 8: {
                    return this.isTerminal || b.isTerminal ? 0 : this.compareRule4b5(b);
                }
                case 99: {
                    return this.compareRule4bRef(b);
                }
                case 7: {
                    return this.compareRules4ac(b, " s r p m");
                }
                case 9: 
            }
            return this.compareRule6(b);
        }

        private int unlikeDuplicates(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (this.isDuplicate ? 1 : -1);
        }

        private int compareRule1a(CIPAtom b) {
            return b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0)));
        }

        private int compareRule1b(CIPAtom b) {
            return b.isDuplicate != this.isDuplicate ? 0 : Integer.compare(this.rootDistance, b.rootDistance);
        }

        private int compareRule2(CIPAtom b) {
            return this.getMass() == b.getMass() ? 0 : (this.mass > b.mass ? -1 : 1);
        }

        private int compareRule3(CIPAtom b) {
            return this.isDuplicate || b.isDuplicate || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || !this.parent.alkeneParent.isEvenEne || !b.parent.alkeneParent.isEvenEne || this.parent == b.parent ? 0 : Integer.compare(this.parent.auxEZ, b.parent.auxEZ);
        }

        private int compareRules4ac(CIPAtom b, String test) {
            int isRb;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int isRa = test.indexOf(this.auxChirality);
            return isRa > (isRb = test.indexOf(b.auxChirality)) + 1 ? -1 : (isRb > isRa + 1 ? 1 : 0);
        }

        private int compareRule4bRef(CIPAtom b) {
            return this.rule4Type == b.rule4Type ? 0 : (this.rule4Type == CIPChirality.this.root.rule4Ref ? -1 : 1);
        }

        private int compareRule4b5(CIPAtom b) {
            int score;
            BS bsB;
            BS bsA = this.getBetter4bList();
            BS best = this.compareLikeUnlike(bsA, bsB = b.getBetter4bList());
            int n = best == null ? Integer.MIN_VALUE : (score = best == bsA ? -1 : 1);
            if (CIPChirality.this.doTrack && best != null) {
                CIPChirality.this.data.track(CIPChirality.this, this, b, 1, score, 4);
            }
            return score;
        }

        private BS getBetter4bList() {
            if (CIPChirality.this.currentRule == 8) {
                if (Logger.debuggingHigh) {
                    Logger.info("getBest R5 " + this + " " + this.listRS[1] + " " + this.myPath);
                }
                return this.listRS[1];
            }
            if (this.listRS != null) {
                return this.listRS[0];
            }
            BS bs = this.rank4bAndRead(null);
            this.listRS = new BS[]{null, bs, this.rank4bAndRead(bs)};
            if (Logger.debuggingHigh) {
                Logger.info("getBest 4b " + this + " " + this.listRS[1] + this.listRS[2] + " " + this.myPath);
            }
            this.listRS[0] = (bs = this.compareLikeUnlike(this.listRS[1], this.listRS[2])) == null ? this.listRS[1] : bs;
            return this.listRS[0];
        }

        private BS compareLikeUnlike(BS bsA, BS bsB) {
            BS bsXOR = (BS)bsB.clone();
            bsXOR.xor(bsA);
            int l = bsXOR.nextSetBit(0);
            return l < 0 ? null : (bsA.get(l) ? bsA : bsB);
        }

        private BS rank4bAndRead(BS bsR) {
            int nrs;
            boolean isS = bsR != null;
            int ref = isS ? 2 : 1;
            BS list = new BS();
            Lst<CIPAtom> q = new Lst<CIPAtom>();
            CIPChirality.this.root.rule4Ref = ref;
            CIPChirality.this.currentRule = 99;
            this.sortSubstituents(0);
            CIPChirality.this.currentRule = 6;
            if (this.rule4Type != 0) {
                if (this.rule4Type == ref) {
                    list.set(0);
                } else {
                    return list;
                }
            }
            q.clear();
            q.addLast(this);
            int n = nrs = this.rule4Type == 0 ? 0 : 1;
            while (q.size() != 0) {
                CIPAtom next = (CIPAtom)q.removeItemAt(0);
                CIPAtom[] atoms = next.newAtoms;
                if (atoms == null) {
                    atoms = next.atoms;
                }
                if (atoms == null) continue;
                for (int i = 0; i < 4; ++i) {
                    CIPAtom ai = atoms[i];
                    if (ai == null || ai.atom == null || ai.isTerminal || ai.isDuplicate) continue;
                    q.addLast(ai);
                    if (ai.rule4Type == 0) continue;
                    if (ai.rule4Type == ref) {
                        list.set(nrs);
                    } else if (nrs == 0 || isS && bsR.get(nrs)) {
                        return list;
                    }
                    ++nrs;
                }
            }
            return list;
        }

        private int compareRule6(CIPAtom b) {
            return this.atomIndex == CIPChirality.this.root.rule6refIndex == (b.atomIndex == CIPChirality.this.root.rule6refIndex) ? 0 : (this.atomIndex == CIPChirality.this.root.rule6refIndex ? -1 : 1);
        }

        private int getAuxEneWinnerChirality(CIPAtom end1, CIPAtom end2, boolean isAxial, int[] retRule2) {
            CIPAtom winner2;
            CIPAtom winner1 = this.getAuxEneEndWinner(end1, end1.nextSP2, null);
            CIPAtom cIPAtom = winner2 = winner1 == null || winner1.atom == null ? null : this.getAuxEneEndWinner(end2, end2.nextSP2, retRule2);
            if (Logger.debuggingHigh) {
                Logger.info(this + " alkene end winners " + winner1 + winner2);
            }
            return CIPChirality.this.getEneChirality(winner1, end1, end2, winner2, isAxial, false);
        }

        private CIPAtom getAuxEneEndWinner(CIPAtom end, CIPAtom prevSP2, int[] retRule) {
            CIPAtom atom1 = (CIPAtom)end.clone();
            if (atom1.parent != prevSP2) {
                atom1.addReturnPath(prevSP2, end);
            }
            for (int rule = 1; rule <= 9; ++rule) {
                if (!atom1.auxSort(rule)) continue;
                for (int i = 0; i < 4; ++i) {
                    CIPAtom a = atom1.atoms[i];
                    if (a.multipleBondDuplicate || atom1.priorities[i] == atom1.priorities[i + 1]) continue;
                    if (retRule != null) {
                        retRule[0] = rule;
                    }
                    return a.atom == null ? null : a;
                }
            }
            return null;
        }

        private void addReturnPath(CIPAtom newParent, CIPAtom fromAtom) {
            Lst<CIPAtom> path = new Lst<CIPAtom>();
            CIPAtom thisAtom = this;
            CIPAtom oldParent = fromAtom;
            CIPAtom oldSub = newParent;
            while (oldParent.parent != null && oldParent.parent.atoms[0] != null) {
                if (Logger.debuggingHigh) {
                    Logger.info("path:" + oldParent.parent + "->" + oldParent);
                }
                oldParent = oldParent.parent;
                path.addLast(oldParent);
            }
            path.addLast(null);
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                oldParent = (CIPAtom)path.get(i);
                CIPAtom newSub = oldParent == null ? new CIPAtom().create(null, this, this.isAlkene, true, false) : (CIPAtom)oldParent.clone();
                newSub.nPriorities = 0;
                newSub.sphere = thisAtom.sphere + 1;
                thisAtom.replaceParentSubstituent(oldSub, newParent, newSub);
                if (i > 0 && thisAtom.isAlkene && !thisAtom.isAlkeneAtom2) {
                    if (newParent.isAlkeneAtom2) {
                        newParent.isAlkeneAtom2 = false;
                        thisAtom.alkeneParent = newParent;
                    }
                    thisAtom.setEne();
                }
                newParent = thisAtom;
                thisAtom = newSub;
                oldSub = fromAtom;
                fromAtom = oldParent;
            }
        }

        private void replaceParentSubstituent(CIPAtom oldSub, CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != oldSub && (newParent != null || this.atoms[i].atom != null)) continue;
                if (Logger.debuggingHigh) {
                    Logger.info("reversed: " + newParent + "->" + this + "->" + newSub);
                }
                this.parent = newParent;
                this.atoms[i] = newSub;
                Arrays.sort(this.atoms);
                break;
            }
        }

        boolean createAuxiliaryDescriptors(CIPAtom node1, CIPAtom[] ret) {
            boolean isChiralPath = false;
            int c = 126;
            if (this.atom == null) {
                return false;
            }
            this.setNode();
            int rs = -1;
            int nRS = 0;
            CIPAtom[] ret1 = new CIPAtom[1];
            boolean skipRules4And5 = false;
            boolean prevIsChiral = true;
            boolean allowTwoSame = !this.isAlkene && this.nPriorities <= (node1 == null ? 2 : 1);
            for (int i = 0; i < 4; ++i) {
                CIPAtom a = this.atoms[i];
                if (a == null || a.isDuplicate || a.isTerminal) continue;
                ret1[0] = null;
                boolean aIsChiralPath = a.createAuxiliaryDescriptors(node1 == null ? a : node1, ret1);
                if (ret1[0] != null && ret != null) {
                    ret[0] = this.nextChiralBranch = a.nextChiralBranch;
                }
                if (a.nextChiralBranch != null || aIsChiralPath) {
                    ++nRS;
                    isChiralPath = aIsChiralPath;
                    prevIsChiral = true;
                    continue;
                }
                if (!allowTwoSame && !prevIsChiral && this.priorities[i] == this.priorities[i - 1]) {
                    return false;
                }
                prevIsChiral = false;
            }
            boolean isBranch = nRS >= 2;
            switch (nRS) {
                case 0: {
                    isChiralPath = false;
                }
                case 1: {
                    skipRules4And5 = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    isChiralPath = false;
                    if (ret == null) break;
                    ret[0] = this.nextChiralBranch = this;
                }
            }
            if (this.isAlkene) {
                if (!(this.alkeneChild == null || this.isEvenEne && (this.auxEZ != 15 && this.auxEZ != -1 || this.isKekuleAmbiguous || this.alkeneChild.bondCount < 2))) {
                    int[] rule2;
                    rs = this.getAuxEneWinnerChirality(this, this.alkeneChild, !this.isEvenEne, rule2 = this.isEvenEne ? new int[1] : null);
                    if (rs == 0) {
                        this.alkeneChild.auxEZ = 15;
                        this.auxEZ = 15;
                    } else {
                        isChiralPath = true;
                        if (rule2 != null && rule2[0] != 8) {
                            this.auxEZ = this.alkeneChild.auxEZ = rs;
                            if (Logger.debuggingHigh) {
                                Logger.info("alkene type " + this + " " + (this.auxEZ == 14 ? "E" : "Z"));
                            }
                        } else if (!isBranch) {
                            switch (rs) {
                                case 13: 
                                case 17: {
                                    rs = 1;
                                    c = 82;
                                    isChiralPath = true;
                                    break;
                                }
                                case 14: 
                                case 18: {
                                    rs = 2;
                                    c = 83;
                                    isChiralPath = true;
                                }
                            }
                            this.auxChirality = (char)c;
                            this.rule4Type = rs;
                        }
                    }
                }
            } else if (this.isSP3 && ret != null) {
                CIPAtom atom1 = (CIPAtom)this.clone();
                if (atom1.setNode()) {
                    int rule;
                    atom1.addReturnPath(null, this);
                    for (rule = 1; rule <= 9 && (skipRules4And5 && rule >= 5 && rule <= 8 || !atom1.auxSort(rule)); ++rule) {
                    }
                    if (rule > 9) {
                        c = 126;
                    } else {
                        rs = CIPChirality.this.data.checkHandedness(atom1);
                        isChiralPath |= rs != 0;
                        int n = rs == 1 ? 82 : (c = rs == 2 ? 83 : 126);
                        if (rule == 8) {
                            c = c == 82 ? 114 : (c == 83 ? 115 : 126);
                        } else {
                            this.rule4Type = rs;
                        }
                    }
                }
                this.auxChirality = c;
            }
            if (node1 == null) {
                CIPChirality.this.bsNeedRule.setBitTo(5, nRS > 0);
            }
            if (c != 126) {
                Logger.info("creating aux " + (char)c + " for " + this + (this.myPath.length() == 0 ? "" : " = " + this.myPath));
            }
            this.isChiralPath = isChiralPath;
            return this.isChiralPath;
        }

        public int sign(int score) {
            return score < 0 ? -1 : (score > 0 ? 1 : 0);
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.id = CIPChirality.this.ptIDLogger++;
            a.atoms = new CIPAtom[4];
            for (int i = 0; i < 4; ++i) {
                a.atoms[i] = this.atoms[i];
            }
            a.priorities = new int[4];
            a.htPathPoints = this.htPathPoints;
            a.alkeneParent = null;
            a.auxEZ = -1;
            a.rule4Type = 0;
            a.listRS = null;
            if (Logger.debuggingHigh) {
                a.myPath = a.toString();
            }
            return a;
        }

        public String toString() {
            if (this.atom == null) {
                return "<null>";
            }
            if (Logger.debuggingHigh) {
                return "[" + CIPChirality.this.currentRule + "." + this.sphere + "," + this.id + "." + (this.isDuplicate ? this.parent.atom : this.atom).getAtomName() + (this.isDuplicate ? "*(" + this.rootDistance + ")" : "") + (this.auxChirality == '~' ? "" : "" + this.auxChirality) + " " + this.elemNo + "]";
            }
            return this.isDuplicate ? "(" + this.atom.getAtomName() + "." + this.rootDistance + ")" : this.atom.getAtomName();
        }
    }
}

