/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.util.GrailsNameUtils;
import java.util.Locale;
import javax.persistence.FetchType;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.ManyToOne;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.Simple;
import org.grails.datastore.mapping.model.types.ToOne;
import org.springframework.util.ClassUtils;

public class DefaultGrailsDomainClassProperty
implements GrailsDomainClassProperty {
    private GrailsDomainClass domainClass;
    private String naturalName;
    private boolean explicitSaveUpdateCascade = false;
    private final PersistentEntity persistentEntity;
    private final PersistentProperty persistentProperty;
    private final Association association;
    private final GrailsDomainClass referencedDomainClass;

    public DefaultGrailsDomainClassProperty(GrailsDomainClass domainClass, PersistentEntity entity, PersistentProperty property) {
        PersistentEntity associatedEntity;
        this.domainClass = domainClass;
        this.persistentEntity = entity;
        this.persistentProperty = property;
        Association association = this.association = property instanceof Association ? (Association)property : null;
        this.referencedDomainClass = this.association != null ? ((associatedEntity = this.association.getAssociatedEntity()) != null ? (GrailsDomainClass)domainClass.getApplication().getArtefact("Domain", associatedEntity.getName()) : null) : null;
        this.naturalName = GrailsNameUtils.getNaturalName((String)property.getName());
    }

    private void throwUnsupported() {
        throw new UnsupportedOperationException("The DomainClass property API does not support that operation. Use the mapping context API instead.");
    }

    @Override
    public String getName() {
        return this.persistentProperty.getName();
    }

    @Override
    public Class getType() {
        return this.persistentProperty.getType();
    }

    @Override
    public boolean isPersistent() {
        return this.persistentProperty != null;
    }

    @Override
    public boolean isOptional() {
        return this.persistentProperty.isNullable();
    }

    @Override
    public boolean isIdentity() {
        return this.persistentProperty instanceof Identity;
    }

    @Deprecated
    public void setIdentity(boolean b) {
        this.throwUnsupported();
    }

    @Override
    public boolean isOneToMany() {
        return this.persistentProperty instanceof OneToMany;
    }

    @Override
    public boolean isManyToOne() {
        return this.persistentProperty instanceof ManyToOne;
    }

    @Override
    public String getFieldName() {
        return this.getName().toUpperCase();
    }

    @Override
    public boolean isOneToOne() {
        return this.persistentProperty instanceof OneToOne;
    }

    @Override
    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    @Override
    public boolean isManyToMany() {
        return this.persistentProperty instanceof ManyToMany;
    }

    @Deprecated
    protected void setManyToMany(boolean manyToMany) {
        this.throwUnsupported();
    }

    @Deprecated
    protected void setOneToMany(boolean oneToMany) {
        this.throwUnsupported();
    }

    @Deprecated
    protected void setManyToOne(boolean manyToOne) {
        this.throwUnsupported();
    }

    @Deprecated
    protected void setOneToOne(boolean oneToOne) {
        this.throwUnsupported();
    }

    @Deprecated
    protected void setHasOne(boolean isHasOne) {
        this.throwUnsupported();
    }

    @Override
    public boolean isHasOne() {
        return this.association instanceof ToOne && ((ToOne)this.association).isForeignKeyInChild();
    }

    @Deprecated
    protected void setPersistent(boolean persistent) {
        this.throwUnsupported();
    }

    @Deprecated
    protected void setBidirectional(boolean bidirectional) {
        this.throwUnsupported();
    }

    @Override
    public String getTypePropertyName() {
        String shortTypeName = ClassUtils.getShortName((Class)this.persistentProperty.getType());
        return shortTypeName.substring(0, 1).toLowerCase(Locale.ENGLISH) + shortTypeName.substring(1);
    }

    @Override
    public Class getReferencedPropertyType() {
        if (this.association != null) {
            PersistentEntity entity = this.association.getAssociatedEntity();
            if (entity != null) {
                return entity.getJavaClass();
            }
            if (this.association.isBasic()) {
                return ((Basic)this.association).getComponentType();
            }
        } else if (this.persistentProperty instanceof Simple || this.persistentProperty instanceof Identity) {
            return this.persistentProperty.getType();
        }
        return null;
    }

    @Override
    public boolean isBidirectional() {
        return this.association != null && this.association.isBidirectional();
    }

    @Deprecated
    protected void setReferencedPropertyType(Class<?> referencedPropertyType) {
        this.throwUnsupported();
    }

    @Override
    public GrailsDomainClass getReferencedDomainClass() {
        return this.referencedDomainClass;
    }

    @Override
    public void setReferencedDomainClass(GrailsDomainClass referencedDomainClass) {
        this.throwUnsupported();
    }

    @Override
    public boolean isAssociation() {
        return this.association != null;
    }

    @Override
    public boolean isEnum() {
        return this.getType().isEnum();
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    public String toString() {
        return this.persistentProperty.toString();
    }

    @Override
    public GrailsDomainClassProperty getOtherSide() {
        Association otherSide;
        if (this.referencedDomainClass != null && this.association != null && (otherSide = this.association.getInverseSide()) != null) {
            return this.referencedDomainClass.getPropertyByName(otherSide.getName());
        }
        return null;
    }

    @Override
    public void setOtherSide(GrailsDomainClassProperty property) {
        this.throwUnsupported();
    }

    @Override
    public boolean isExplicitSaveUpdateCascade() {
        this.throwUnsupported();
        return false;
    }

    @Override
    public void setExplicitSaveUpdateCascade(boolean explicitSaveUpdateCascade) {
        this.throwUnsupported();
    }

    @Override
    public boolean isInherited() {
        return this.persistentProperty.isInherited();
    }

    @Override
    public int getFetchMode() {
        FetchType fetchStrategy = this.persistentProperty.getMapping().getMappedForm().getFetchStrategy();
        switch (fetchStrategy) {
            case EAGER: {
                return 1;
            }
            case LAZY: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean isOwningSide() {
        return this.association != null && this.association.isOwningSide();
    }

    @Override
    public void setOwningSide(boolean b) {
        this.throwUnsupported();
    }

    @Override
    public boolean isCircular() {
        return this.association != null && this.association.isCircular();
    }

    public void setReferencePropertyName(String name) {
        this.throwUnsupported();
    }

    @Override
    public String getReferencedPropertyName() {
        if (this.association != null) {
            return this.association.getReferencedPropertyName();
        }
        return null;
    }

    @Override
    public boolean isEmbedded() {
        return this.association != null && this.association.isEmbedded();
    }

    @Override
    public GrailsDomainClass getComponent() {
        if (this.association instanceof Embedded) {
            return this.getReferencedDomainClass();
        }
        return null;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.throwUnsupported();
    }

    @Override
    public boolean isDerived() {
        return this.persistentProperty.getMapping().getMappedForm().isDerived();
    }

    @Override
    public void setDerived(boolean derived) {
        this.throwUnsupported();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof GrailsDomainClassProperty) {
            if (!super.equals(o)) {
                GrailsDomainClassProperty otherProp = (GrailsDomainClassProperty)o;
                Class myActualClass = this.getDomainClass().getClazz();
                Class otherActualClass = otherProp.getDomainClass().getClazz();
                return otherProp.getName().equals(this.getName()) && otherProp.getReferencedPropertyType().equals(this.getReferencedPropertyType()) && (otherActualClass.isAssignableFrom(myActualClass) || myActualClass.isAssignableFrom(otherActualClass));
            }
            return true;
        }
        return false;
    }

    public void setBasicCollectionType(boolean b) {
        this.throwUnsupported();
    }

    @Override
    public boolean isBasicCollectionType() {
        return this.persistentProperty != null && this.persistentProperty instanceof Basic;
    }
}

