/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationVisitor;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyAutoConfigurationTransformation;
import org.springframework.boot.cli.compiler.DependencyManagementBomTransformation;
import org.springframework.boot.cli.compiler.ExtendedGroovyClassLoader;
import org.springframework.boot.cli.compiler.GroovyBeansTransformation;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;
import org.springframework.boot.cli.compiler.ResolveDependencyCoordinatesTransformation;
import org.springframework.boot.cli.compiler.SmartImportCustomizer;
import org.springframework.boot.cli.compiler.SpringBootAstTransformation;
import org.springframework.boot.cli.compiler.dependencies.SpringBootDependenciesDependencyManagement;
import org.springframework.boot.cli.compiler.grape.AetherGrapeEngine;
import org.springframework.boot.cli.compiler.grape.AetherGrapeEngineFactory;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.boot.cli.compiler.grape.GrapeEngineInstaller;
import org.springframework.boot.cli.util.ResourceUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class GroovyCompiler {
    private final GroovyCompilerConfiguration configuration;
    private final ExtendedGroovyClassLoader loader;
    private final Iterable<CompilerAutoConfiguration> compilerAutoConfigurations;
    private final List<ASTTransformation> transformations;

    public GroovyCompiler(GroovyCompilerConfiguration configuration) {
        this.configuration = configuration;
        this.loader = this.createLoader(configuration);
        DependencyResolutionContext resolutionContext = new DependencyResolutionContext();
        resolutionContext.addDependencyManagement(new SpringBootDependenciesDependencyManagement());
        AetherGrapeEngine grapeEngine = AetherGrapeEngineFactory.create(this.loader, configuration.getRepositoryConfiguration(), resolutionContext, configuration.isQuiet());
        GrapeEngineInstaller.install(grapeEngine);
        this.loader.getConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{new CompilerAutoConfigureCustomizer()});
        this.compilerAutoConfigurations = configuration.isAutoconfigure() ? ServiceLoader.load(CompilerAutoConfiguration.class) : Collections.emptySet();
        this.transformations = new ArrayList<ASTTransformation>();
        this.transformations.add(new DependencyManagementBomTransformation(resolutionContext));
        this.transformations.add(new DependencyAutoConfigurationTransformation(this.loader, resolutionContext, this.compilerAutoConfigurations));
        this.transformations.add(new GroovyBeansTransformation());
        if (this.configuration.isGuessDependencies()) {
            this.transformations.add(new ResolveDependencyCoordinatesTransformation(resolutionContext));
        }
        for (ASTTransformation aSTTransformation : ServiceLoader.load(SpringBootAstTransformation.class)) {
            this.transformations.add(aSTTransformation);
        }
        Collections.sort(this.transformations, AnnotationAwareOrderComparator.INSTANCE);
    }

    public List<ASTTransformation> getAstTransformations() {
        return this.transformations;
    }

    public ExtendedGroovyClassLoader getLoader() {
        return this.loader;
    }

    private ExtendedGroovyClassLoader createLoader(GroovyCompilerConfiguration configuration) {
        ExtendedGroovyClassLoader loader = new ExtendedGroovyClassLoader(configuration.getScope());
        for (URL url : this.getExistingUrls()) {
            loader.addURL(url);
        }
        for (String classpath : configuration.getClasspath()) {
            loader.addClasspath(classpath);
        }
        return loader;
    }

    private URL[] getExistingUrls() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl instanceof ExtendedGroovyClassLoader) {
            return ((ExtendedGroovyClassLoader)((Object)tccl)).getURLs();
        }
        return new URL[0];
    }

    public void addCompilationCustomizers(CompilationCustomizer ... customizers) {
        this.loader.getConfiguration().addCompilationCustomizers(customizers);
    }

    public Class<?>[] compile(String ... sources) throws CompilationFailedException, IOException {
        this.loader.clearCache();
        ArrayList<Class> classes = new ArrayList<Class>();
        CompilerConfiguration configuration = this.loader.getConfiguration();
        CompilationUnit compilationUnit = new CompilationUnit(configuration, null, (GroovyClassLoader)this.loader);
        GroovyClassLoader.ClassCollector collector = this.loader.createCollector(compilationUnit, null);
        compilationUnit.setClassgenCallback((CompilationUnit.ClassgenCallback)collector);
        for (String source : sources) {
            List<String> paths = ResourceUtils.getUrls(source, (ClassLoader)((Object)this.loader));
            for (String path : paths) {
                compilationUnit.addSource(new URL(path));
            }
        }
        this.addAstTransformations(compilationUnit);
        compilationUnit.compile(7);
        for (Object loadedClass : collector.getLoadedClasses()) {
            classes.add((Class)loadedClass);
        }
        ClassNode mainClassNode = MainClass.get(compilationUnit);
        Class mainClass = null;
        for (Class loadedClass : classes) {
            if (!mainClassNode.getName().equals(loadedClass.getName())) continue;
            mainClass = loadedClass;
        }
        if (mainClass != null) {
            classes.remove(mainClass);
            classes.add(0, mainClass);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private void addAstTransformations(CompilationUnit compilationUnit) {
        LinkedList[] phaseOperations = this.getPhaseOperations(compilationUnit);
        this.processConversionOperations(phaseOperations[3]);
    }

    private LinkedList[] getPhaseOperations(CompilationUnit compilationUnit) {
        try {
            Field field = CompilationUnit.class.getDeclaredField("phaseOperations");
            field.setAccessible(true);
            LinkedList[] phaseOperations = (LinkedList[])field.get(compilationUnit);
            return phaseOperations;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Phase operations not available from compilation unit");
        }
    }

    private void processConversionOperations(LinkedList conversionOperations) {
        int index = this.getIndexOfASTTransformationVisitor(conversionOperations);
        conversionOperations.add(index, new CompilationUnit.SourceUnitOperation(){

            public void call(SourceUnit source) throws CompilationFailedException {
                ASTNode[] nodes = new ASTNode[]{source.getAST()};
                for (ASTTransformation transformation : GroovyCompiler.this.transformations) {
                    transformation.visit(nodes, source);
                }
            }
        });
    }

    private int getIndexOfASTTransformationVisitor(LinkedList<?> conversionOperations) {
        for (int index = 0; index < conversionOperations.size(); ++index) {
            if (!conversionOperations.get(index).getClass().getName().startsWith(ASTTransformationVisitor.class.getName())) continue;
            return index;
        }
        return conversionOperations.size();
    }

    private static class MainClass {
        private MainClass() {
        }

        public static ClassNode get(CompilationUnit source) {
            return MainClass.get(source.getAST().getClasses());
        }

        public static ClassNode get(List<ClassNode> classes) {
            for (ClassNode node : classes) {
                if (AstUtils.hasAtLeastOneAnnotation(node, "Enable*AutoConfiguration")) {
                    return null;
                }
                if (!AstUtils.hasAtLeastOneAnnotation(node, "*Controller", "Configuration", "Component", "*Service", "Repository", "Enable*")) continue;
                return node;
            }
            return classes.isEmpty() ? null : classes.get(0);
        }
    }

    private class CompilerAutoConfigureCustomizer
    extends CompilationCustomizer {
        CompilerAutoConfigureCustomizer() {
            super(CompilePhase.CONVERSION);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            SmartImportCustomizer importCustomizer = new SmartImportCustomizer(source, context, classNode);
            ClassNode mainClassNode = MainClass.get(source.getAST().getClasses());
            for (CompilerAutoConfiguration autoConfiguration : GroovyCompiler.this.compilerAutoConfigurations) {
                if (!autoConfiguration.matches(classNode)) continue;
                if (GroovyCompiler.this.configuration.isGuessImports()) {
                    autoConfiguration.applyImports(importCustomizer);
                    importCustomizer.call(source, context, classNode);
                }
                if (classNode.equals((Object)mainClassNode)) {
                    autoConfiguration.applyToMainClass(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
                }
                autoConfiguration.apply(GroovyCompiler.this.loader, GroovyCompiler.this.configuration, context, source, classNode);
            }
            importCustomizer.call(source, context, classNode);
        }
    }
}

