/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpockCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.subclasses(classNode, "Specification");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) throws CompilationFailedException {
        dependencies.add("spock-core").add("junit").add("spring-test").add("hamcrest-library");
    }

    @Override
    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addStarImports(new String[]{"spock.lang"}).addStarImports(new String[]{"org.junit"}).addStaticStars(new String[]{"org.junit.Assert"}).addStaticStars(new String[]{"org.hamcrest.MatcherAssert"}).addStaticStars(new String[]{"org.hamcrest.Matchers"});
    }
}

