/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tim.prune.I18nManager;
import tim.prune.data.Photo;
import tim.prune.gui.ImageUtils;

public class PhotoThumbnail
extends JPanel
implements Runnable {
    private Photo _photo = null;
    private Image _thumbnail = null;
    private boolean _loadingImage = false;
    private boolean _loadFailed = false;
    private boolean _inPanel = false;
    private static final String LOADING_STRING = String.valueOf(I18nManager.getText("details.photo.loading")) + " ...";

    public PhotoThumbnail() {
        this(true);
    }

    public PhotoThumbnail(boolean bl) {
        this.setOpaque(true);
        this._inPanel = bl;
    }

    public void setPhoto(Photo photo) {
        if (this._photo != photo) {
            this._photo = photo;
            this._thumbnail = null;
            this._loadFailed = false;
        }
        this.repaint();
    }

    public void refresh() {
        this._thumbnail = null;
        this._loadFailed = false;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._photo != null) {
            if (this._thumbnail == null && !this._loadingImage && !this._loadFailed) {
                this._loadingImage = true;
                new Thread(this).start();
            }
            if (this._loadingImage) {
                graphics.setColor(Color.BLACK);
                graphics.drawString(LOADING_STRING, 10, 30);
            } else if (this._thumbnail != null && !this._loadFailed) {
                int n = this.getParent().getWidth() - 10;
                int n2 = this._inPanel ? n : this.getHeight() - 10;
                BufferedImage bufferedImage = ImageUtils.rotateImage(this._thumbnail, n, n2, this._photo.getRotationDegrees());
                int n3 = ((Image)bufferedImage).getWidth(null);
                int n4 = ((Image)bufferedImage).getHeight(null);
                int n5 = (this.getWidth() - n3) / 2;
                int n6 = (this.getHeight() - n4) / 2;
                graphics.drawImage(bufferedImage, n5, n6, n3, n4, null);
                if (this._inPanel && (this.getHeight() < this.getWidth() || this.getHeight() > n)) {
                    Dimension dimension = new Dimension(n, n);
                    this.setPreferredSize(dimension);
                    this.setSize(dimension);
                    this.invalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {}
                            PhotoThumbnail.this.getParent().getParent().getParent().validate();
                        }
                    });
                }
            }
        }
    }

    public void run() {
        if (this._inPanel) {
            if (this._photo.getExifThumbnail() != null) {
                Image image = new ImageIcon(this._photo.getExifThumbnail()).getImage();
                this._thumbnail = ImageUtils.createScaledImage(image, image.getWidth(null), image.getHeight(null));
                image = null;
            } else {
                int n = this._photo.getWidth();
                int n2 = this._photo.getHeight();
                if (n > -1 && n2 > -1) {
                    Dimension dimension = ImageUtils.getThumbnailSize(n, n2, 400, 400);
                    Image image = this._photo.createImageIcon().getImage();
                    this._thumbnail = ImageUtils.createScaledImage(image, dimension.width, dimension.height);
                    image = null;
                } else {
                    this._loadFailed = true;
                }
            }
        } else {
            this._thumbnail = this._photo.createImageIcon().getImage();
        }
        this._loadingImage = false;
        this.repaint();
    }
}

