/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.CompoundDocument;

class CompoundDocDirEntry {
    private final CompoundDocument cd;
    byte[] unicodeName64 = new byte[64];
    short nBytesUnicodeName;
    byte entryType;
    byte[] uniqueID16 = new byte[16];
    byte[] userflags4 = new byte[4];
    int SIDfirstSector;
    int lenStream;
    byte[] unused = new byte[8];
    String entryName;
    boolean isStandard;
    boolean isEmpty;

    CompoundDocDirEntry(CompoundDocument compoundDocument) {
        this.cd = compoundDocument;
    }

    final boolean readData() {
        try {
            this.cd.readByteArray(this.unicodeName64, 0, 64);
            this.nBytesUnicodeName = this.cd.readShort();
            this.entryType = this.cd.readByte();
            this.cd.readByte();
            this.cd.readInt();
            this.cd.readInt();
            this.cd.readInt();
            this.cd.readByteArray(this.uniqueID16, 0, 16);
            this.cd.readByteArray(this.userflags4, 0, 4);
            this.cd.readByteArray(this.unused, 0, 8);
            this.cd.readByteArray(this.unused, 0, 8);
            this.SIDfirstSector = this.cd.readInt();
            this.lenStream = this.cd.readInt();
            this.cd.readByteArray(this.unused, 0, 4);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
        this.entryName = "";
        for (int i = 0; i < this.nBytesUnicodeName - 2; i += 2) {
            this.entryName = this.entryName + (char)this.unicodeName64[i];
        }
        this.isStandard = this.entryType == 5 || this.lenStream >= this.cd.header.minBytesStandardStream;
        this.isEmpty = this.entryType == 0 || this.lenStream <= 0;
        return true;
    }

    public String toString() {
        return this.entryName + " " + this.lenStream;
    }
}

