/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import java.util.Arrays;
import org.jruby.RubyHash;
import org.jruby.ext.ffi.Type;

final class Signature {
    private final Type resultType;
    private final Type[] parameterTypes;
    private final CallingConvention convention;
    private final boolean ignoreError;
    private final RubyHash enums;

    public Signature(Type resultType, Type[] parameterTypes, CallingConvention convention, boolean ignoreError, RubyHash enums) {
        this.resultType = resultType;
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.convention = convention;
        this.ignoreError = ignoreError;
        this.enums = enums;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Signature rhs = (Signature)o;
        return this.resultType.equals(rhs.resultType) && this.convention.equals((Object)rhs.convention) && this.ignoreError == rhs.ignoreError && Arrays.equals(this.parameterTypes, rhs.parameterTypes) && (this.enums == null && rhs.enums == null || this.enums.equals(rhs.enums));
    }

    public int hashCode() {
        return this.resultType.hashCode() ^ this.convention.hashCode() ^ Boolean.valueOf(this.ignoreError).hashCode() ^ Arrays.hashCode(this.parameterTypes) ^ (this.enums == null ? 0 : this.enums.hashCode());
    }

    public CallingConvention getCallingConvention() {
        return this.convention;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public Type getParameterType(int parameterIndex) {
        return this.parameterTypes[parameterIndex];
    }

    public Type getResultType() {
        return this.resultType;
    }

    public RubyHash getEnums() {
        return this.enums;
    }
}

