/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs.swing;

import javajs.awt.Dimension;
import javajs.util.BS;
import javajs.util.SB;
import org.jmol.awtjs.swing.AbstractTableModel;
import org.jmol.awtjs.swing.ColumnSelectionModel;
import org.jmol.awtjs.swing.JComponent;
import org.jmol.awtjs.swing.ListSelectionModel;
import org.jmol.awtjs.swing.TableColumn;

public class JTable
extends JComponent
implements ListSelectionModel,
ColumnSelectionModel {
    private AbstractTableModel tableModel;
    private BS bsSelectedCells;
    private BS bsSelectedRows;
    boolean rowSelectionAllowed;
    boolean cellSelectionEnabled;
    Object selectionListener;

    public JTable(AbstractTableModel tableModel) {
        super("JT");
        this.tableModel = tableModel;
        this.bsSelectedCells = new BS();
        this.bsSelectedRows = new BS();
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this;
    }

    public ColumnSelectionModel getColumnModel() {
        return this;
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void clearSelection() {
        this.bsSelectedCells.clearAll();
        this.bsSelectedRows.clearAll();
    }

    public void setRowSelectionAllowed(boolean b) {
        this.rowSelectionAllowed = b;
    }

    public void setRowSelectionInterval(int i, int j) {
        this.bsSelectedRows.clearAll();
        this.bsSelectedRows.setBits(i, j);
        this.bsSelectedCells.clearAll();
    }

    public void setCellSelectionEnabled(boolean enabled) {
        this.cellSelectionEnabled = enabled;
    }

    @Override
    public void addListSelectionListener(Object listener) {
        this.selectionListener = listener;
    }

    @Override
    public TableColumn getColumn(int i) {
        return this.tableModel.getColumn(i);
    }

    @Override
    public String toHTML() {
        SB sb = new SB();
        sb.append("\n<table id='" + this.id + "_table' class='JTable' >");
        this.tableModel.toHTML(sb, this.id, this.bsSelectedRows);
        sb.append("\n</table>\n");
        return sb.toString();
    }
}

