/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadOsmTask
extends AbstractDownloadTask<DataSet> {
    protected Bounds currentBounds;
    protected DownloadTask downloadTask;
    protected String newLayerName;
    protected boolean warnAboutEmptyArea = true;

    @Override
    public String[] getPatterns() {
        if (this.getClass() == DownloadOsmTask.class) {
            return (String[])Arrays.stream(OsmServerLocationReader.OsmUrlPattern.values()).map(OsmServerLocationReader.OsmUrlPattern::pattern).toArray(String[]::new);
        }
        return super.getPatterns();
    }

    @Override
    public String getTitle() {
        if (this.getClass() == DownloadOsmTask.class) {
            return I18n.tr("Download OSM", new Object[0]);
        }
        return super.getTitle();
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(downloadArea), newLayer, downloadArea, progressMonitor);
    }

    public Future<?> download(OsmServerReader reader, boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(newLayer, reader, progressMonitor, this.zoomAfterDownload), downloadArea);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds downloadArea) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(downloadArea);
        return MainApplication.worker.submit(downloadTask);
    }

    protected String modifyUrlBeforeLoad(String url) {
        return url;
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, String url, ProgressMonitor progressMonitor) {
        String newUrl = this.modifyUrlBeforeLoad(url);
        this.downloadTask = new DownloadTask(newLayer, new OsmServerLocationReader(newUrl), progressMonitor);
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm)", newUrl);
        return MainApplication.worker.submit(this.downloadTask);
    }

    protected final void extractOsmFilename(String pattern, String url) {
        Matcher matcher = Pattern.compile(pattern).matcher(url);
        this.newLayerName = matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.downloadTask != null ? this.downloadTask.computeBbox(this.currentBounds) : null;
    }

    @Override
    public String getConfirmationMessage(URL url) {
        String urlString;
        if (url != null && (urlString = url.toExternalForm()).matches(OsmServerLocationReader.OsmUrlPattern.OSM_API_URL.pattern())) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(I18n.tr("OSM Server URL:", new Object[0]) + ' ' + url.getHost());
            items.add(I18n.tr("Command", new Object[0]) + ": " + url.getPath());
            if (url.getQuery() != null) {
                items.add(I18n.tr("Request details: {0}", url.getQuery().replaceAll(",\\s*", ", ")));
            }
            return Utils.joinAsHtmlUnorderedList(items);
        }
        return null;
    }

    protected class DownloadTask
    extends AbstractInternalTask {
        protected final OsmServerReader reader;

        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            this(newLayer, reader, progressMonitor, true);
        }

        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload) {
            super(newLayer, I18n.tr("Downloading data", new Object[0]), progressMonitor, false, zoomAfterDownload);
            this.reader = reader;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (OsmTransferException e) {
                if (DownloadOsmTask.this.isCanceled()) {
                    Logging.info(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", e.toString()));
                    return;
                }
                if (e instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                DownloadOsmTask.this.rememberException(e);
                DownloadOsmTask.this.setFailed(true);
            }
        }

        @Override
        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                if (DownloadOsmTask.this.warnAboutEmptyArea) {
                    DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                }
                this.dataSet.addDataSource(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(LatLon.ZERO), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            this.loadData(DownloadOsmTask.this.newLayerName, DownloadOsmTask.this.currentBounds);
        }

        @Override
        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    public static abstract class AbstractInternalTask
    extends PleaseWaitRunnable {
        protected final boolean newLayer;
        protected final boolean zoomAfterDownload;
        protected DataSet dataSet;

        public AbstractInternalTask(boolean newLayer, String title, boolean ignoreException, boolean zoomAfterDownload) {
            super(title, ignoreException);
            this.newLayer = newLayer;
            this.zoomAfterDownload = zoomAfterDownload;
        }

        public AbstractInternalTask(boolean newLayer, String title, ProgressMonitor progressMonitor, boolean ignoreException, boolean zoomAfterDownload) {
            super(title, progressMonitor, ignoreException);
            this.newLayer = newLayer;
            this.zoomAfterDownload = zoomAfterDownload;
        }

        protected OsmDataLayer getEditLayer() {
            return MainApplication.getLayerManager().getEditLayer();
        }

        @Deprecated
        protected int getNumDataLayers() {
            return (int)this.getNumModifiableDataLayers();
        }

        private static Stream<OsmDataLayer> getModifiableDataLayers() {
            return MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().filter(OsmDataLayer::isDownloadable);
        }

        protected long getNumModifiableDataLayers() {
            return AbstractInternalTask.getModifiableDataLayers().count();
        }

        protected OsmDataLayer getFirstModifiableDataLayer() {
            return AbstractInternalTask.getModifiableDataLayers().findFirst().orElse(null);
        }

        protected OsmDataLayer createNewLayer(String layerName) {
            if (layerName == null || layerName.isEmpty()) {
                layerName = OsmDataLayer.createNewName();
            }
            return new OsmDataLayer(this.dataSet, layerName, null);
        }

        protected OsmDataLayer createNewLayer() {
            return this.createNewLayer(null);
        }

        protected ProjectionBounds computeBbox(Bounds bounds) {
            BoundingXYVisitor v = new BoundingXYVisitor();
            if (bounds != null) {
                v.visit(bounds);
            } else {
                v.computeBoundingBox(this.dataSet.getNodes());
            }
            return v.getBounds();
        }

        protected OsmDataLayer addNewLayerIfRequired(String newLayerName) {
            long numDataLayers = this.getNumModifiableDataLayers();
            if (this.newLayer || numDataLayers == 0L || numDataLayers > 1L && this.getEditLayer() == null) {
                OsmDataLayer layer = this.createNewLayer(newLayerName);
                MainApplication.getLayerManager().addLayer(layer, this.zoomAfterDownload);
                return layer;
            }
            return null;
        }

        protected void loadData(String newLayerName, Bounds bounds) {
            OsmDataLayer layer = this.addNewLayerIfRequired(newLayerName);
            if (layer == null) {
                layer = this.getEditLayer();
                if (layer == null || !layer.isDownloadable()) {
                    layer = this.getFirstModifiableDataLayer();
                }
                Collection<OsmPrimitive> primitivesToUpdate = this.searchPrimitivesToUpdate(bounds, layer.getDataSet());
                layer.mergeFrom(this.dataSet);
                MapFrame map = MainApplication.getMap();
                if (map != null && this.zoomAfterDownload && bounds != null) {
                    map.mapView.zoomTo(new ViewportData(this.computeBbox(bounds)));
                }
                if (!primitivesToUpdate.isEmpty()) {
                    MainApplication.worker.submit(new UpdatePrimitivesTask(layer, primitivesToUpdate));
                }
                layer.onPostDownloadFromServer();
            }
        }

        private Collection<OsmPrimitive> searchPrimitivesToUpdate(Bounds bounds, DataSet ds) {
            if (bounds == null) {
                return Collections.emptySet();
            }
            ArrayList<OsmPrimitive> col = new ArrayList<OsmPrimitive>();
            ds.searchNodes(bounds.toBBox()).stream().filter(n -> !n.isNew() && !this.dataSet.containsNode((Node)n)).forEachOrdered(col::add);
            if (!col.isEmpty()) {
                HashSet<Way> ways = new HashSet<Way>();
                HashSet<Relation> rels = new HashSet<Relation>();
                for (OsmPrimitive n2 : col) {
                    for (OsmPrimitive ref : n2.getReferrers()) {
                        if (ref.isNew()) continue;
                        if (ref instanceof Way) {
                            ways.add((Way)ref);
                            continue;
                        }
                        if (!(ref instanceof Relation)) continue;
                        rels.add((Relation)ref);
                    }
                }
                ways.stream().filter(w -> !this.dataSet.containsWay((Way)w)).forEachOrdered(col::add);
                rels.stream().filter(r -> !this.dataSet.containsRelation((Relation)r)).forEachOrdered(col::add);
            }
            return col;
        }
    }
}

