/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.WrappedElementAnchor;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAnchor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiAnchor");

    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    @NotNull
    public static PsiAnchor create(@NotNull PsiElement element) {
        if (element == null) {
            PsiAnchor.$$$reportNull$$$0(0);
        }
        PsiUtilCore.ensureValid(element);
        PsiAnchor anchor2 = PsiAnchor.doCreateAnchor(element);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(anchor2.retrieve())) {
            LOG.error("Cannot restore element " + element + " of " + element.getClass() + " from anchor " + anchor2);
        }
        PsiAnchor psiAnchor = anchor2;
        if (psiAnchor == null) {
            PsiAnchor.$$$reportNull$$$0(1);
        }
        return psiAnchor;
    }

    @NotNull
    private static PsiAnchor doCreateAnchor(@NotNull PsiElement element) {
        if (element == null) {
            PsiAnchor.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiFile) {
            VirtualFile virtualFile2 = ((PsiFile)element).getVirtualFile();
            if (virtualFile2 != null) {
                PsiFileReference psiFileReference = new PsiFileReference(virtualFile2, (PsiFile)element);
                if (psiFileReference == null) {
                    PsiAnchor.$$$reportNull$$$0(3);
                }
                return psiFileReference;
            }
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                PsiAnchor.$$$reportNull$$$0(4);
            }
            return hardReference;
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile3 = ((PsiDirectory)element).getVirtualFile();
            PsiDirectoryReference psiDirectoryReference = new PsiDirectoryReference(virtualFile3, element.getProject());
            if (psiDirectoryReference == null) {
                PsiAnchor.$$$reportNull$$$0(5);
            }
            return psiDirectoryReference;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                PsiAnchor.$$$reportNull$$$0(6);
            }
            return hardReference;
        }
        VirtualFile virtualFile4 = file2.getVirtualFile();
        if (virtualFile4 == null) {
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                PsiAnchor.$$$reportNull$$$0(7);
            }
            return hardReference;
        }
        StubIndexReference stubRef = PsiAnchor.createStubReference(element, file2);
        if (stubRef != null) {
            StubIndexReference stubIndexReference = stubRef;
            if (stubIndexReference == null) {
                PsiAnchor.$$$reportNull$$$0(8);
            }
            return stubIndexReference;
        }
        if (!element.isPhysical()) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                PsiAnchor.$$$reportNull$$$0(9);
            }
            return psiAnchor;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                PsiAnchor.$$$reportNull$$$0(10);
            }
            return psiAnchor;
        }
        Language lang = null;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language l : viewProvider.getLanguages()) {
            if (viewProvider.getPsi(l) != file2) continue;
            lang = l;
            break;
        }
        if (lang == null) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                PsiAnchor.$$$reportNull$$$0(11);
            }
            return psiAnchor;
        }
        TreeRangeReference treeRangeReference = new TreeRangeReference(file2, textRange.getStartOffset(), textRange.getEndOffset(), Identikit.fromPsi(element, lang), virtualFile4);
        if (treeRangeReference == null) {
            PsiAnchor.$$$reportNull$$$0(12);
        }
        return treeRangeReference;
    }

    @NotNull
    private static PsiAnchor wrapperOrHardReference(@NotNull PsiElement element) {
        if (element == null) {
            PsiAnchor.$$$reportNull$$$0(13);
        }
        for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiAnchor wrappedAnchor;
            PsiElement anchorElement = provider.getAnchor(element);
            if (anchorElement == null || anchorElement == element || (wrappedAnchor = PsiAnchor.create(anchorElement)) instanceof HardReference) continue;
            WrappedElementAnchor wrappedElementAnchor = new WrappedElementAnchor(provider, wrappedAnchor);
            if (wrappedElementAnchor == null) {
                PsiAnchor.$$$reportNull$$$0(14);
            }
            return wrappedElementAnchor;
        }
        HardReference hardReference = new HardReference(element);
        if (hardReference == null) {
            PsiAnchor.$$$reportNull$$$0(15);
        }
        return hardReference;
    }

    @Nullable
    public static StubIndexReference createStubReference(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            PsiAnchor.$$$reportNull$$$0(16);
        }
        if (containingFile == null) {
            PsiAnchor.$$$reportNull$$$0(17);
        }
        if (element instanceof StubBasedPsiElement && element.isPhysical() && (element instanceof PsiCompiledElement || PsiAnchor.canHaveStub(containingFile))) {
            int index2;
            StubBasedPsiElement elt = (StubBasedPsiElement)element;
            IStubElementType elementType = elt.getElementType();
            if ((elt.getStub() != null || elementType.shouldCreateStub(element.getNode())) && (index2 = PsiAnchor.calcStubIndex((StubBasedPsiElement)element)) != -1) {
                return new StubIndexReference(containingFile, index2, containingFile.getLanguage(), elementType);
            }
        }
        return null;
    }

    private static boolean canHaveStub(PsiFile file2) {
        if (!(file2 instanceof PsiFileImpl)) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        IStubFileElementType elementType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
        return elementType != null && vFile != null && elementType.shouldBuildStubFor(vFile);
    }

    public static int calcStubIndex(@NotNull StubBasedPsiElement psi) {
        Object liveStub;
        if (psi == null) {
            PsiAnchor.$$$reportNull$$$0(18);
        }
        if (psi instanceof PsiFile) {
            return 0;
        }
        Object object = liveStub = psi instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)((Object)psi)).getGreenStub() : psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).id;
        }
        return ((PsiFileImpl)psi.getContainingFile()).calcTreeElement().getStubbedSpine().getStubIndex(psi);
    }

    @Nullable
    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index2, @NotNull IStubElementType elementType, boolean throwIfNull) {
        if (elementType == null) {
            PsiAnchor.$$$reportNull$$$0(19);
        }
        if (fileImpl == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)"Null file");
            }
            return null;
        }
        if (index2 == 0) {
            return fileImpl;
        }
        StubbedSpine spine = fileImpl.getStubbedSpine();
        StubBasedPsiElement psi = (StubBasedPsiElement)spine.getStubPsi(index2);
        if (psi == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Too large index: " + index2 + ">=" + spine.getStubCount()));
            }
            return null;
        }
        if (psi.getElementType() != elementType) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Element type mismatch: " + psi.getElementType() + "!=" + elementType));
            }
            return null;
        }
        return psi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiAnchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiAnchor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAnchor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapperOrHardReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAnchor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapperOrHardReference";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createStubReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calcStubIndex";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "restoreFromStubIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StubIndexReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final int myIndex;
        private final Language myLanguage;
        private final IStubElementType myElementType;

        private StubIndexReference(@NotNull PsiFile file2, int index2, @NotNull Language language, @NotNull IStubElementType elementType) {
            if (file2 == null) {
                StubIndexReference.$$$reportNull$$$0(0);
            }
            if (language == null) {
                StubIndexReference.$$$reportNull$$$0(1);
            }
            if (elementType == null) {
                StubIndexReference.$$$reportNull$$$0(2);
            }
            this.myLanguage = language;
            this.myElementType = elementType;
            this.myVirtualFile = file2.getVirtualFile();
            this.myProject = file2.getProject();
            this.myIndex = index2;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            if (this.myProject.isDisposed() || !this.myVirtualFile.isValid()) {
                return null;
            }
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(this.myVirtualFile);
            PsiFile file2 = viewProvider == null ? null : viewProvider.getPsi(this.myLanguage);
            return file2 instanceof PsiFileWithStubSupport ? file2 : null;
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)this.getFile(), this.myIndex, this.myElementType, false));
        }

        public String diagnoseNull() {
            PsiFile file2 = ReadAction.compute(() -> this.getFile());
            try {
                PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)file2, this.myIndex, this.myElementType, true));
                return "No diagnostics, element=" + element + "@" + (element == null ? 0 : System.identityHashCode(element));
            }
            catch (AssertionError e) {
                String msg = ((Throwable)((Object)e)).getMessage();
                msg = msg + (file2 == null ? "\n no PSI file" : "\n current file stamp=" + (short)file2.getModificationStamp());
                Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
                if (document != null) {
                    msg = msg + "\n committed=" + PsiDocumentManager.getInstance(this.myProject).isCommitted(document);
                    msg = msg + "\n saved=" + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
                }
                return msg;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o;
            return this.myIndex == that.myIndex && this.myVirtualFile.equals(that.myVirtualFile) && Comparing.equal(this.myElementType, that.myElementType) && this.myLanguage == that.myLanguage;
        }

        public int hashCode() {
            return ((31 * this.myVirtualFile.hashCode() + this.myIndex) * 31 + (this.myElementType == null ? 0 : this.myElementType.hashCode())) * 31 + this.myLanguage.hashCode();
        }

        @NonNls
        public String toString() {
            return "StubIndexReference{myVirtualFile=" + this.myVirtualFile + ", myProject=" + this.myProject + ", myIndex=" + this.myIndex + ", myLanguage=" + this.myLanguage + ", myElementType=" + this.myElementType + '}';
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getEndOffset();
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                StubIndexReference.$$$reportNull$$$0(3);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/PsiAnchor$StubIndexReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/PsiAnchor$StubIndexReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PsiDirectoryReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;

        private PsiDirectoryReference(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                PsiDirectoryReference.$$$reportNull$$$0(0);
            }
            if (project == null) {
                PsiDirectoryReference.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myProject = project;
            assert (file2.isDirectory()) : file2;
        }

        @Override
        public PsiElement retrieve() {
            return SelfElementInfo.restoreDirectoryFromVirtual(this.myFile, this.myProject);
        }

        @Override
        public PsiFile getFile() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiDirectoryReference)) {
                return false;
            }
            PsiDirectoryReference reference = (PsiDirectoryReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/PsiAnchor$PsiDirectoryReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PsiFileReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;
        @NotNull
        private final Language myLanguage;

        private PsiFileReference(@NotNull VirtualFile file2, @NotNull PsiFile psiFile) {
            if (file2 == null) {
                PsiFileReference.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                PsiFileReference.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myProject = psiFile.getProject();
            this.myLanguage = PsiFileReference.findLanguage(psiFile);
        }

        private static Language findLanguage(PsiFile file2) {
            FileViewProvider vp = file2.getViewProvider();
            Set<Language> languages = vp.getLanguages();
            for (Language language : languages) {
                if (!file2.equals(vp.getPsi(language))) continue;
                return language;
            }
            throw new AssertionError((Object)("Non-retrievable file: " + file2.getClass() + "; " + file2.getLanguage() + "; " + languages));
        }

        @Override
        public PsiElement retrieve() {
            return this.getFile();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myFile, this.myProject, this.myLanguage);
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return (int)this.myFile.getLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiFileReference)) {
                return false;
            }
            PsiFileReference reference = (PsiFileReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            if (!this.myLanguage.equals(reference.myLanguage)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myLanguage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/PsiAnchor$PsiFileReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        public HardReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }
    }

    private static class TreeRangeReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final Identikit myInfo;
        private final int myStartOffset;
        private final int myEndOffset;

        private TreeRangeReference(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Identikit info, @NotNull VirtualFile virtualFile2) {
            if (file2 == null) {
                TreeRangeReference.$$$reportNull$$$0(0);
            }
            if (info == null) {
                TreeRangeReference.$$$reportNull$$$0(1);
            }
            if (virtualFile2 == null) {
                TreeRangeReference.$$$reportNull$$$0(2);
            }
            this.myVirtualFile = virtualFile2;
            this.myProject = file2.getProject();
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myInfo = info;
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiFile psiFile = this.getFile();
            if (psiFile == null || !psiFile.isValid()) {
                return null;
            }
            return this.myInfo.findPsiElement(psiFile, this.myStartOffset, this.myEndOffset);
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myInfo.getFileLanguage());
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o;
            return this.myEndOffset == that.myEndOffset && this.myStartOffset == that.myStartOffset && this.myInfo.equals(that.myInfo) && this.myVirtualFile.equals(that.myVirtualFile);
        }

        public int hashCode() {
            int result2 = this.myInfo.hashCode();
            result2 = 31 * result2 + this.myStartOffset;
            result2 = 31 * result2 + this.myEndOffset;
            result2 = 31 * result2 + this.myVirtualFile.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/PsiAnchor$TreeRangeReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

