/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeableMappedFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ResizeableMappedFile");
    private long myLogicalSize;
    private final PagedFileStorage myStorage;

    public ResizeableMappedFile(@NotNull File file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResizeableMappedFile(@NotNull File file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.myStorage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        boolean exists = file2.exists();
        if (!exists || file2.length() == 0L) {
            if (!exists) {
                FileUtil.createParentDirs(file2);
            }
            this.writeLength(0L);
        }
        this.myLogicalSize = this.readLength();
        if (this.myLogicalSize == 0L) {
            try {
                this.getPagedFileStorage().lock();
                this.myStorage.resize(initialSize);
            }
            finally {
                this.getPagedFileStorage().unlock();
            }
        }
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    private void resize(long size) {
        try {
            this.myStorage.resize(size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    private void expand(long max) {
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        long suggestedSize = Math.max(realSize + 1L, 2L);
        while (max > suggestedSize) {
            long newSuggestedSize = suggestedSize * 13L >> 3;
            if (newSuggestedSize >= Integer.MAX_VALUE) {
                suggestedSize += suggestedSize / 5L;
                continue;
            }
            suggestedSize = newSuggestedSize;
        }
        int roundFactor = PersistentBTreeEnumerator.PAGE_SIZE;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        this.resize(suggestedSize);
    }

    private File getLengthFile() {
        return new File(this.myStorage.getFile().getPath() + ".len");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(long len) {
        final File lengthFile = this.getLengthFile();
        FilterOutputStream stream2 = null;
        try {
            stream2 = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public DataOutputStream execute(boolean lastAttempt) throws IOException {
                    try {
                        return new DataOutputStream(new FileOutputStream(lengthFile));
                    }
                    catch (FileNotFoundException ex) {
                        File parentFile = lengthFile.getParentFile();
                        if (!parentFile.exists()) {
                            if (!this.parentWasCreated) {
                                parentFile.mkdirs();
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent file still doesn't exist:" + lengthFile);
                            }
                        }
                        if (!lastAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
            if (stream2 != null) {
                ((java.io.DataOutputStream)stream2).writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    public void force() {
        if (this.isDirty()) {
            this.writeLength(this.myLogicalSize);
        }
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLength() {
        File lengthFile = this.getLengthFile();
        FilterInputStream stream2 = null;
        try {
            stream2 = new DataInputStream(new FileInputStream(lengthFile));
            long l = ((DataInputStream)stream2).readLong();
            return l;
        }
        catch (IOException e) {
            this.writeLength(this.realSize());
            long l = this.realSize();
            return l;
        }
        finally {
            if (stream2 != null) {
                try {
                    stream2.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public int getInt(long index2) {
        return this.myStorage.getInt(index2);
    }

    public void putInt(long index2, int value) {
        this.ensureSize(index2 + 4L);
        this.myStorage.putInt(index2, value);
    }

    public long getLong(long index2) {
        return this.myStorage.getLong(index2);
    }

    public void putLong(long index2, long value) {
        this.ensureSize(index2 + 8L);
        this.myStorage.putLong(index2, value);
    }

    public byte get(long index2) {
        return this.myStorage.get(index2);
    }

    public void get(long index2, byte[] dst, int offset2, int length) {
        this.myStorage.get(index2, dst, offset2, length);
    }

    public void put(long index2, byte[] src, int offset2, int length) {
        this.ensureSize(index2 + (long)length);
        this.myStorage.put(index2, src, offset2, length);
    }

    public void close() {
        try {
            this.force();
        }
        finally {
            this.myStorage.close();
        }
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

