/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.callback.CallbackImplementor;
import org.zaproxy.zap.extension.callback.CallbackParam;
import org.zaproxy.zap.extension.callback.OptionsCallbackPanel;

public class ExtensionCallback
extends ExtensionAdaptor
implements OptionsChangedListener {
    private static final String TEST_PREFIX = "ZapTest";
    private static final String NAME = "ExtensionCallback";
    private ProxyServer proxyServer;
    private CallbackParam callbackParam;
    private OptionsCallbackPanel optionsCallbackPanel;
    private Map<String, CallbackImplementor> callbacks = new HashMap<String, CallbackImplementor>();
    private int actualPort;
    private String currentConfigLocalAddress;
    private int currentConfigPort;
    private static final Logger LOGGER = Logger.getLogger(ExtensionCallback.class);

    public ExtensionCallback() {
        this.proxyServer = new ProxyServer("ZAP-CallbackServer");
        this.proxyServer.addOverrideMessageProxyListener(new CallbackProxyListener());
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("callback.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getCallbackParam());
        extensionHook.addOptionsChangedListener(this);
        if (View.isInitialised()) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsCallbackPanel());
        }
    }

    @Override
    public void optionsLoaded() {
        this.proxyServer.setConnectionParam(this.getModel().getOptionsParam().getConnectionParam());
        this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
        this.currentConfigPort = this.getCallbackParam().getPort();
    }

    @Override
    public void postInit() {
        this.restartServer(this.getCallbackParam().getPort());
    }

    private void restartServer(int port) {
        this.actualPort = this.proxyServer.startServer(this.getCallbackParam().getLocalAddress(), port, true);
        LOGGER.info((Object)("Started callback server on " + this.getCallbackParam().getLocalAddress() + ":" + this.actualPort));
    }

    public String getCallbackAddress() {
        String addr = this.getCallbackParam().getRemoteAddress();
        boolean ipv6 = addr.contains(":");
        String hostname = ipv6 ? "[" + addr + "]" : addr;
        boolean isSecure = this.getCallbackParam().isSecure();
        String scheme = isSecure ? "https" : "http";
        return scheme + "://" + hostname + ":" + this.actualPort + "/";
    }

    public String getTestUrl() {
        return this.getCallbackAddress() + TEST_PREFIX;
    }

    protected int getPort() {
        return this.actualPort;
    }

    public void registerCallbackImplementor(CallbackImplementor impl) {
        for (String prefix : impl.getCallbackPrefixes()) {
            LOGGER.debug((Object)("Registering callback prefix: " + prefix));
            if (this.callbacks.containsKey(prefix)) {
                LOGGER.error((Object)("Duplicate callback prefix: " + prefix));
            }
            this.callbacks.put("/" + prefix, impl);
        }
    }

    public void removeCallbackImplementor(CallbackImplementor impl) {
        for (String shortcut : impl.getCallbackPrefixes()) {
            String key = "/" + shortcut;
            if (!this.callbacks.containsKey(key)) continue;
            LOGGER.debug((Object)("Removing registered callback prefix: " + shortcut));
            this.callbacks.remove(key);
        }
    }

    private CallbackParam getCallbackParam() {
        if (this.callbackParam == null) {
            this.callbackParam = new CallbackParam();
        }
        return this.callbackParam;
    }

    private OptionsCallbackPanel getOptionsCallbackPanel() {
        if (this.optionsCallbackPanel == null) {
            this.optionsCallbackPanel = new OptionsCallbackPanel(this);
        }
        return this.optionsCallbackPanel;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("callback.desc");
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        if (!this.currentConfigLocalAddress.equals(this.getCallbackParam().getLocalAddress()) || this.currentConfigPort != this.getCallbackParam().getPort()) {
            int port = this.actualPort;
            if (this.currentConfigPort != this.getCallbackParam().getPort()) {
                port = this.getCallbackParam().getPort();
            }
            this.restartServer(port);
            this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
            this.currentConfigPort = this.getCallbackParam().getPort();
        }
    }

    private class CallbackProxyListener
    implements OverrideMessageProxyListener {
        private CallbackProxyListener() {
        }

        @Override
        public int getArrangeableListenerOrder() {
            return 0;
        }

        @Override
        public boolean onHttpRequestSend(HttpMessage msg) {
            try {
                String url = msg.getRequestHeader().getURI().toString();
                String path = msg.getRequestHeader().getURI().getPath();
                LOGGER.debug((Object)("Callback received for URL : " + url + " path : " + path + " from " + msg.getRequestHeader().getSenderAddress()));
                msg.setResponseHeader("HTTP/1.1 200");
                if (path.startsWith("/ZapTest")) {
                    String str = Constant.messages.getString("callback.test.msg", url, msg.getRequestHeader().getSenderAddress().toString());
                    if (View.isInitialised()) {
                        View.getSingleton().getOutputPanel().appendAsync(str + "\n");
                    }
                    LOGGER.info((Object)str);
                    return true;
                }
                if (path.startsWith("/favicon.ico")) {
                    return true;
                }
                for (Map.Entry callback : ExtensionCallback.this.callbacks.entrySet()) {
                    if (!path.startsWith((String)callback.getKey())) continue;
                    ((CallbackImplementor)callback.getValue()).handleCallBack(msg.cloneAll());
                    return true;
                }
                LOGGER.error((Object)("No callback handler for URL : " + url + " from " + msg.getRequestHeader().getSenderAddress()));
            }
            catch (URIException | HttpMalformedHeaderException e) {
                LOGGER.error((Object)e.getMessage(), e);
            }
            return true;
        }

        @Override
        public boolean onHttpResponseReceived(HttpMessage msg) {
            return true;
        }
    }
}

