/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectProxySeqHelper;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.LoadSample;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface Query
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public ObjectPrx findObjectById(Identity var1, Current var2);

    public ObjectPrx findObjectByType(String var1, Current var2);

    public ObjectPrx findObjectByTypeOnLeastLoadedNode(String var1, LoadSample var2, Current var3);

    public ObjectPrx[] findAllObjectsByType(String var1, Current var2);

    public ObjectPrx[] findAllReplicas(ObjectPrx var1, Current var2);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return Query.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::Query";
    }

    public static CompletionStage<OutputStream> _iceD_findObjectById(Query obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read(istr);
        inS.endReadParams();
        ObjectPrx ret = obj.findObjectById(iceP_id, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_findObjectByType(Query obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_type = istr.readString();
        inS.endReadParams();
        ObjectPrx ret = obj.findObjectByType(iceP_type, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_findObjectByTypeOnLeastLoadedNode(Query obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_type = istr.readString();
        LoadSample iceP_sample = LoadSample.ice_read(istr);
        inS.endReadParams();
        ObjectPrx ret = obj.findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_findAllObjectsByType(Query obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_type = istr.readString();
        inS.endReadParams();
        ObjectPrx[] ret = obj.findAllObjectsByType(iceP_type, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_findAllReplicas(Query obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_proxy = istr.readProxy();
        inS.endReadParams();
        ObjectPrx[] ret = obj.findAllReplicas(iceP_proxy, current);
        OutputStream ostr = inS.startWriteParams();
        ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Query._iceD_findAllObjectsByType(this, in, current);
            }
            case 1: {
                return Query._iceD_findAllReplicas(this, in, current);
            }
            case 2: {
                return Query._iceD_findObjectById(this, in, current);
            }
            case 3: {
                return Query._iceD_findObjectByType(this, in, current);
            }
            case 4: {
                return Query._iceD_findObjectByTypeOnLeastLoadedNode(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 7: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 8: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::Query"};
        _iceOps = new String[]{"findAllObjectsByType", "findAllReplicas", "findObjectById", "findObjectByType", "findObjectByTypeOnLeastLoadedNode", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

