/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AdapterNotFoundException;
import Ice.Callback_Locator_findAdapterById;
import Ice.Callback_Locator_findObjectById;
import Ice.EndpointSelectionType;
import Ice.Holder;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UserException;
import Ice.Util;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorTable;
import IceInternal.Protocol;
import IceInternal.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;
    private final boolean _background;
    private Map<String, Request> _adapterRequests = new HashMap<String, Request>();
    private Map<Identity, Request> _objectRequests = new HashMap<Identity, Request>();

    LocatorInfo(LocatorPrx locator, LocatorTable table, boolean background) {
        this._locator = locator;
        this._table = table;
        this._background = background;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocatorInfo) {
            return this._locator.equals(((LocatorInfo)obj)._locator);
        }
        return false;
    }

    public int hashCode() {
        return this._locator.hashCode();
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorRegistryPrx getLocatorRegistry() {
        LocatorInfo locatorInfo = this;
        synchronized (locatorInfo) {
            if (this._locatorRegistry != null) {
                return this._locatorRegistry;
            }
        }
        LocatorRegistryPrx locatorRegistry = this._locator.getRegistry();
        if (locatorRegistry == null) {
            return null;
        }
        LocatorInfo locatorInfo2 = this;
        synchronized (locatorInfo2) {
            this._locatorRegistry = (LocatorRegistryPrx)locatorRegistry.ice_locator(null).ice_endpointSelection(EndpointSelectionType.Ordered);
            return this._locatorRegistry;
        }
    }

    public void getEndpoints(Reference ref, int ttl, GetEndpointsCallback callback) {
        this.getEndpoints(ref, null, ttl, callback);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getEndpoints(Reference ref, Reference wellKnownRef, int ttl, GetEndpointsCallback callback) {
        assert (ref.isIndirect());
        EndpointI[] endpoints = null;
        Holder<Boolean> cached = new Holder<Boolean>();
        if (!ref.isWellKnown()) {
            endpoints = this._table.getAdapterEndpoints(ref.getAdapterId(), ttl, cached);
            if (!((Boolean)cached.value).booleanValue()) {
                if (this._background && endpoints != null) {
                    this.getAdapterRequest(ref).addCallback(ref, wellKnownRef, ttl, null);
                } else {
                    this.getAdapterRequest(ref).addCallback(ref, wellKnownRef, ttl, callback);
                    return;
                }
            }
        } else {
            Reference r = this._table.getObjectReference(ref.getIdentity(), ttl, cached);
            if (!((Boolean)cached.value).booleanValue()) {
                if (this._background && r != null) {
                    this.getObjectRequest(ref).addCallback(ref, null, ttl, null);
                } else {
                    this.getObjectRequest(ref).addCallback(ref, null, ttl, callback);
                    return;
                }
            }
            if (!r.isIndirect()) {
                endpoints = r.getEndpoints();
            } else if (!r.isWellKnown()) {
                if (ref.getInstance().traceLevels().location >= 1) {
                    this.trace("found adapter for well-known object in locator cache", ref, r);
                }
                this.getEndpoints(r, ref, ttl, callback);
                return;
            }
        }
        assert (endpoints != null);
        if (ref.getInstance().traceLevels().location >= 1) {
            this.getEndpointsTrace(ref, endpoints, true);
        }
        if (callback != null) {
            callback.setEndpoints(endpoints, true);
        }
    }

    public void clearCache(Reference ref) {
        assert (ref.isIndirect());
        if (!ref.isWellKnown()) {
            EndpointI[] endpoints = this._table.removeAdapterEndpoints(ref.getAdapterId());
            if (endpoints != null && ref.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints for adapter from locator cache", ref, endpoints);
            }
        } else {
            Reference r = this._table.removeObjectReference(ref.getIdentity());
            if (r != null) {
                if (!r.isIndirect()) {
                    if (ref.getInstance().traceLevels().location >= 2) {
                        this.trace("removed endpoints for well-known object from locator cache", ref, r.getEndpoints());
                    }
                } else if (!r.isWellKnown()) {
                    if (ref.getInstance().traceLevels().location >= 2) {
                        this.trace("removed adapter for well-known object from locator cache", ref, r);
                    }
                    this.clearCache(r);
                }
            }
        }
    }

    private void trace(String msg, Reference ref, EndpointI[] endpoints) {
        assert (ref.isIndirect());
        StringBuilder s = new StringBuilder(128);
        s.append(msg);
        s.append("\n");
        if (!ref.isWellKnown()) {
            s.append("adapter = ");
            s.append(ref.getAdapterId());
            s.append("\n");
        } else {
            s.append("well-known proxy = ");
            s.append(ref.toString());
            s.append("\n");
        }
        s.append("endpoints = ");
        int sz = endpoints.length;
        for (int i = 0; i < sz; ++i) {
            s.append(endpoints[i].toString());
            if (i + 1 >= sz) continue;
            s.append(":");
        }
        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
    }

    private void trace(String msg, Reference ref, Reference resolved) {
        assert (ref.isWellKnown());
        StringBuilder s = new StringBuilder(128);
        s.append(msg);
        s.append("\n");
        s.append("well-known proxy = ");
        s.append(ref.toString());
        s.append("\n");
        s.append("adapter = ");
        s.append(resolved.getAdapterId());
        ref.getInstance().initializationData().logger.trace(ref.getInstance().traceLevels().locationCat, s.toString());
    }

    private void getEndpointsException(Reference ref, Exception exc) {
        assert (ref.isIndirect());
        try {
            throw exc;
        }
        catch (AdapterNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("adapter not found\n");
                s.append("adapter = ");
                s.append(ref.getAdapterId());
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object adapter";
            e.id = ref.getAdapterId();
            throw e;
        }
        catch (ObjectNotFoundException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("object not found\n");
                s.append("object = ");
                s.append(Util.identityToString(ref.getIdentity(), instance.toStringMode()));
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object";
            e.id = Util.identityToString(ref.getIdentity(), instance.toStringMode());
            throw e;
        }
        catch (NotRegisteredException ex) {
            throw ex;
        }
        catch (LocalException ex) {
            Instance instance = ref.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't contact the locator to retrieve endpoints\n");
                if (ref.getAdapterId().length() > 0) {
                    s.append("adapter = ");
                    s.append(ref.getAdapterId());
                    s.append("\n");
                } else {
                    s.append("well-known proxy = ");
                    s.append(ref.toString());
                    s.append("\n");
                }
                s.append("reason = " + ex);
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
            }
            throw ex;
        }
        catch (Exception ex) {
            assert (false);
            return;
        }
    }

    private void getEndpointsTrace(Reference ref, EndpointI[] endpoints, boolean cached) {
        if (endpoints != null && endpoints.length > 0) {
            if (cached) {
                if (ref.isWellKnown()) {
                    this.trace("found endpoints for well-known proxy in locator cache", ref, endpoints);
                } else {
                    this.trace("found endpoints for adapter in locator cache", ref, endpoints);
                }
            } else if (ref.isWellKnown()) {
                this.trace("retrieved endpoints for well-known proxy from locator, adding to locator cache", ref, endpoints);
            } else {
                this.trace("retrieved endpoints for adapter from locator, adding to locator cache", ref, endpoints);
            }
        } else {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("no endpoints configured for ");
            if (ref.getAdapterId().length() > 0) {
                s.append("adapter\n");
                s.append("adapter = ");
                s.append(ref.getAdapterId());
                s.append("\n");
            } else {
                s.append("well-known object\n");
                s.append("well-known proxy = ");
                s.append(ref.toString());
                s.append("\n");
            }
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
    }

    private synchronized Request getAdapterRequest(Reference ref) {
        Request request;
        if (ref.getInstance().traceLevels().location >= 1) {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("searching for adapter by id\n");
            s.append("adapter = ");
            s.append(ref.getAdapterId());
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
        if ((request = this._adapterRequests.get(ref.getAdapterId())) != null) {
            return request;
        }
        request = new AdapterRequest(this, ref);
        this._adapterRequests.put(ref.getAdapterId(), request);
        return request;
    }

    private synchronized Request getObjectRequest(Reference ref) {
        Request request;
        if (ref.getInstance().traceLevels().location >= 1) {
            Instance instance = ref.getInstance();
            StringBuilder s = new StringBuilder(128);
            s.append("searching for well-known object\n");
            s.append("well-known proxy = ");
            s.append(ref.toString());
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, s.toString());
        }
        if ((request = this._objectRequests.get(ref.getIdentity())) != null) {
            return request;
        }
        request = new ObjectRequest(this, ref);
        this._objectRequests.put(ref.getIdentity(), request);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRequest(Reference ref, List<Reference> wellKnownRefs, ObjectPrx proxy, boolean notRegistered) {
        Object object;
        if (proxy == null || ((ObjectPrxHelperBase)proxy)._getReference().isIndirect()) {
            for (Reference r : wellKnownRefs) {
                this._table.removeObjectReference(r.getIdentity());
            }
        }
        if (!ref.isWellKnown()) {
            if (proxy != null && !((ObjectPrxHelperBase)proxy)._getReference().isIndirect()) {
                this._table.addAdapterEndpoints(ref.getAdapterId(), ((ObjectPrxHelperBase)proxy)._getReference().getEndpoints());
            } else if (notRegistered) {
                this._table.removeAdapterEndpoints(ref.getAdapterId());
            }
            object = this;
            synchronized (object) {
                assert (this._adapterRequests.get(ref.getAdapterId()) != null);
                this._adapterRequests.remove(ref.getAdapterId());
            }
        }
        if (proxy != null && !((ObjectPrxHelperBase)proxy)._getReference().isWellKnown()) {
            this._table.addObjectReference(ref.getIdentity(), ((ObjectPrxHelperBase)proxy)._getReference());
        } else if (notRegistered) {
            this._table.removeObjectReference(ref.getIdentity());
        }
        object = this;
        synchronized (object) {
            assert (this._objectRequests.get(ref.getIdentity()) != null);
            this._objectRequests.remove(ref.getIdentity());
        }
    }

    private class AdapterRequest
    extends Request {
        public AdapterRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isIndirect());
        }

        @Override
        protected void send() {
            try {
                this._locatorInfo.getLocator().begin_findAdapterById(this._ref.getAdapterId(), new Callback_Locator_findAdapterById(){

                    @Override
                    public void response(ObjectPrx proxy) {
                        AdapterRequest.this.response(proxy);
                    }

                    @Override
                    public void exception(UserException ex) {
                        AdapterRequest.this.exception(ex);
                    }

                    @Override
                    public void exception(LocalException ex) {
                        AdapterRequest.this.exception(ex);
                    }
                });
            }
            catch (Exception ex) {
                this.exception(ex);
            }
        }
    }

    private class ObjectRequest
    extends Request {
        public ObjectRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isWellKnown());
        }

        @Override
        protected void send() {
            try {
                this._locatorInfo.getLocator().begin_findObjectById(this._ref.getIdentity(), new Callback_Locator_findObjectById(){

                    @Override
                    public void response(ObjectPrx proxy) {
                        ObjectRequest.this.response(proxy);
                    }

                    @Override
                    public void exception(UserException ex) {
                        ObjectRequest.this.exception(ex);
                    }

                    @Override
                    public void exception(LocalException ex) {
                        ObjectRequest.this.exception(ex);
                    }
                });
            }
            catch (Exception ex) {
                this.exception(ex);
            }
        }
    }

    private abstract class Request {
        protected final LocatorInfo _locatorInfo;
        protected final Reference _ref;
        private List<RequestCallback> _callbacks = new ArrayList<RequestCallback>();
        private List<Reference> _wellKnownRefs = new ArrayList<Reference>();
        private boolean _sent;
        private boolean _response;
        private ObjectPrx _proxy;
        private Exception _exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(Reference ref, Reference wellKnownRef, int ttl, GetEndpointsCallback cb) {
            RequestCallback callback = new RequestCallback(ref, ttl, cb);
            Request request = this;
            synchronized (request) {
                if (!this._response && this._exception == null) {
                    this._callbacks.add(callback);
                    if (wellKnownRef != null) {
                        this._wellKnownRefs.add(wellKnownRef);
                    }
                    if (!this._sent) {
                        this._sent = true;
                        this.send();
                    }
                    return;
                }
            }
            if (this._response) {
                callback.response(this._locatorInfo, this._proxy);
            } else {
                assert (this._exception != null);
                callback.exception(this._locatorInfo, this._exception);
            }
        }

        Request(LocatorInfo locatorInfo2, Reference ref) {
            this._locatorInfo = locatorInfo2;
            this._ref = ref;
            this._sent = false;
            this._response = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void response(ObjectPrx proxy) {
            Request request = this;
            synchronized (request) {
                this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, proxy, false);
                this._response = true;
                this._proxy = proxy;
                this.notifyAll();
            }
            for (RequestCallback callback : this._callbacks) {
                callback.response(this._locatorInfo, proxy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exception(Exception ex) {
            Request request = this;
            synchronized (request) {
                this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, null, ex instanceof UserException);
                this._exception = ex;
                this.notifyAll();
            }
            for (RequestCallback callback : this._callbacks) {
                callback.exception(this._locatorInfo, ex);
            }
        }

        protected abstract void send();
    }

    private static class RequestCallback {
        final Reference _ref;
        final int _ttl;
        final GetEndpointsCallback _callback;

        public void response(LocatorInfo locatorInfo, ObjectPrx proxy) {
            EndpointI[] endpoints = null;
            if (proxy != null) {
                Reference r = ((ObjectPrxHelperBase)proxy)._getReference();
                if (!this._ref.isWellKnown() || Protocol.isSupported(this._ref.getEncoding(), r.getEncoding())) {
                    if (!r.isIndirect()) {
                        endpoints = r.getEndpoints();
                    } else if (this._ref.isWellKnown() && !r.isWellKnown()) {
                        if (this._ref.getInstance().traceLevels().location >= 1) {
                            locatorInfo.trace("retrieved adapter for well-known object from locator, adding to locator cache", this._ref, r);
                        }
                        locatorInfo.getEndpoints(r, this._ref, this._ttl, this._callback);
                        return;
                    }
                }
            }
            if (this._ref.getInstance().traceLevels().location >= 1) {
                locatorInfo.getEndpointsTrace(this._ref, endpoints, false);
            }
            if (this._callback != null) {
                this._callback.setEndpoints(endpoints == null ? new EndpointI[]{} : endpoints, false);
            }
        }

        public void exception(LocatorInfo locatorInfo, Exception exc) {
            block2: {
                try {
                    locatorInfo.getEndpointsException(this._ref, exc);
                }
                catch (LocalException ex) {
                    if (this._callback == null) break block2;
                    this._callback.setException(ex);
                }
            }
        }

        RequestCallback(Reference ref, int ttl, GetEndpointsCallback cb) {
            this._ref = ref;
            this._ttl = ttl;
            this._callback = cb;
        }
    }

    static interface GetEndpointsCallback {
        public void setEndpoints(EndpointI[] var1, boolean var2);

        public void setException(LocalException var1);
    }
}

