/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import tim.prune.jpeg.drew.JpegException;
import tim.prune.jpeg.drew.JpegSegmentData;

public class JpegSegmentReader {
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    private static final byte SEGMENT_APP1 = -31;
    private static final int MAGIC_JPEG_BYTE_1 = 255;
    private static final int MAGIC_JPEG_BYTE_2 = 216;

    public static byte[] readExifSegment(File file) throws JpegException {
        JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(file);
        return jpegSegmentData.getSegment((byte)-31);
    }

    private static JpegSegmentData readSegments(File file) throws JpegException {
        JpegSegmentData jpegSegmentData = new JpegSegmentData();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                byte by;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                int n = bufferedInputStream.read() & 0xFF;
                int n2 = bufferedInputStream.read() & 0xFF;
                if (n != 255 || n2 != 216) {
                    throw new JpegException("not a jpeg file");
                }
                boolean bl = false;
                do {
                    byte by2;
                    if (((by2 = (byte)(bufferedInputStream.read() & 0xFF)) & 0xFF) != 255) {
                        throw new JpegException("expected jpeg segment start 0xFF, not 0x" + Integer.toHexString(by2 & 0xFF));
                    }
                    by = (byte)(bufferedInputStream.read() & 0xFF);
                    byte[] byArray = new byte[2];
                    bufferedInputStream.read(byArray, 0, 2);
                    int n3 = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
                    if ((n3 -= 2) > bufferedInputStream.available()) {
                        throw new JpegException("segment size would extend beyond file stream length");
                    }
                    if (n3 < 0) {
                        throw new JpegException("segment size would be less than zero");
                    }
                    byte[] byArray2 = new byte[n3];
                    int n4 = bufferedInputStream.read(byArray2, 0, n3);
                    if (n4 != n3) {
                        throw new JpegException("Tried to read " + n3 + " bytes but only got " + n4);
                    }
                    if ((by & 0xFF) == 218) {
                        break;
                    }
                    if ((by & 0xFF) == 217) {
                        break;
                    }
                    jpegSegmentData.addSegment(by, byArray2);
                } while (!(bl = by == -31));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JpegException("Jpeg file not found");
            }
            catch (IOException iOException) {
                throw new JpegException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new JpegException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
        return jpegSegmentData;
    }
}

