/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.DefaultProjectPathRegistry;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements IncludedBuildRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final DefaultProjectPathRegistry projectRegistry;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final Map<File, IncludedBuildInternal> includedBuilds = Maps.newLinkedHashMap();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, DefaultProjectPathRegistry projectRegistry, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, CompositeBuildContext compositeBuildContext) {
        this.includedBuildFactory = includedBuildFactory;
        this.projectRegistry = projectRegistry;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        compositeBuildContext.setIncludedBuildRegistry((IncludedBuildRegistry)this);
    }

    public boolean hasIncludedBuilds() {
        return !this.includedBuilds.isEmpty();
    }

    public Collection<IncludedBuildInternal> getIncludedBuilds() {
        return this.includedBuilds.values();
    }

    public IncludedBuildInternal addExplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        return this.registerBuild(buildDefinition, nestedBuildFactory);
    }

    public IncludedBuildInternal getBuild(final BuildIdentifier buildIdentifier) {
        return (IncludedBuildInternal)CollectionUtils.findFirst(this.includedBuilds.values(), (Spec)new Spec<IncludedBuildInternal>(){

            public boolean isSatisfiedBy(IncludedBuildInternal includedBuild) {
                return includedBuild.getName().equals(buildIdentifier.getName());
            }
        });
    }

    public void validateExplicitIncludedBuilds(SettingsInternal settings) {
        this.validateIncludedBuilds(settings);
        this.registerRootBuildProjects(settings);
        Collection<IncludedBuildInternal> includedBuilds = this.getIncludedBuilds();
        ArrayList<ConfigurableIncludedBuild> modelElements = new ArrayList<ConfigurableIncludedBuild>(includedBuilds.size());
        for (IncludedBuildInternal includedBuild : includedBuilds) {
            modelElements.add(includedBuild.getModel());
        }
        settings.getGradle().setIncludedBuilds(modelElements);
        this.registerProjects(includedBuilds, false);
        this.registerSubstitutions(includedBuilds);
    }

    private void validateIncludedBuilds(SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuildInternal build : this.includedBuilds.values()) {
            String buildName = build.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuildInternal> includedBuilds) {
        for (IncludedBuildInternal includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build(includedBuild);
        }
    }

    public IncludedBuildInternal addImplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        IncludedBuildInternal includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, nestedBuildFactory);
            this.registerProjects(Collections.singletonList(includedBuild), true);
        }
        return includedBuild;
    }

    private IncludedBuildInternal registerBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        IncludedBuildInternal includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.includedBuildFactory.createBuild(buildDefinition, nestedBuildFactory);
            this.includedBuilds.put(buildDefinition.getBuildRootDir(), includedBuild);
        }
        return includedBuild;
    }

    private void registerRootBuildProjects(SettingsInternal settings) {
        ProjectRegistry settingsProjectRegistry = settings.getProjectRegistry();
        BuildIdentifier buildIdentifier = DefaultBuildIdentifier.ROOT;
        this.registerProjects(Path.ROOT, buildIdentifier, settingsProjectRegistry.getAllProjects(), false);
    }

    private void registerProjects(Iterable<IncludedBuildInternal> includedBuilds, boolean isImplicitBuild) {
        for (IncludedBuildInternal includedBuild : includedBuilds) {
            Path rootProjectPath = Path.ROOT.child(includedBuild.getName());
            DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(includedBuild.getName());
            Set allProjects = includedBuild.getLoadedSettings().getProjectRegistry().getAllProjects();
            this.registerProjects(rootProjectPath, (BuildIdentifier)buildIdentifier, allProjects, isImplicitBuild);
        }
    }

    private void registerProjects(Path rootPath, BuildIdentifier buildIdentifier, Set<DefaultProjectDescriptor> allProjects, boolean isImplicitBuild) {
        for (DefaultProjectDescriptor project : allProjects) {
            Path projectIdentityPath = rootPath.append(project.path());
            ProjectComponentIdentifier projectComponentIdentifier = DefaultProjectComponentIdentifier.newProjectId((BuildIdentifier)buildIdentifier, (String)project.getPath());
            this.projectRegistry.add(projectIdentityPath, project.getName(), projectComponentIdentifier, isImplicitBuild);
        }
    }

    public void stop() {
        CompositeStoppable.stoppable(this.includedBuilds.values()).stop();
    }
}

