/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class RenderableUnresolvedDependencyResult
implements RenderableDependency {
    private final UnresolvedDependencyResult dependency;

    public RenderableUnresolvedDependencyResult(UnresolvedDependencyResult dependency) {
        this.dependency = dependency;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return RenderableDependency.ResolutionState.FAILED;
    }

    public Set<RenderableDependency> getChildren() {
        return Collections.emptySet();
    }

    @Override
    public Object getId() {
        return this.dependency.getAttempted();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public ResolvedVariantResult getResolvedVariant() {
        return null;
    }

    @Override
    public String getName() {
        ComponentSelector attempted;
        ComponentSelector requested = this.dependency.getRequested();
        if (requested.equals(attempted = this.dependency.getAttempted())) {
            return requested.getDisplayName();
        }
        if (requested instanceof ModuleComponentSelector && attempted instanceof ModuleComponentSelector) {
            ModuleComponentSelector requestedSelector = (ModuleComponentSelector)requested;
            ModuleComponentSelector attemptedSelector = (ModuleComponentSelector)attempted;
            if (requestedSelector.getGroup().equals(attemptedSelector.getGroup()) && requestedSelector.getModule().equals(attemptedSelector.getModule()) && !requestedSelector.getVersionConstraint().equals(attemptedSelector.getVersionConstraint())) {
                return requested.getDisplayName() + " -> " + ((ModuleComponentSelector)attempted).getVersionConstraint().getPreferredVersion();
            }
        }
        return requested.getDisplayName() + " -> " + attempted.getDisplayName();
    }
}

