// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PLUGINFEATURE_H
#define _GSTREAMERMM_PLUGINFEATURE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/object.h>
#include <gstreamermm/plugin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstPluginFeature = struct _GstPluginFeature;
using GstPluginFeatureClass = struct _GstPluginFeatureClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class PluginFeature_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var Rank RANK_NONE
 * Will be chosen last or not at all.
 * 
 *  @var Rank RANK_MARGINAL
 * Unlikely to be chosen.
 * 
 *  @var Rank RANK_SECONDARY
 * Likely to be chosen.
 * 
 *  @var Rank RANK_PRIMARY
 * Will be chosen first.
 * 
 *  @enum Rank
 * 
 * Element priority ranks. Defines the order in which the autoplugger (or
 * similar rank-picking mechanisms, such as e.g. Gst::Element::make_from_uri())
 * will choose this element over an alternative one with the same function.
 * 
 * These constants serve as a rough guidance for defining the rank of a
 * Gst::PluginFeature. Any value is valid, including values bigger than
 *  @a GST_RANK_PRIMARY.
 *
 * @ingroup gstreamermmEnums
 */
enum Rank
{
  RANK_NONE = 0,
  RANK_MARGINAL = 64,
  RANK_SECONDARY = 128,
  RANK_PRIMARY = 256
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::Rank> : public Glib::Value_Enum<Gst::Rank>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** A base class for anything that can be added to a Gst::Plugin.
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 */

class PluginFeature : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = PluginFeature;
  using CppClassType = PluginFeature_Class;
  using BaseObjectType = GstPluginFeature;
  using BaseClassType = GstPluginFeatureClass;

  // noncopyable
  PluginFeature(const PluginFeature&) = delete;
  PluginFeature& operator=(const PluginFeature&) = delete;

private:  friend class PluginFeature_Class;
  static CppClassType pluginfeature_class_;

protected:
  explicit PluginFeature(const Glib::ConstructParams& construct_params);
  explicit PluginFeature(GstPluginFeature* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  PluginFeature(PluginFeature&& src) noexcept;
  PluginFeature& operator=(PluginFeature&& src) noexcept;

  ~PluginFeature() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPluginFeature*       gobj()       { return reinterpret_cast<GstPluginFeature*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPluginFeature* gobj() const { return reinterpret_cast<GstPluginFeature*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPluginFeature* gobj_copy();

private:


public:
  /** For example,
   * bool on_filter(const Glib::RefPtr<Gst::PluginFeature>& feature);.
   * The filter function should return true if the feature is a match, false
   * otherwise.
   */
  typedef sigc::slot< bool, const Glib::RefPtr<Gst::PluginFeature>& > SlotFilter;

  
  /** Specifies a rank for a plugin feature, so that autoplugging uses
   * the most appropriate feature.
   * 
   * @param rank Rank value - higher number means more priority rank.
   */
  void set_rank(guint rank);
  
  /** Gets the rank of a plugin feature.
   * 
   * @return The rank of the feature.
   */
  guint get_rank() const;
  
  /** Loads the plugin containing @a feature if it's not already loaded. @a feature is
   * unaffected; use the return value instead.
   * 
   * Normally this function is used like this:
   * 
   * [C example ellipted]
   * 
   * @return A reference to the loaded
   * feature, or <tt>nullptr</tt> on error.
   */
  Glib::RefPtr<Gst::PluginFeature> load();
  
  /** Get the plugin that provides this feature.
   * 
   * @return The plugin that provides this
   * feature, or <tt>nullptr</tt>.  Unref with Gst::Object::unref() when no
   * longer needed.
   */
  Glib::RefPtr<Gst::Plugin> get_plugin() const;
  
  /** Get the name of the plugin that provides this feature.
   * 
   * @return The name of the plugin that provides this
   * feature, or <tt>nullptr</tt> if the feature is not associated with a
   * plugin.
   */
  Glib::ustring get_plugin_name() const;

  // Don't wrap gst_plugin_feature_list_free because Glib::ListHandle<> handles
  // list freeing already.
  

  /** Checks whether the given plugin feature is at least
   * the required version
   * 
   * @param min_major Minimum required major version.
   * @param min_minor Minimum required minor version.
   * @param min_micro Minimum required micro version.
   * @return <tt>true</tt> if the plugin feature has at least
   * the required version, otherwise <tt>false</tt>.
   */
  bool check_version(guint min_major, guint min_minor, guint min_micro) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::PluginFeature
   */
  Glib::RefPtr<Gst::PluginFeature> wrap(GstPluginFeature* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_PLUGINFEATURE_H */

