/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.CharArrayReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = new Condition<Attribute>(){

        @Override
        public boolean value(Attribute attribute) {
            return !StringUtil.isEmpty(attribute.getValue());
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    public static void internElement(@NotNull Element element, @NotNull StringInterner interner) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        if (interner == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        element.setName(interner.intern(element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(interner.intern(attr.getName()));
            attr.setValue(interner.intern(attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                JDOMUtil.internElement((Element)o, interner);
                continue;
            }
            if (!(o instanceof Text)) continue;
            ((Text)o).setText(interner.intern(o.getValue()));
        }
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder(){

                @Override
                protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
                    super.configureParser(parser, contentHandler);
                    try {
                        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return inputSource;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$3", "resolveEntity"));
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    private static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream2) throws JDOMException, IOException {
        if (stream2 == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream2, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        InputStream stream2;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        if ((stream2 = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream2);
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 10: 
            case 40: 
            case 42: 
            case 47: 
            case 56: 
            case 57: 
            case 60: 
            case 62: 
            case 64: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 27: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 36: 
            case 38: 
            case 45: 
            case 50: 
            case 52: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 44: 
            case 49: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 58: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 71: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocument";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResourceDocument";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "printDocument";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 61: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputter";
                break;
            }
            case 72: 
            case 74: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTreeHash";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToHash";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 21: 
            case 24: 
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 23: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 46: 
            case 52: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "printDocument";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 71: 
            case 73: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }
}

