/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(27);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(51);
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        THashSet<T> tHashSet = new THashSet<T>(strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        THashSet<T> tHashSet = new THashSet<T>(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        THashSet<T> tHashSet = new THashSet<T>(elements);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        THashSet tHashSet = new THashSet(ContainerUtil.identityStrategy());
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        THashMap tHashMap = new THashMap(ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        if (concurrentHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        return concurrentHashMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        if (elements.isEmpty()) {
            List list2 = ContainerUtilRt.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(90);
            }
            return list2;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(102);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(103);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new THashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        ImmutableMapBuilder immutableMapBuilder = new ImmutableMapBuilder();
        if (immutableMapBuilder == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        return immutableMapBuilder;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<T> processor) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator2, @NotNull Condition<T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        while (iterator2.hasNext()) {
            V value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass2, @NotNull Function<T, V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass2, mapper);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass2, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        List<V> list2 = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass2, list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        if (collection.isEmpty()) {
            List<T> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(228);
            }
            return list2;
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        List<Object> list2 = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        List<Object> list2;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        if ((list2 = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(243);
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(260);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator2 = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result2 = this.next;
                        this.next = this.findNext();
                        return result2;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list2, int index1, int index2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        E e1 = list2.get(index1);
        E e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        return c;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<T> iterable, @NotNull Class<U> aClass2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass2);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<T> iterator2, @NotNull Class<U> aClass2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass2));
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<V, Collection<? extends T>> fun) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        List<? extends T> list2 = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(305);
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(306);
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                ContainerUtil.$$$reportNull$$$0(307);
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list2, @NotNull Function<V, Collection<? extends T>> listGenerator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v : list2) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        return list2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<T> iterator2, final @NotNull Function<T, U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        Iterator iterator3 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
        if (iterator3 == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        return iterator3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory2) {
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        T[] TArray = c != null ? c.toArray(factory2.create(c.size())) : factory2.create(0);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            Collections.sort(list2, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        List<V> list2 = ContainerUtilRt.map2List(iterable, mapping2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        List<V> list2 = ContainerUtil.mapNotNull(Arrays.asList(array), mapping2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        if (iterable.isEmpty()) {
            List<T> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(387);
            }
            return list2;
        }
        ArrayList<T> result2 = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<T, V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(399);
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet(items);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list2 = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        return list2;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<V> factory2) {
        V value;
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        if ((value = result2.get(key)) == null) {
            value = factory2.create();
            result2.put(key, value);
        }
        return value;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(427);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        ArrayList result2 = new ArrayList();
        for (Collection<E> list2 : collections) {
            result2.addAll(list2);
        }
        List list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(474);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(479);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            ContainerUtil.$$$reportNull$$$0(481);
        }
        return concurrentList;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(484);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(487);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(489);
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentIntKeyWeakValueHashMap concurrentIntKeyWeakValueHashMap = new ConcurrentIntKeyWeakValueHashMap();
        if (concurrentIntKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(490);
        }
        return concurrentIntKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(491);
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(492);
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(495);
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(496);
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(497);
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(498);
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(499);
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap();
        if (concurrentSoftHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(500);
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap();
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(501);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(508);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(512);
        }
        ContainerUtilRt.addIfNotNull(result2, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(516);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(517);
        }
        List<V> list2 = ContainerUtilRt.map2List(collection, mapper);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(518);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(521);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(522);
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(523);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(524);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(525);
        }
        Set<V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(526);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(535);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(536);
        }
        T[] TArray = ContainerUtilRt.toArray(collection, array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(537);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(538);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(539);
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(540);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory2, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(541);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(542);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(543);
        }
        return a;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(554);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(555);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        SoftKeySoftValueHashMap softKeySoftValueHashMap = new SoftKeySoftValueHashMap();
        if (softKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(563);
        }
        return softKeySoftValueHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        SoftHashMap softHashMap = new SoftHashMap();
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(566);
        }
        return softHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        WeakHashMap weakHashMap = new WeakHashMap();
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(569);
        }
        return weakHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(570);
        }
        return weakHashMap;
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(571);
        }
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity, loadFactor, strategy);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(572);
        }
        return weakHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 117: 
            case 120: 
            case 128: 
            case 130: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 150: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: 
            case 213: 
            case 216: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 229: 
            case 231: 
            case 234: 
            case 237: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 250: 
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 263: 
            case 266: 
            case 270: 
            case 275: 
            case 278: 
            case 291: 
            case 293: 
            case 296: 
            case 299: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 331: 
            case 334: 
            case 336: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 353: 
            case 360: 
            case 363: 
            case 365: 
            case 370: 
            case 373: 
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 397: 
            case 398: 
            case 400: 
            case 407: 
            case 408: 
            case 411: 
            case 416: 
            case 432: 
            case 433: 
            case 435: 
            case 437: 
            case 444: 
            case 446: 
            case 449: 
            case 451: 
            case 453: 
            case 457: 
            case 473: 
            case 474: 
            case 476: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 510: 
            case 515: 
            case 518: 
            case 520: 
            case 523: 
            case 526: 
            case 529: 
            case 530: 
            case 533: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 545: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 572: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 117: 
            case 120: 
            case 128: 
            case 130: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 150: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: 
            case 213: 
            case 216: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 229: 
            case 231: 
            case 234: 
            case 237: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 250: 
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 263: 
            case 266: 
            case 270: 
            case 275: 
            case 278: 
            case 291: 
            case 293: 
            case 296: 
            case 299: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 331: 
            case 334: 
            case 336: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 353: 
            case 360: 
            case 363: 
            case 365: 
            case 370: 
            case 373: 
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 397: 
            case 398: 
            case 400: 
            case 407: 
            case 408: 
            case 411: 
            case 416: 
            case 432: 
            case 433: 
            case 435: 
            case 437: 
            case 444: 
            case 446: 
            case 449: 
            case 451: 
            case 453: 
            case 457: 
            case 473: 
            case 474: 
            case 476: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 510: 
            case 515: 
            case 518: 
            case 520: 
            case 523: 
            case 526: 
            case 529: 
            case 530: 
            case 533: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 545: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 572: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 117: 
            case 120: 
            case 128: 
            case 130: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 150: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: 
            case 213: 
            case 216: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 229: 
            case 231: 
            case 234: 
            case 237: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 250: 
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 263: 
            case 266: 
            case 270: 
            case 275: 
            case 278: 
            case 291: 
            case 293: 
            case 296: 
            case 299: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 331: 
            case 334: 
            case 336: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 353: 
            case 360: 
            case 363: 
            case 365: 
            case 370: 
            case 373: 
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 397: 
            case 398: 
            case 400: 
            case 407: 
            case 408: 
            case 411: 
            case 416: 
            case 432: 
            case 433: 
            case 435: 
            case 437: 
            case 444: 
            case 446: 
            case 449: 
            case 451: 
            case 453: 
            case 457: 
            case 473: 
            case 474: 
            case 476: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 510: 
            case 515: 
            case 518: 
            case 520: 
            case 523: 
            case 526: 
            case 529: 
            case 530: 
            case 533: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 545: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 572: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 3: 
            case 12: 
            case 16: 
            case 92: 
            case 151: 
            case 223: 
            case 472: 
            case 519: 
            case 559: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 8: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: 
            case 148: 
            case 152: 
            case 295: 
            case 298: 
            case 301: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 22: 
            case 64: 
            case 68: 
            case 71: 
            case 443: 
            case 497: 
            case 567: 
            case 571: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 35: 
            case 105: 
            case 159: 
            case 193: 
            case 196: 
            case 199: 
            case 251: 
            case 287: 
            case 289: 
            case 374: 
            case 377: 
            case 391: 
            case 513: 
            case 536: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 37: 
            case 53: 
            case 161: 
            case 165: 
            case 169: 
            case 171: 
            case 283: 
            case 368: 
            case 371: 
            case 382: 
            case 385: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 427: 
            case 429: 
            case 544: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 55: 
            case 134: 
            case 139: 
            case 142: 
            case 154: 
            case 167: 
            case 173: 
            case 175: 
            case 268: 
            case 285: 
            case 338: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 78: 
            case 110: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 179: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 203: 
            case 207: 
            case 211: 
            case 214: 
            case 217: 
            case 220: 
            case 226: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 245: 
            case 248: 
            case 258: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 281: 
            case 509: 
            case 516: 
            case 521: 
            case 524: 
            case 527: 
            case 531: 
            case 535: 
            case 541: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 93: 
            case 116: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 107: 
            case 129: 
            case 163: 
            case 177: 
            case 262: 
            case 267: 
            case 292: 
            case 294: 
            case 297: 
            case 300: 
            case 324: 
            case 354: 
            case 355: 
            case 358: 
            case 361: 
            case 364: 
            case 438: 
            case 447: 
            case 458: 
            case 459: 
            case 462: 
            case 464: 
            case 466: 
            case 468: 
            case 470: 
            case 552: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 121: 
            case 125: 
            case 303: 
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 122: 
            case 126: 
            case 304: 
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 123: 
            case 127: 
            case 356: 
            case 359: 
            case 362: 
            case 367: 
            case 439: 
            case 441: 
            case 448: 
            case 558: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 124: 
            case 162: 
            case 164: 
            case 166: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 149: 
            case 153: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 160: 
            case 170: 
            case 176: 
            case 178: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 227: 
            case 256: 
            case 259: 
            case 282: 
            case 418: 
            case 420: 
            case 422: 
            case 424: 
            case 426: 
            case 428: 
            case 430: 
            case 463: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 172: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 180: 
            case 183: 
            case 186: 
            case 189: 
            case 194: 
            case 197: 
            case 201: 
            case 205: 
            case 209: 
            case 339: 
            case 514: 
            case 517: 
            case 522: 
            case 525: 
            case 528: 
            case 532: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 200: 
            case 204: 
            case 284: 
            case 286: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 208: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 246: 
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 253: 
            case 272: 
            case 546: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 290: 
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 309: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 313: 
            case 315: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 319: 
            case 322: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 325: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 327: 
            case 329: 
            case 332: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 328: 
            case 330: 
            case 333: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 335: 
            case 337: 
            case 399: 
            case 434: 
            case 436: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 341: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 342: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 344: 
            case 348: 
            case 352: 
            case 413: 
            case 542: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 346: 
            case 350: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 347: 
            case 351: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 357: 
            case 366: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 369: 
            case 372: 
            case 375: 
            case 378: 
            case 383: 
            case 386: 
            case 392: 
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 379: 
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 394: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 409: 
            case 412: 
            case 414: 
            case 511: 
            case 512: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 415: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 431: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 440: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 445: 
            case 450: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 467: 
            case 469: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 471: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 475: 
            case 477: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 482: 
            case 538: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 491: 
            case 493: 
            case 502: 
            case 504: 
            case 506: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 539: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 553: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 554: 
            case 556: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 555: 
            case 557: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newEnumMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityHashMap";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 45: 
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "newSmartList";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 58: 
            case 60: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveSet";
                break;
            }
            case 76: 
            case 77: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveSet";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveMap";
                break;
            }
            case 81: 
            case 83: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentMap";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "reverse";
                break;
            }
            case 94: 
            case 97: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 106: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableMapBuilder";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 117: 
            case 331: 
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 140: 
            case 141: 
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSet";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 181: 
            case 184: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 187: 
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 213: 
            case 216: 
            case 222: 
            case 225: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 219: 
            case 228: 
            case 229: 
            case 234: 
            case 247: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "skipNulls";
                break;
            }
            case 237: 
            case 240: 
            case 243: 
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 266: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 291: 
            case 293: 
            case 296: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 299: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 314: 
            case 316: {
                objectArray = objectArray2;
                objectArray2[1] = "concatIterators";
                break;
            }
            case 336: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIterator";
                break;
            }
            case 343: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 345: 
            case 349: 
            case 537: 
            case 540: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 360: 
            case 363: 
            case 365: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 370: 
            case 373: 
            case 393: 
            case 397: 
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 407: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 411: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 416: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 432: 
            case 433: {
                objectArray = objectArray2;
                objectArray2[1] = "unfold";
                break;
            }
            case 435: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTail";
                break;
            }
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 444: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 446: 
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 453: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 473: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 474: 
            case 476: 
            case 478: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 479: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 480: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 481: 
            case 483: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 484: 
            case 485: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 486: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectSoftValueMap";
                break;
            }
            case 487: 
            case 488: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentLongObjectMap";
                break;
            }
            case 489: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 490: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectWeakValueMap";
                break;
            }
            case 492: 
            case 495: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 494: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 496: 
            case 498: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 499: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 500: 
            case 503: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 501: 
            case 505: 
            case 507: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 508: 
            case 510: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentList";
                break;
            }
            case 515: 
            case 518: 
            case 520: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 523: 
            case 526: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 529: 
            case 530: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 533: 
            case 534: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 543: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 545: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 547: 
            case 548: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 549: 
            case 550: 
            case 551: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 560: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 561: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 562: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 563: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 564: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftValueMap";
                break;
            }
            case 565: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakValueMap";
                break;
            }
            case 566: 
            case 568: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
            case 569: 
            case 570: 
            case 572: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 117: 
            case 120: 
            case 128: 
            case 130: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 150: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: 
            case 213: 
            case 216: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 229: 
            case 231: 
            case 234: 
            case 237: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 250: 
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 263: 
            case 266: 
            case 270: 
            case 275: 
            case 278: 
            case 291: 
            case 293: 
            case 296: 
            case 299: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 331: 
            case 334: 
            case 336: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 353: 
            case 360: 
            case 363: 
            case 365: 
            case 370: 
            case 373: 
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 397: 
            case 398: 
            case 400: 
            case 407: 
            case 408: 
            case 411: 
            case 416: 
            case 432: 
            case 433: 
            case 435: 
            case 437: 
            case 444: 
            case 446: 
            case 449: 
            case 451: 
            case 453: 
            case 457: 
            case 473: 
            case 474: 
            case 476: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 510: 
            case 515: 
            case 518: 
            case 520: 
            case 523: 
            case 526: 
            case 529: 
            case 530: 
            case 533: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 545: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 572: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 35: 
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 51: 
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 105: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 114: 
            case 414: 
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 115: 
            case 116: 
            case 329: 
            case 330: 
            case 332: 
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 271: 
            case 272: 
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 139: 
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "collectSet";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 159: 
            case 160: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 179: 
            case 180: 
            case 182: 
            case 183: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 185: 
            case 186: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 205: 
            case 207: 
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 211: 
            case 212: 
            case 214: 
            case 215: 
            case 220: 
            case 221: 
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 217: 
            case 218: 
            case 226: 
            case 227: 
            case 232: 
            case 233: 
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 235: 
            case 236: 
            case 238: 
            case 239: 
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 251: 
            case 253: 
            case 255: 
            case 256: 
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 279: 
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 289: 
            case 290: 
            case 292: 
            case 294: 
            case 295: 
            case 303: 
            case 304: 
            case 309: 
            case 317: 
            case 319: 
            case 322: 
            case 324: 
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 313: 
            case 315: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 327: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 338: 
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 341: 
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 535: 
            case 536: 
            case 538: 
            case 539: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 350: 
            case 351: 
            case 352: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 358: 
            case 359: 
            case 361: 
            case 362: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 368: 
            case 369: 
            case 371: 
            case 372: 
            case 391: 
            case 392: 
            case 394: 
            case 395: 
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 374: 
            case 375: 
            case 377: 
            case 378: 
            case 379: 
            case 382: 
            case 383: 
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 401: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 402: 
            case 403: 
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 405: 
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 409: 
            case 410: 
            case 412: 
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 417: 
            case 418: 
            case 419: 
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 421: 
            case 422: 
            case 423: 
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 425: 
            case 426: 
            case 427: 
            case 428: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 429: 
            case 430: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "unfold";
                break;
            }
            case 434: {
                objectArray = objectArray;
                objectArray[2] = "dropTail";
                break;
            }
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 438: 
            case 439: 
            case 440: 
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 445: 
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 447: 
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 454: 
            case 455: 
            case 456: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 459: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 460: 
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 462: 
            case 463: 
            case 470: 
            case 471: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 464: 
            case 465: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 466: 
            case 467: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 468: 
            case 469: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 472: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 475: 
            case 477: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 482: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 491: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 493: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 497: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 502: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 504: 
            case 506: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 509: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 511: 
            case 512: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 513: 
            case 514: 
            case 516: 
            case 517: 
            case 519: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 521: 
            case 522: 
            case 524: 
            case 525: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 527: 
            case 528: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 531: 
            case 532: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 541: 
            case 542: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 544: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 546: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 552: 
            case 553: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 559: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 567: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 571: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 112: 
            case 113: 
            case 117: 
            case 120: 
            case 128: 
            case 130: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 147: 
            case 150: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 192: 
            case 195: 
            case 198: 
            case 202: 
            case 206: 
            case 210: 
            case 213: 
            case 216: 
            case 219: 
            case 222: 
            case 225: 
            case 228: 
            case 229: 
            case 231: 
            case 234: 
            case 237: 
            case 240: 
            case 243: 
            case 244: 
            case 247: 
            case 250: 
            case 252: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 263: 
            case 266: 
            case 270: 
            case 275: 
            case 278: 
            case 291: 
            case 293: 
            case 296: 
            case 299: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 316: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 331: 
            case 334: 
            case 336: 
            case 340: 
            case 343: 
            case 345: 
            case 349: 
            case 353: 
            case 360: 
            case 363: 
            case 365: 
            case 370: 
            case 373: 
            case 376: 
            case 380: 
            case 381: 
            case 384: 
            case 387: 
            case 388: 
            case 390: 
            case 393: 
            case 397: 
            case 398: 
            case 400: 
            case 407: 
            case 408: 
            case 411: 
            case 416: 
            case 432: 
            case 433: 
            case 435: 
            case 437: 
            case 444: 
            case 446: 
            case 449: 
            case 451: 
            case 453: 
            case 457: 
            case 473: 
            case 474: 
            case 476: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 483: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 499: 
            case 500: 
            case 501: 
            case 503: 
            case 505: 
            case 507: 
            case 508: 
            case 510: 
            case 515: 
            case 518: 
            case 520: 
            case 523: 
            case 526: 
            case 529: 
            case 530: 
            case 533: 
            case 534: 
            case 537: 
            case 540: 
            case 543: 
            case 545: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 568: 
            case 569: 
            case 570: 
            case 572: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

