/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import org.apache.ivy.Ivy;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.MessageLogger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class AntMessageLogger
extends AbstractMessageLogger {
    private static final int PROGRESS_LOG_PERIOD = 1500;
    private ProjectComponent task;
    private long lastProgressFlush = 0L;
    private StringBuffer buf = new StringBuffer();

    public static void register(ProjectComponent projectComponent, final Ivy ivy) {
        AntMessageLogger antMessageLogger;
        MessageLogger messageLogger = ivy.getLoggerEngine().peekLogger();
        if (messageLogger instanceof AntMessageLogger && projectComponent instanceof Task && ((AntMessageLogger)messageLogger).task instanceof Task && (antMessageLogger = (Task)((AntMessageLogger)messageLogger).task).getTaskName() != null && antMessageLogger.getTaskName().equals(((Task)projectComponent).getTaskName())) {
            return;
        }
        antMessageLogger = new AntMessageLogger(projectComponent);
        ivy.getLoggerEngine().pushLogger(antMessageLogger);
        projectComponent.getProject().addBuildListener(new BuildListener(){
            private int stackDepth = 0;

            public void buildFinished(BuildEvent buildEvent) {
            }

            public void buildStarted(BuildEvent buildEvent) {
            }

            public void targetStarted(BuildEvent buildEvent) {
            }

            public void targetFinished(BuildEvent buildEvent) {
            }

            public void taskStarted(BuildEvent buildEvent) {
                ++this.stackDepth;
            }

            public void taskFinished(BuildEvent buildEvent) {
                --this.stackDepth;
                if (this.stackDepth == -1) {
                    ivy.getLoggerEngine().popLogger();
                    buildEvent.getProject().removeBuildListener((BuildListener)this);
                }
            }

            public void messageLogged(BuildEvent buildEvent) {
            }
        });
    }

    protected AntMessageLogger(ProjectComponent projectComponent) {
        Checks.checkNotNull(projectComponent, "task");
        this.task = projectComponent;
    }

    @Override
    public void log(String string, int n) {
        this.task.log(string, n);
    }

    @Override
    public void rawlog(String string, int n) {
        this.task.getProject().log(string, n);
    }

    @Override
    public void doProgress() {
        this.buf.append(".");
        if (this.lastProgressFlush == 0L) {
            this.lastProgressFlush = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastProgressFlush > 1500L) {
            this.task.log(this.buf.toString());
            this.buf.setLength(0);
            this.lastProgressFlush = System.currentTimeMillis();
        }
    }

    @Override
    public void doEndProgress(String string) {
        this.task.log(this.buf + string);
        this.buf.setLength(0);
        this.lastProgressFlush = 0L;
    }

    public String toString() {
        return "AntMessageLogger:" + this.task;
    }
}

