/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.util.Version;

public class P2Descriptor
extends RepoDescriptor {
    private long timestamp;
    private Map artifactUrlPatterns = new HashMap();
    private String repoUrl;

    public P2Descriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        super(uRI, executionEnvironmentProfileProvider);
        try {
            this.repoUrl = uRI.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Illegal repo uri", malformedURLException);
        }
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public void addBundle(BundleInfo bundleInfo) {
        String string;
        Map map = (Map)this.artifactUrlPatterns.get(bundleInfo.getSymbolicName());
        if (map != null && (string = (String)map.get(bundleInfo.getVersion())) != null) {
            String string2 = string.replaceAll("\\$\\{id\\}", bundleInfo.getSymbolicName());
            string2 = string2.replaceAll("\\$\\{version\\}", bundleInfo.getVersion().toString());
            try {
                bundleInfo.setUri(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Unable to build the artifact uri of " + bundleInfo, uRISyntaxException);
            }
            super.addBundle(bundleInfo);
        }
    }

    public void addArtifactUrl(String string, String string2, Version version, String string3) {
        if (!string.equals("osgi.bundle")) {
            return;
        }
        HashMap<Version, String> hashMap = (HashMap<Version, String>)this.artifactUrlPatterns.get(string2);
        if (hashMap == null) {
            hashMap = new HashMap<Version, String>();
            this.artifactUrlPatterns.put(string2, hashMap);
        }
        hashMap.put(version, string3);
    }
}

