/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;

public class VersionRangeMatcher
extends AbstractVersionMatcher {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private final Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            MRIDArtifactInfo mRIDArtifactInfo = new MRIDArtifactInfo((ModuleRevisionId)object);
            MRIDArtifactInfo mRIDArtifactInfo2 = new MRIDArtifactInfo((ModuleRevisionId)object2);
            ArtifactInfo artifactInfo = VersionRangeMatcher.this.getLatestStrategy().findLatest(new ArtifactInfo[]{mRIDArtifactInfo, mRIDArtifactInfo2}, null);
            return artifactInfo == mRIDArtifactInfo ? -1 : 1;
        }
    };
    private LatestStrategy latestStrategy;
    private String latestStrategyName = "default";

    public VersionRangeMatcher() {
        super("version-range");
    }

    public VersionRangeMatcher(String string) {
        super(string);
    }

    public VersionRangeMatcher(String string, LatestStrategy latestStrategy) {
        super(string);
        this.latestStrategy = latestStrategy;
    }

    @Override
    public boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        String string = moduleRevisionId.getRevision();
        return ALL_RANGE.matcher(string).matches();
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        String string = moduleRevisionId.getRevision();
        Matcher matcher = FINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return this.isUpper(moduleRevisionId, string2, moduleRevisionId2, string.startsWith("[")) && this.isLower(moduleRevisionId, string3, moduleRevisionId2, string.endsWith("]"));
        }
        matcher = LOWER_INFINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            return this.isLower(moduleRevisionId, string4, moduleRevisionId2, string.endsWith("]"));
        }
        matcher = UPPER_INFINITE_RANGE.matcher(string);
        if (matcher.matches()) {
            String string5 = matcher.group(1);
            return this.isUpper(moduleRevisionId, string5, moduleRevisionId2, string.startsWith("["));
        }
        return false;
    }

    private boolean isLower(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(moduleRevisionId, string);
        int n = this.comparator.compare(moduleRevisionId3, moduleRevisionId2);
        return n <= (bl ? 0 : -1);
    }

    private boolean isUpper(ModuleRevisionId moduleRevisionId, String string, ModuleRevisionId moduleRevisionId2, boolean bl) {
        ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(moduleRevisionId, string);
        int n = this.comparator.compare(moduleRevisionId3, moduleRevisionId2);
        return n >= (bl ? 0 : 1);
    }

    @Override
    public int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        String string;
        String string2 = moduleRevisionId.getRevision();
        Matcher matcher = UPPER_INFINITE_RANGE.matcher(string2);
        if (matcher.matches()) {
            return 1;
        }
        matcher = FINITE_RANGE.matcher(string2);
        if (matcher.matches()) {
            string = matcher.group(2);
        } else {
            matcher = LOWER_INFINITE_RANGE.matcher(string2);
            if (matcher.matches()) {
                string = matcher.group(1);
            } else {
                throw new IllegalArgumentException("impossible to compare: askedMrid is not a dynamic revision: " + moduleRevisionId);
            }
        }
        int n = comparator.compare(ModuleRevisionId.newInstance(moduleRevisionId, string), moduleRevisionId2);
        return n == 0 ? -1 : n;
    }

    public LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            if (this.getSettings() == null) {
                throw new IllegalStateException("no ivy instance nor latest strategy configured in version range matcher " + this);
            }
            if (this.latestStrategyName == null) {
                throw new IllegalStateException("null latest strategy defined in version range matcher " + this);
            }
            this.latestStrategy = this.getSettings().getLatestStrategy(this.latestStrategyName);
            if (this.latestStrategy == null) {
                throw new IllegalStateException("unknown latest strategy '" + this.latestStrategyName + "' configured in version range matcher " + this);
            }
        }
        return this.latestStrategy;
    }

    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this.latestStrategy = latestStrategy;
    }

    public void setLatest(String string) {
        this.latestStrategyName = string;
    }

    private final class MRIDArtifactInfo
    implements ArtifactInfo {
        private ModuleRevisionId mrid;

        public MRIDArtifactInfo(ModuleRevisionId moduleRevisionId) {
            this.mrid = moduleRevisionId;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public String getRevision() {
            return this.mrid.getRevision();
        }
    }
}

