// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_Router_h__
#define __Glacier2_Router_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/Router.h>
#include <Glacier2/Session.h>
#include <Glacier2/PermissionsVerifier.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class Router;
class RouterPrx;

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) SessionNotExistException : public ::Ice::UserExceptionHelper<SessionNotExistException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~SessionNotExistException();

    SessionNotExistException(const SessionNotExistException&) = default;

    SessionNotExistException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();
};

static SessionNotExistException _iceS_SessionNotExistException_init;

}

namespace Glacier2
{

class GLACIER2_API Router : public virtual ::Ice::Router
{
public:

    using ProxyType = RouterPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::string getCategoryForClient(const ::Ice::Current&) const = 0;
    bool _iceD_getCategoryForClient(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void createSessionAsync(::std::string, ::std::string, ::std::function<void(const ::std::shared_ptr<::Glacier2::SessionPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void createSessionFromSecureConnectionAsync(::std::function<void(const ::std::shared_ptr<::Glacier2::SessionPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void refreshSessionAsync(::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_refreshSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroySession(const ::Ice::Current&) = 0;
    bool _iceD_destroySession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual long long int getSessionTimeout(const ::Ice::Current&) const = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual int getACMTimeout(const ::Ice::Current&) const = 0;
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) RouterPrx : public virtual ::Ice::Proxy<RouterPrx, ::Ice::RouterPrx>
{
public:

    ::std::string getCategoryForClient(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &Glacier2::RouterPrx::_iceI_getCategoryForClient, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getCategoryForClientAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &Glacier2::RouterPrx::_iceI_getCategoryForClient, context);
    }

    ::std::function<void()>
    getCategoryForClientAsync(::std::function<void(::std::string)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getCategoryForClient, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_getCategoryForClient(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Glacier2::SessionPrx> createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &Glacier2::RouterPrx::_iceI_createSession, iceP_userId, iceP_password, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &Glacier2::RouterPrx::_iceI_createSession, iceP_userId, iceP_password, context);
    }

    ::std::function<void()>
    createSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password,
                       ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_createSession, iceP_userId, iceP_password, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::Glacier2::SessionPrx> createSessionFromSecureConnection(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &Glacier2::RouterPrx::_iceI_createSessionFromSecureConnection, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createSessionFromSecureConnectionAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &Glacier2::RouterPrx::_iceI_createSessionFromSecureConnection, context);
    }

    ::std::function<void()>
    createSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_createSessionFromSecureConnection, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::Ice::Context&);

    void refreshSession(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::RouterPrx::_iceI_refreshSession, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto refreshSessionAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::RouterPrx::_iceI_refreshSession, context);
    }

    ::std::function<void()>
    refreshSessionAsync(::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_refreshSession, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_refreshSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    void destroySession(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::RouterPrx::_iceI_destroySession, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto destroySessionAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::RouterPrx::_iceI_destroySession, context);
    }

    ::std::function<void()>
    destroySessionAsync(::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_destroySession, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_destroySession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    long long int getSessionTimeout(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<long long int>(true, this, &Glacier2::RouterPrx::_iceI_getSessionTimeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<long long int>>().get_future())
    {
        return _makePromiseOutgoing<long long int, P>(false, this, &Glacier2::RouterPrx::_iceI_getSessionTimeout, context);
    }

    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(long long int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<long long int>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getSessionTimeout, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<long long int>>&, const ::Ice::Context&);

    int getACMTimeout(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &Glacier2::RouterPrx::_iceI_getACMTimeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getACMTimeoutAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &Glacier2::RouterPrx::_iceI_getACMTimeout, context);
    }

    ::std::function<void()>
    getACMTimeoutAsync(::std::function<void(int)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &Glacier2::RouterPrx::_iceI_getACMTimeout, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    RouterPrx() = default;
    friend ::std::shared_ptr<RouterPrx> IceInternal::createProxy<RouterPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

}

namespace Glacier2
{

using RouterPtr = ::std::shared_ptr<Router>;
using RouterPrxPtr = ::std::shared_ptr<RouterPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class Router;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Router>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::Router*);

}

}

namespace Glacier2
{

class Router;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::Router*);
typedef ::IceInternal::Handle< ::Glacier2::Router> RouterPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Router> RouterPrx;
typedef RouterPrx RouterPrxPtr;
GLACIER2_API void _icePatchObjectPtr(RouterPtr&, const ::Ice::ObjectPtr&);

}

namespace Glacier2
{

class GLACIER2_API SessionNotExistException : public ::Ice::UserException
{
public:

    SessionNotExistException() {}
    virtual ~SessionNotExistException() throw();

    virtual ::std::string ice_id() const;
    virtual SessionNotExistException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static SessionNotExistException _iceS_SessionNotExistException_init;

}

namespace Glacier2
{

class GLACIER2_API AMD_Router_createSession : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_createSession();

    virtual void ice_response(const ::Glacier2::SessionPrx&) = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_createSession> AMD_Router_createSessionPtr;

class GLACIER2_API AMD_Router_createSessionFromSecureConnection : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_createSessionFromSecureConnection();

    virtual void ice_response(const ::Glacier2::SessionPrx&) = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_createSessionFromSecureConnection> AMD_Router_createSessionFromSecureConnectionPtr;

class GLACIER2_API AMD_Router_refreshSession : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Router_refreshSession();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Glacier2::AMD_Router_refreshSession> AMD_Router_refreshSessionPtr;

}

namespace IceAsync
{

namespace Glacier2
{

class GLACIER2_API AMD_Router_createSession : public ::Glacier2::AMD_Router_createSession, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_createSession(::IceInternal::Incoming&);

    virtual void ice_response(const ::Glacier2::SessionPrx&);
};

class GLACIER2_API AMD_Router_createSessionFromSecureConnection : public ::Glacier2::AMD_Router_createSessionFromSecureConnection, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_createSessionFromSecureConnection(::IceInternal::Incoming&);

    virtual void ice_response(const ::Glacier2::SessionPrx&);
};

class GLACIER2_API AMD_Router_refreshSession : public ::Glacier2::AMD_Router_refreshSession, public ::IceInternal::IncomingAsync
{
public:

    AMD_Router_refreshSession(::IceInternal::Incoming&);

    virtual void ice_response();
};

}

}

namespace Glacier2
{

class Callback_Router_getCategoryForClient_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getCategoryForClient_Base> Callback_Router_getCategoryForClientPtr;

class Callback_Router_createSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_createSession_Base> Callback_Router_createSessionPtr;

class Callback_Router_createSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_createSessionFromSecureConnection_Base> Callback_Router_createSessionFromSecureConnectionPtr;

class Callback_Router_refreshSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_refreshSession_Base> Callback_Router_refreshSessionPtr;

class Callback_Router_destroySession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_destroySession_Base> Callback_Router_destroySessionPtr;

class Callback_Router_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getSessionTimeout_Base> Callback_Router_getSessionTimeoutPtr;

class Callback_Router_getACMTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getACMTimeout_Base> Callback_Router_getACMTimeoutPtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) Router : public virtual ::Ice::Proxy<Router, ::IceProxy::Ice::Router>
{
public:

    ICE_MEMBER(GLACIER2_API) ::std::string getCategoryForClient(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getCategoryForClient(_iceI_begin_getCategoryForClient(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getCategoryForClient(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Glacier2::Callback_Router_getCategoryForClientPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getCategoryForClient(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getCategoryForClientPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getCategoryForClient(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::std::string end_getCategoryForClient(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getCategoryForClient(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSession(_iceI_begin_createSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Glacier2::Callback_Router_createSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Glacier2::Callback_Router_createSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_createSession(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_createSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSessionFromSecureConnection(_iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Glacier2::Callback_Router_createSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Glacier2::Callback_Router_createSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_createSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) void refreshSession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_refreshSession(_iceI_begin_refreshSession(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_refreshSession(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_refreshSession(const ::Glacier2::Callback_Router_refreshSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_refreshSession(const ::Ice::Context& context, const ::Glacier2::Callback_Router_refreshSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_refreshSession(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_refreshSession(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_refreshSession(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) void destroySession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroySession(_iceI_begin_destroySession(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroySession(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroySession(const ::Glacier2::Callback_Router_destroySessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroySession(const ::Ice::Context& context, const ::Glacier2::Callback_Router_destroySessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroySession(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_destroySession(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroySession(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Ice::Long getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Glacier2::Callback_Router_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Ice::Long end_getSessionTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Ice::Int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getACMTimeout(_iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Glacier2::Callback_Router_getACMTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_Router_getACMTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Ice::Int end_getACMTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getACMTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace Glacier2
{

class GLACIER2_API Router : virtual public ::Ice::Router
{
public:

    typedef RouterPrx ProxyType;
    typedef RouterPtr PointerType;

    virtual ~Router();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::std::string getCategoryForClient(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getCategoryForClient(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void createSession_async(const ::Glacier2::AMD_Router_createSessionPtr&, const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void createSessionFromSecureConnection_async(const ::Glacier2::AMD_Router_createSessionFromSecureConnectionPtr&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void refreshSession_async(const ::Glacier2::AMD_Router_refreshSessionPtr&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_refreshSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroySession(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_destroySession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::Long getSessionTimeout(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::Int getACMTimeout(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Router& lhs, const Router& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Router& lhs, const Router& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::SessionNotExistException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace Glacier2
{

template<class T>
class CallbackNC_Router_getCategoryForClient : public Callback_Router_getCategoryForClient_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Router_getCategoryForClient(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getCategoryForClient(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getCategoryForClient<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getCategoryForClient<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_getCategoryForClient : public Callback_Router_getCategoryForClient_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Router_getCategoryForClient(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getCategoryForClient(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getCategoryForClient<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_getCategoryForClientPtr
newCallback_Router_getCategoryForClient(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getCategoryForClient<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Router_createSession : public Callback_Router_createSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&);

    CallbackNC_Router_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_createSessionPtr
newCallback_Router_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_createSessionPtr
newCallback_Router_createSession(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSession<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_createSession : public Callback_Router_createSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&, const CT&);

    Callback_Router_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_createSessionPtr
newCallback_Router_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_createSessionPtr
newCallback_Router_createSession(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Router_createSessionFromSecureConnection : public Callback_Router_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&);

    CallbackNC_Router_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_createSessionFromSecureConnection : public Callback_Router_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&, const CT&);

    Callback_Router_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_createSessionFromSecureConnectionPtr
newCallback_Router_createSessionFromSecureConnection(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Router_refreshSession : public Callback_Router_refreshSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Router_refreshSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_refreshSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_refreshSession<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_refreshSession : public Callback_Router_refreshSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Router_refreshSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_refreshSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_refreshSessionPtr
newCallback_Router_refreshSession(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_refreshSession<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Router_destroySession : public Callback_Router_destroySession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Router_destroySession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroySession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_destroySession<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_destroySession : public Callback_Router_destroySession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Router_destroySession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroySession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_destroySessionPtr
newCallback_Router_destroySession(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_destroySession<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Router_getSessionTimeout : public Callback_Router_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Long);

    CallbackNC_Router_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_getSessionTimeout : public Callback_Router_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Long, const CT&);

    Callback_Router_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_getSessionTimeoutPtr
newCallback_Router_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Router_getACMTimeout : public Callback_Router_getACMTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Router_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getACMTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getACMTimeout<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Router_getACMTimeout : public Callback_Router_getACMTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Router_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::RouterPrx proxy = ::Glacier2::RouterPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Router_getACMTimeoutPtr
newCallback_Router_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
