// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Locator_h__
#define __Ice_Locator_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/Process.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class LocatorRegistry;
class LocatorRegistryPrx;
class Locator;
class LocatorPrx;
class LocatorFinder;
class LocatorFinderPrx;

}

namespace Ice
{

class ICE_CLASS(ICE_API) AdapterNotFoundException : public ::Ice::UserExceptionHelper<AdapterNotFoundException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~AdapterNotFoundException();

    AdapterNotFoundException(const AdapterNotFoundException&) = default;

    AdapterNotFoundException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

static AdapterNotFoundException _iceS_AdapterNotFoundException_init;

class ICE_CLASS(ICE_API) InvalidReplicaGroupIdException : public ::Ice::UserExceptionHelper<InvalidReplicaGroupIdException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvalidReplicaGroupIdException();

    InvalidReplicaGroupIdException(const InvalidReplicaGroupIdException&) = default;

    InvalidReplicaGroupIdException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICE_API) AdapterAlreadyActiveException : public ::Ice::UserExceptionHelper<AdapterAlreadyActiveException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~AdapterAlreadyActiveException();

    AdapterAlreadyActiveException(const AdapterAlreadyActiveException&) = default;

    AdapterAlreadyActiveException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICE_API) ObjectNotFoundException : public ::Ice::UserExceptionHelper<ObjectNotFoundException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectNotFoundException();

    ObjectNotFoundException(const ObjectNotFoundException&) = default;

    ObjectNotFoundException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICE_API) ServerNotFoundException : public ::Ice::UserExceptionHelper<ServerNotFoundException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ServerNotFoundException();

    ServerNotFoundException(const ServerNotFoundException&) = default;

    ServerNotFoundException() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

}

namespace Ice
{

class ICE_API Locator : public virtual ::Ice::Object
{
public:

    using ProxyType = LocatorPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void findObjectByIdAsync(::Ice::Identity, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) const = 0;
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void findAdapterByIdAsync(::std::string, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>&)>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) const = 0;
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::LocatorRegistryPrx> getRegistry(const ::Ice::Current&) const = 0;
    bool _iceD_getRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICE_API LocatorRegistry : public virtual ::Ice::Object
{
public:

    using ProxyType = LocatorRegistryPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void setAdapterDirectProxyAsync(::std::string, ::std::shared_ptr<::Ice::ObjectPrx>, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setReplicatedAdapterDirectProxyAsync(::std::string, ::std::string, ::std::shared_ptr<::Ice::ObjectPrx>, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setServerProcessProxyAsync(::std::string, ::std::shared_ptr<::Ice::ProcessPrx>, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_setServerProcessProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICE_API LocatorFinder : public virtual ::Ice::Object
{
public:

    using ProxyType = LocatorFinderPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::Ice::LocatorPrx> getLocator(const ::Ice::Current&) = 0;
    bool _iceD_getLocator(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace Ice
{

class ICE_CLASS(ICE_API) LocatorPrx : public virtual ::Ice::Proxy<LocatorPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Ice::ObjectPrx> findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &Ice::LocatorPrx::_iceI_findObjectById, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findObjectByIdAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &Ice::LocatorPrx::_iceI_findObjectById, iceP_id, context);
    }

    ::std::function<void()>
    findObjectByIdAsync(const ::Ice::Identity& iceP_id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_findObjectById, iceP_id, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &Ice::LocatorPrx::_iceI_findAdapterById, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findAdapterByIdAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &Ice::LocatorPrx::_iceI_findAdapterById, iceP_id, context);
    }

    ::std::function<void()>
    findAdapterByIdAsync(const ::std::string& iceP_id,
                         ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_findAdapterById, iceP_id, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_findAdapterById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::LocatorRegistryPrx> getRegistry(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>>(true, this, &Ice::LocatorPrx::_iceI_getRegistry, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getRegistryAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::LocatorRegistryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>, P>(false, this, &Ice::LocatorPrx::_iceI_getRegistry, context);
    }

    ::std::function<void()>
    getRegistryAsync(::std::function<void(::std::shared_ptr<::Ice::LocatorRegistryPrx>)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_getRegistry, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorRegistryPrx>>>&, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    LocatorPrx() = default;
    friend ::std::shared_ptr<LocatorPrx> IceInternal::createProxy<LocatorPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICE_API) LocatorRegistryPrx : public virtual ::Ice::Proxy<LocatorRegistryPrx, ::Ice::ObjectPrx>
{
public:

    void setAdapterDirectProxy(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::LocatorRegistryPrx::_iceI_setAdapterDirectProxy, iceP_id, iceP_proxy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setAdapterDirectProxyAsync(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::LocatorRegistryPrx::_iceI_setAdapterDirectProxy, iceP_id, iceP_proxy, context);
    }

    ::std::function<void()>
    setAdapterDirectProxyAsync(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setAdapterDirectProxy, iceP_id, iceP_proxy, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_setAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_p, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, iceP_adapterId, iceP_replicaGroupId, iceP_p, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setReplicatedAdapterDirectProxyAsync(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_p, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, iceP_adapterId, iceP_replicaGroupId, iceP_p, context);
    }

    ::std::function<void()>
    setReplicatedAdapterDirectProxyAsync(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_p,
                                         ::std::function<void()> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, iceP_adapterId, iceP_replicaGroupId, iceP_p, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_setReplicatedAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void setServerProcessProxy(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ProcessPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Ice::LocatorRegistryPrx::_iceI_setServerProcessProxy, iceP_id, iceP_proxy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setServerProcessProxyAsync(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ProcessPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Ice::LocatorRegistryPrx::_iceI_setServerProcessProxy, iceP_id, iceP_proxy, context);
    }

    ::std::function<void()>
    setServerProcessProxyAsync(const ::std::string& iceP_id, const ::std::shared_ptr<::Ice::ProcessPrx>& iceP_proxy,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setServerProcessProxy, iceP_id, iceP_proxy, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_setServerProcessProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<::Ice::ProcessPrx>&, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    LocatorRegistryPrx() = default;
    friend ::std::shared_ptr<LocatorRegistryPrx> IceInternal::createProxy<LocatorRegistryPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICE_API) LocatorFinderPrx : public virtual ::Ice::Proxy<LocatorFinderPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Ice::LocatorPrx> getLocator(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorPrx>>(true, this, &Ice::LocatorFinderPrx::_iceI_getLocator, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLocatorAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::LocatorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorPrx>, P>(false, this, &Ice::LocatorFinderPrx::_iceI_getLocator, context);
    }

    ::std::function<void()>
    getLocatorAsync(::std::function<void(::std::shared_ptr<::Ice::LocatorPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::LocatorPrx>>(response, ex, sent, this, &Ice::LocatorFinderPrx::_iceI_getLocator, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getLocator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorPrx>>>&, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    LocatorFinderPrx() = default;
    friend ::std::shared_ptr<LocatorFinderPrx> IceInternal::createProxy<LocatorFinderPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

}

namespace Ice
{

using LocatorRegistryPtr = ::std::shared_ptr<LocatorRegistry>;
using LocatorRegistryPrxPtr = ::std::shared_ptr<LocatorRegistryPrx>;

using LocatorPtr = ::std::shared_ptr<Locator>;
using LocatorPrxPtr = ::std::shared_ptr<LocatorPrx>;

using LocatorFinderPtr = ::std::shared_ptr<LocatorFinder>;
using LocatorFinderPrxPtr = ::std::shared_ptr<LocatorFinderPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class LocatorRegistry;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorRegistry>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::LocatorRegistry*);

class Locator;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::Locator>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::Locator*);

class LocatorFinder;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorFinder>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::LocatorFinder*);

}

}

namespace Ice
{

class LocatorRegistry;
ICE_API ::Ice::Object* upCast(::Ice::LocatorRegistry*);
typedef ::IceInternal::Handle< ::Ice::LocatorRegistry> LocatorRegistryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorRegistry> LocatorRegistryPrx;
typedef LocatorRegistryPrx LocatorRegistryPrxPtr;
ICE_API void _icePatchObjectPtr(LocatorRegistryPtr&, const ::Ice::ObjectPtr&);

class Locator;
ICE_API ::Ice::Object* upCast(::Ice::Locator*);
typedef ::IceInternal::Handle< ::Ice::Locator> LocatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::Locator> LocatorPrx;
typedef LocatorPrx LocatorPrxPtr;
ICE_API void _icePatchObjectPtr(LocatorPtr&, const ::Ice::ObjectPtr&);

class LocatorFinder;
ICE_API ::Ice::Object* upCast(::Ice::LocatorFinder*);
typedef ::IceInternal::Handle< ::Ice::LocatorFinder> LocatorFinderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorFinder> LocatorFinderPrx;
typedef LocatorFinderPrx LocatorFinderPrxPtr;
ICE_API void _icePatchObjectPtr(LocatorFinderPtr&, const ::Ice::ObjectPtr&);

}

namespace Ice
{

class ICE_API AdapterNotFoundException : public ::Ice::UserException
{
public:

    AdapterNotFoundException() {}
    virtual ~AdapterNotFoundException() throw();

    virtual ::std::string ice_id() const;
    virtual AdapterNotFoundException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static AdapterNotFoundException _iceS_AdapterNotFoundException_init;

class ICE_API InvalidReplicaGroupIdException : public ::Ice::UserException
{
public:

    InvalidReplicaGroupIdException() {}
    virtual ~InvalidReplicaGroupIdException() throw();

    virtual ::std::string ice_id() const;
    virtual InvalidReplicaGroupIdException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICE_API AdapterAlreadyActiveException : public ::Ice::UserException
{
public:

    AdapterAlreadyActiveException() {}
    virtual ~AdapterAlreadyActiveException() throw();

    virtual ::std::string ice_id() const;
    virtual AdapterAlreadyActiveException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICE_API ObjectNotFoundException : public ::Ice::UserException
{
public:

    ObjectNotFoundException() {}
    virtual ~ObjectNotFoundException() throw();

    virtual ::std::string ice_id() const;
    virtual ObjectNotFoundException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

class ICE_API ServerNotFoundException : public ::Ice::UserException
{
public:

    ServerNotFoundException() {}
    virtual ~ServerNotFoundException() throw();

    virtual ::std::string ice_id() const;
    virtual ServerNotFoundException* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

}

namespace Ice
{

class ICE_API AMD_Locator_findObjectById : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Locator_findObjectById();

    virtual void ice_response(const ::Ice::ObjectPrx&) = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_Locator_findObjectById> AMD_Locator_findObjectByIdPtr;

class ICE_API AMD_Locator_findAdapterById : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Locator_findAdapterById();

    virtual void ice_response(const ::Ice::ObjectPrx&) = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_Locator_findAdapterById> AMD_Locator_findAdapterByIdPtr;

class ICE_API AMD_LocatorRegistry_setAdapterDirectProxy : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setAdapterDirectProxy();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setAdapterDirectProxy> AMD_LocatorRegistry_setAdapterDirectProxyPtr;

class ICE_API AMD_LocatorRegistry_setReplicatedAdapterDirectProxy : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setReplicatedAdapterDirectProxy();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy> AMD_LocatorRegistry_setReplicatedAdapterDirectProxyPtr;

class ICE_API AMD_LocatorRegistry_setServerProcessProxy : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setServerProcessProxy();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setServerProcessProxy> AMD_LocatorRegistry_setServerProcessProxyPtr;

}

namespace IceAsync
{

namespace Ice
{

class ICE_API AMD_Locator_findObjectById : public ::Ice::AMD_Locator_findObjectById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Locator_findObjectById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

class ICE_API AMD_Locator_findAdapterById : public ::Ice::AMD_Locator_findAdapterById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Locator_findAdapterById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

class ICE_API AMD_LocatorRegistry_setAdapterDirectProxy : public ::Ice::AMD_LocatorRegistry_setAdapterDirectProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setAdapterDirectProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

class ICE_API AMD_LocatorRegistry_setReplicatedAdapterDirectProxy : public ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

class ICE_API AMD_LocatorRegistry_setServerProcessProxy : public ::Ice::AMD_LocatorRegistry_setServerProcessProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setServerProcessProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

}

}

namespace Ice
{

class Callback_Locator_findObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_findObjectById_Base> Callback_Locator_findObjectByIdPtr;

class Callback_Locator_findAdapterById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_findAdapterById_Base> Callback_Locator_findAdapterByIdPtr;

class Callback_Locator_getRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getRegistry_Base> Callback_Locator_getRegistryPtr;

class Callback_LocatorRegistry_setAdapterDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setAdapterDirectProxy_Base> Callback_LocatorRegistry_setAdapterDirectProxyPtr;

class Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr;

class Callback_LocatorRegistry_setServerProcessProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setServerProcessProxy_Base> Callback_LocatorRegistry_setServerProcessProxyPtr;

class Callback_LocatorFinder_getLocator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorFinder_getLocator_Base> Callback_LocatorFinder_getLocatorPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) Locator : public virtual ::Ice::Proxy<Locator, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectById(_iceI_begin_findObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Callback_Locator_findObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::Callback_Locator_findObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_findObjectById(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAdapterById(_iceI_begin_findAdapterById(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAdapterById(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::Callback_Locator_findAdapterByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::Callback_Locator_findAdapterByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_findAdapterById(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_findAdapterById(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::Ice::LocatorRegistryPrx getRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistry(_iceI_begin_getRegistry(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistry(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Callback_Locator_getRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context, const ::Ice::Callback_Locator_getRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::LocatorRegistryPrx end_getRegistry(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistry(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) LocatorRegistry : public virtual ::Ice::Proxy<LocatorRegistry, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) void setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAdapterDirectProxy(_iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Callback_LocatorRegistry_setAdapterDirectProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& iceP_id, const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setAdapterDirectProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(iceP_id, iceP_proxy, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setAdapterDirectProxy(const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) void setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setReplicatedAdapterDirectProxy(_iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& iceP_adapterId, const ::std::string& iceP_replicaGroupId, const ::Ice::ObjectPrx& iceP_p, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(iceP_adapterId, iceP_replicaGroupId, iceP_p, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_setReplicatedAdapterDirectProxy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setReplicatedAdapterDirectProxy(const ::std::string&, const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) void setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setServerProcessProxy(_iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Callback_LocatorRegistry_setServerProcessProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& iceP_id, const ::Ice::ProcessPrx& iceP_proxy, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setServerProcessProxyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(iceP_id, iceP_proxy, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_setServerProcessProxy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setServerProcessProxy(const ::std::string&, const ::Ice::ProcessPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) LocatorFinder : public virtual ::Ice::Proxy<LocatorFinder, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) ::Ice::LocatorPrx getLocator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocator(_iceI_begin_getLocator(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocator(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Callback_LocatorFinder_getLocatorPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context, const ::Ice::Callback_LocatorFinder_getLocatorPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::LocatorPrx end_getLocator(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getLocator(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace Ice
{

class ICE_API Locator : public virtual ::Ice::Object
{
public:

    typedef LocatorPrx ProxyType;
    typedef LocatorPtr PointerType;

    virtual ~Locator();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void findObjectById_async(const ::Ice::AMD_Locator_findObjectByIdPtr&, const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void findAdapterById_async(const ::Ice::AMD_Locator_findAdapterByIdPtr&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::LocatorRegistryPrx getRegistry(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API LocatorRegistry : public virtual ::Ice::Object
{
public:

    typedef LocatorRegistryPrx ProxyType;
    typedef LocatorRegistryPtr PointerType;

    virtual ~LocatorRegistry();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void setAdapterDirectProxy_async(const ::Ice::AMD_LocatorRegistry_setAdapterDirectProxyPtr&, const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setReplicatedAdapterDirectProxy_async(const ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxyPtr&, const ::std::string&, const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setServerProcessProxy_async(const ::Ice::AMD_LocatorRegistry_setServerProcessProxyPtr&, const ::std::string&, const ::Ice::ProcessPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setServerProcessProxy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const LocatorRegistry& lhs, const LocatorRegistry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LocatorRegistry& lhs, const LocatorRegistry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API LocatorFinder : public virtual ::Ice::Object
{
public:

    typedef LocatorFinderPrx ProxyType;
    typedef LocatorFinderPtr PointerType;

    virtual ~LocatorFinder();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Ice::LocatorPrx getLocator(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getLocator(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const LocatorFinder& lhs, const LocatorFinder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LocatorFinder& lhs, const LocatorFinder& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::Ice::AdapterNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::InvalidReplicaGroupIdException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::AdapterAlreadyActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::ObjectNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::ServerNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}

namespace Ice
{

template<class T>
class CallbackNC_Locator_findObjectById : public Callback_Locator_findObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Locator_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findObjectById<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findObjectById<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Locator_findObjectById : public Callback_Locator_findObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Locator_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Locator_findAdapterById : public Callback_Locator_findAdapterById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Locator_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findAdapterById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findAdapterById<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findAdapterById<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Locator_findAdapterById : public Callback_Locator_findAdapterById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Locator_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findAdapterById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Locator_getRegistry : public Callback_Locator_getRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::LocatorRegistryPrx&);

    CallbackNC_Locator_getRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::LocatorRegistryPrx ret;
        try
        {
            ret = proxy->end_getRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LocatorRegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getRegistry<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(T* instance, void (T::*cb)(const ::Ice::LocatorRegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getRegistry<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Locator_getRegistry : public Callback_Locator_getRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::LocatorRegistryPrx&, const CT&);

    Callback_Locator_getRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorPrx proxy = ::Ice::LocatorPrx::uncheckedCast(result->getProxy());
        ::Ice::LocatorRegistryPrx ret;
        try
        {
            ret = proxy->end_getRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LocatorRegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(T* instance, void (T::*cb)(const ::Ice::LocatorRegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_LocatorRegistry_setAdapterDirectProxy : public Callback_LocatorRegistry_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_LocatorRegistry_setAdapterDirectProxy : public Callback_LocatorRegistry_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy : public Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setReplicatedAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_LocatorRegistry_setReplicatedAdapterDirectProxy : public Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setReplicatedAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setReplicatedAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LocatorRegistry_setServerProcessProxy : public Callback_LocatorRegistry_setServerProcessProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setServerProcessProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setServerProcessProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_LocatorRegistry_setServerProcessProxy : public Callback_LocatorRegistry_setServerProcessProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setServerProcessProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorRegistryPrx proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setServerProcessProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_LocatorFinder_getLocator : public Callback_LocatorFinder_getLocator_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::LocatorPrx&);

    CallbackNC_LocatorFinder_getLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorFinderPrx proxy = ::Ice::LocatorFinderPrx::uncheckedCast(result->getProxy());
        ::Ice::LocatorPrx ret;
        try
        {
            ret = proxy->end_getLocator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LocatorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorFinder_getLocator<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(T* instance, void (T::*cb)(const ::Ice::LocatorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorFinder_getLocator<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_LocatorFinder_getLocator : public Callback_LocatorFinder_getLocator_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::LocatorPrx&, const CT&);

    Callback_LocatorFinder_getLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Ice::LocatorFinderPrx proxy = ::Ice::LocatorFinderPrx::uncheckedCast(result->getProxy());
        ::Ice::LocatorPrx ret;
        try
        {
            ret = proxy->end_getLocator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::LocatorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorFinder_getLocator<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(T* instance, void (T::*cb)(const ::Ice::LocatorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorFinder_getLocator<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
