// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `FileInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IcePatch2_FileInfo_h__
#define __IcePatch2_FileInfo_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IcePatch2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEPATCH2_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEPATCH2_API /**/
#   elif defined(ICEPATCH2_API_EXPORTS)
#       define ICEPATCH2_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEPATCH2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IcePatch2
{

struct FileInfo
{
    ::std::string path;
    ::Ice::ByteSeq checksum;
    int size;
    bool executable;

    std::tuple<const ::std::string&, const ::Ice::ByteSeq&, const int&, const bool&> ice_tuple() const
    {
        return std::tie(path, checksum, size, executable);
    }
};

using FileInfoSeq = ::std::vector<::IcePatch2::FileInfo>;

struct LargeFileInfo
{
    ::std::string path;
    ::Ice::ByteSeq checksum;
    long long int size;
    bool executable;

    std::tuple<const ::std::string&, const ::Ice::ByteSeq&, const long long int&, const bool&> ice_tuple() const
    {
        return std::tie(path, checksum, size, executable);
    }
};

using LargeFileInfoSeq = ::std::vector<::IcePatch2::LargeFileInfo>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

template<>
struct StreamableTraits<::IcePatch2::FileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IcePatch2::FileInfo, S>
{
    static void read(S* istr, ::IcePatch2::FileInfo& v)
    {
        istr->readAll(v.path, v.checksum, v.size, v.executable);
    }
};

template<>
struct StreamableTraits<::IcePatch2::LargeFileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IcePatch2::LargeFileInfo, S>
{
    static void read(S* istr, ::IcePatch2::LargeFileInfo& v)
    {
        istr->readAll(v.path, v.checksum, v.size, v.executable);
    }
};

}

#else // C++98 mapping

namespace IcePatch2
{

struct FileInfo
{
    ::std::string path;
    ::Ice::ByteSeq checksum;
    ::Ice::Int size;
    bool executable;
};

typedef ::std::vector< ::IcePatch2::FileInfo> FileInfoSeq;

struct LargeFileInfo
{
    ::std::string path;
    ::Ice::ByteSeq checksum;
    ::Ice::Long size;
    bool executable;
};

typedef ::std::vector< ::IcePatch2::LargeFileInfo> LargeFileInfoSeq;

}

namespace Ice
{

template<>
struct StreamableTraits< ::IcePatch2::FileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IcePatch2::FileInfo, S>
{
    static void write(S* ostr, const ::IcePatch2::FileInfo& v)
    {
        ostr->write(v.path);
        ostr->write(v.checksum);
        ostr->write(v.size);
        ostr->write(v.executable);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::FileInfo, S>
{
    static void read(S* istr, ::IcePatch2::FileInfo& v)
    {
        istr->read(v.path);
        istr->read(v.checksum);
        istr->read(v.size);
        istr->read(v.executable);
    }
};

template<>
struct StreamableTraits< ::IcePatch2::LargeFileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IcePatch2::LargeFileInfo, S>
{
    static void write(S* ostr, const ::IcePatch2::LargeFileInfo& v)
    {
        ostr->write(v.path);
        ostr->write(v.checksum);
        ostr->write(v.size);
        ostr->write(v.executable);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::LargeFileInfo, S>
{
    static void read(S* istr, ::IcePatch2::LargeFileInfo& v)
    {
        istr->read(v.path);
        istr->read(v.checksum);
        istr->read(v.size);
        istr->read(v.executable);
    }
};

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
