/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.runtime;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.output.ProfileDump;
import com.mentorgen.tools.profile.runtime.ClassAllocation;
import com.mentorgen.tools.profile.runtime.Frame;
import com.mentorgen.tools.profile.runtime.Method;
import com.mentorgen.tools.profile.runtime.ThreadDictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Profile
implements Runnable {
    private static boolean _debugStart = false;
    private static boolean _debugException = false;
    private static ThreadDictionary _threadDictionary;
    private static List<Frame> _frameList;
    private static Map<Long, Frame> _threadActiveFrame;
    private static Map<String, Method> _methodDictionary;
    private static Object _lock;
    private static Map<String, ClassAllocation> _allocList;
    private static Controller _controller;
    private static Thread _controllerThread;

    public static void initProfiler() {
        System.err.println("Java Interactive Profiler: starting");
        Profile.init();
        Runtime.getRuntime().addShutdownHook(new Thread(new Profile()));
        _controller = new Controller();
        if (Controller._remote) {
            _controllerThread = new Thread(_controller);
            _controllerThread.start();
        }
    }

    public static void init() {
        _threadActiveFrame = new HashMap<Long, Frame>(1001);
        _threadDictionary = new ThreadDictionary();
        _methodDictionary = new HashMap<String, Method>(2003);
        _frameList = new ArrayList<Frame>(1001);
        _lock = new Object();
        _allocList = new HashMap<String, ClassAllocation>();
    }

    public static void clear() {
        Profile.init();
    }

    public static void start() {
        _controller.start();
    }

    public static void stop() {
        _controller.stop();
    }

    public static void setFileName(String string) {
        _controller.setFileName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = _lock;
        synchronized (object) {
            Controller._profile = false;
            for (Long object2 : _threadDictionary.keySet()) {
                Frame frame = _threadDictionary.getMostRecentFrame(object2);
                frame.close();
            }
            for (Frame frame : Profile.frameList()) {
                frame.computeNetTime();
            }
        }
    }

    public static Iterable<Long> threads() {
        return _threadDictionary.threads();
    }

    public static Iterable<Frame> interactions(long l) {
        return _threadDictionary.interactions(l);
    }

    public static Iterable<Frame> frameList() {
        return _frameList;
    }

    public static Iterable<ClassAllocation> allocations() {
        return _allocList.values();
    }

    public static long getThreadTotalTime(long l) {
        return _threadDictionary.getThreadTotalTime(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortFrameList(Comparator<Frame> comparator) {
        Object object = _lock;
        synchronized (object) {
            Collections.sort(_frameList, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String string, String string2) {
        long l = System.nanoTime();
        long l2 = Thread.currentThread().getId();
        Object object = _lock;
        synchronized (object) {
            if (!Controller._profile) {
                return;
            }
            Method method = new Method(string, string2);
            if (_methodDictionary.get(method.toString()) == null) {
                _methodDictionary.put(method.toString(), method);
            }
            Frame frame = _threadActiveFrame.get(l2);
            Frame frame2 = null;
            if (frame != null) {
                frame2 = frame.getChild(method);
                if (frame2 == null) {
                    frame2 = new Frame(frame, method, l2);
                    _frameList.add(frame2);
                }
            } else {
                frame2 = new Frame(null, method, l2);
                _frameList.add(frame2);
                _threadDictionary.add(l2, frame2);
            }
            if (_debugStart) {
                System.out.print("  (");
                System.out.print(string);
                System.out.print(" : ");
                System.out.print(string2);
                System.out.println(')');
                Frame frame3 = _threadDictionary.getMostRecentFrame(l2);
                System.out.println(frame3);
            }
            _threadActiveFrame.put(l2, frame2);
            frame2.overhead(System.nanoTime() - l);
            frame2.setBeginTime(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String string, String string2) {
        long l = System.nanoTime();
        Object object = _lock;
        synchronized (object) {
            long l2 = Thread.currentThread().getId();
            Frame frame = Profile.findFrame(l2, string, string2);
            if (frame == null) {
                return;
            }
            if (frame.getParent() != null) {
                _threadActiveFrame.put(l2, frame.getParent());
            } else {
                _threadActiveFrame.put(l2, null);
            }
            frame.overhead(System.nanoTime() - l);
            frame.setEndTime(System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginWait(String string, String string2) {
        long l = System.nanoTime();
        Object object = _lock;
        synchronized (object) {
            Frame frame = Profile.findFrame(Thread.currentThread().getId(), string, string2);
            if (frame == null) {
                return;
            }
            frame.overhead(System.nanoTime() - l);
            frame.beginWait(System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endWait(String string, String string2) {
        long l = System.nanoTime();
        Object object = _lock;
        synchronized (object) {
            Frame frame = Profile.findFrame(Thread.currentThread().getId(), string, string2);
            if (frame == null) {
                return;
            }
            frame.overhead(System.nanoTime() - l);
            frame.endWait(System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unwind(String string, String string2, String string3) {
        if (_debugException || Controller._debug) {
            System.out.println("Catch: " + string3);
        }
        Object object = _lock;
        synchronized (object) {
            long l = Thread.currentThread().getId();
            Frame frame = Profile.findFrame(l, string, string2);
            if (frame == null) {
                return;
            }
            _threadActiveFrame.put(l, frame);
        }
    }

    private static final Frame findFrame(long l, String string, String string2) {
        if (!Controller._profile) {
            return null;
        }
        Frame frame = _threadActiveFrame.get(l);
        if (frame == null) {
            return null;
        }
        boolean bl = false;
        while (!frame.getClassName().equals(string) || !frame.getMethodName().equals(string2)) {
            if (!bl) {
                bl = true;
                if (_debugException || Controller._debug) {
                    System.err.print("Detected an exception at ");
                    System.err.print(string);
                    System.err.print('.');
                    System.err.println(string2);
                }
            } else if (_debugException) {
                System.err.print("Unwinding ");
                System.err.print(frame.getClassName());
                System.err.print('.');
                System.err.println(frame.getMethodName());
            }
            frame.setEndTime(System.nanoTime());
            if ((frame = frame.getParent()) != null) continue;
            if (_debugException) {
                System.err.println("Stack completely unwound.");
            }
            return null;
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alloc(String string) {
        Object object = _lock;
        synchronized (object) {
            if (!Controller._profile) {
                return;
            }
            long l = Thread.currentThread().getId();
            Frame frame = _threadActiveFrame.get(l);
            if (frame != null && frame.getClassName().equals(string) && frame.getMethodName().equals("<init>")) {
                return;
            }
            ClassAllocation classAllocation = _allocList.get(string);
            if (classAllocation == null) {
                classAllocation = new ClassAllocation(string);
                _allocList.put(string, classAllocation);
            }
            classAllocation.incAllocCount();
        }
    }

    @Override
    public void run() {
        try {
            if (_threadDictionary.size() > 0) {
                Profile.shutdown();
                ProfileDump.dump();
            }
            _controller.close();
            if (_controllerThread != null) {
                _controllerThread.interrupt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

