/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Parser$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.api.DependencyContext;

public final class Analyze$ {
    public static Analyze$ MODULE$;

    static {
        new Analyze$();
    }

    public <T> void apply(Seq<File> newClasses, Seq<File> sources, Logger log, AnalysisCallback analysis, ClassLoader loader, Function2<File, Seq<Class<?>>, scala.collection.immutable.Set<Tuple2<String, String>>> readAPI) {
        Map sourceMap = sources.toSet().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName());
        Set classNames = scala.collection.mutable.Set$.MODULE$.empty();
        HashMap sourceToClassFiles = (HashMap)HashMap$.MODULE$.apply((Seq)sources.zip((GenIterable)Seq$.MODULE$.fill(sources.size(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer()), Seq$.MODULE$.canBuildFrom()));
        HashMap binaryClassNameToLoadedClass = new HashMap();
        scala.collection.mutable.Map classfilesCache = Map$.MODULE$.empty();
        ((IterableLike)newClasses.map((Function1 & Serializable & scala.Serializable)newClass -> {
            ClassFile classFile = Parser$.MODULE$.apply((File)newClass);
            return new Tuple2(newClass, (Object)classFile);
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Analyze$.$anonfun$apply$6(this, log, analysis, loader, sourceMap, classNames, sourceToClassFiles, binaryClassNameToLoadedClass, x$3);
            return BoxedUnit.UNIT;
        });
        sourceToClassFiles.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$apply$13(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Analyze$.$anonfun$apply$14(log, analysis, loader, readAPI, classNames, binaryClassNameToLoadedClass, classfilesCache, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Option<File> urlAsFile(URL url, Logger log) {
        Option option;
        try {
            option = IO$.MODULE$.urlAsFile(url);
        }
        catch (Exception e) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> "Could not convert URL '" + url.toExternalForm() + "' to File: " + e.toString());
            option = None$.MODULE$;
        }
        return option;
    }

    private void trapAndLog(Logger log, Function0<BoxedUnit> execute) {
        try {
            execute.apply$mcV$sp();
        }
        catch (Throwable e) {
            log.trace((Function0 & Serializable & scala.Serializable)() -> e);
            log.error((Function0 & Serializable & scala.Serializable)() -> e.toString());
        }
    }

    private Some<String> guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        return dollar < 0 ? name : name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        return name.endsWith(".class") ? name.substring(0, name.length() - ".class".length()) : name;
    }

    private String classNameToClassFile(String name) {
        return name.replace('.', '/') + ".class";
    }

    private Option<String> binaryToSourceName(Class<?> loadedClass) {
        return Option$.MODULE$.apply((Object)loadedClass.getCanonicalName());
    }

    private List<File> guessSourcePath(Map<String, scala.collection.immutable.Set<File>> sourceNameMap, ClassFile classFile, Logger log) {
        .colon.colon colon2;
        List list;
        String[] classNameParts = classFile.className().split("\\.");
        String[] pkg = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).init();
        String simpleClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).last();
        String sourceFileName = (String)classFile.sourceFile().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(simpleClassName)).takeWhile((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$guessSourcePath$2(BoxesRunTime.unboxToChar((Object)x$10)))))).mkString("", "", ".java"));
        List<File> candidates = this.findSource(sourceNameMap, (List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pkg)).toList(), sourceFileName);
        List<File> list2 = candidates;
        if (Nil$.MODULE$.equals(list2)) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> "Could not determine source for class " + classFile.className());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            log.warn((Function0 & Serializable & scala.Serializable)() -> "Multiple sources matched for class " + classFile.className() + ": " + candidates.mkString(", "));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return candidates;
    }

    private List<File> findSource(Map<String, Iterable<File>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine((List<Tuple2<File, File>>)((List)((List)sourceNameMap.get((Object)sourceFileName).toList().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)x.getParentFile()), List$.MODULE$.canBuildFrom())), (List<String>)pkg.reverse());
    }

    private List<File> refine(List<Tuple2<File, File>> sources, List<String> pkgRev) {
        List<File> list;
        block2: {
            block3: {
                List list2;
                while (true) {
                    if (sources.isEmpty() || ((SeqLike)sources.tail()).isEmpty()) {
                        list = Analyze$.make$1(sources);
                        break block2;
                    }
                    list2 = pkgRev;
                    if (Nil$.MODULE$.equals(list2)) break block3;
                    if (!(list2 instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list2;
                    String x = (String)colon2.head();
                    List xs = colon2.tl$access$1();
                    List retain = (List)sources.flatMap(arg_0 -> Analyze$.$anonfun$refine$2(x, arg_0), List$.MODULE$.canBuildFrom());
                    pkgRev = xs;
                    sources = retain;
                }
                throw new MatchError(list2);
            }
            List<File> list3 = this.shortest((List<File>)Analyze$.make$1(sources));
            list = list3;
        }
        return list;
    }

    private List<File> shortest(List<File> files) {
        List list;
        if (files.isEmpty()) {
            list = files;
        } else {
            Map fs = files.groupBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToInteger((int)Analyze$.MODULE$.distanceToRoot(0, file)));
            list = (List)fs.apply(fs.keys().min((Ordering)Ordering.Int$.MODULE$));
        }
        return list;
    }

    private int distanceToRoot(int acc, File file) {
        while (file != null) {
            file = file.getParentFile();
            ++acc;
        }
        return acc;
    }

    private static final Option load$1(String tpe, Function0 errMsg, Logger log$1, ClassLoader loader$1) {
        None$ none$;
        if (tpe.endsWith("module-info")) {
            none$ = None$.MODULE$;
        } else {
            try {
                none$ = new Some(Class.forName(tpe, false, loader$1));
            }
            catch (Throwable e) {
                ((Option)errMsg.apply()).foreach((Function1 & Serializable & scala.Serializable)msg -> {
                    log$1.warn((Function0 & Serializable & scala.Serializable)() -> msg + " : " + e$1.toString());
                    return BoxedUnit.UNIT;
                });
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private final Option loadEnclosingClass$1(Class clazz) {
        Option<String> option;
        while (None$.MODULE$.equals(option = this.binaryToSourceName(clazz)) && clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        Option<String> option2 = option;
        return option2;
    }

    public static final /* synthetic */ void $anonfun$apply$10(Analyze$ $this, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap sourceToClassFiles$1, HashMap binaryClassNameToLoadedClass$1, File newClass$1, ClassFile classFile$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File source = (File)tuple2._1();
        String binaryClassName = (String)tuple2._2();
        Analyze$.load$1(binaryClassName, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)("Error reading API from class file: " + binaryClassName)), log$1, loader$1).foreach((Function1 & Serializable & scala.Serializable)loadedClass -> {
            BoxedUnit boxedUnit;
            Option srcClassName;
            binaryClassNameToLoadedClass$1.update((Object)binaryClassName, loadedClass);
            Option option = srcClassName = $this.loadEnclosingClass$1((Class)loadedClass);
            if (option instanceof Some) {
                Some some = (Some)option;
                String className = (String)some.value();
                analysis$1.generatedNonLocalClass(source, newClass$1, binaryClassName, className);
                boxedUnit = classNames$1.$plus$eq((Object)className);
            } else if (None$.MODULE$.equals(option)) {
                analysis$1.generatedLocalClass(source, newClass$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return ((BufferLike)sourceToClassFiles$1.apply((Object)source)).$plus$eq((Object)classFile$1);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$8(Analyze$ $this, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Map sourceMap$1, Set classNames$1, HashMap sourceToClassFiles$1, HashMap binaryClassNameToLoadedClass$1, File newClass$1, ClassFile classFile$1, String _) {
        ((List)MODULE$.guessSourcePath((Map<String, scala.collection.immutable.Set<File>>)sourceMap$1, classFile$1, log$1).map((Function1 & Serializable & scala.Serializable)source -> {
            String binaryClassName = classFile$1.className();
            return new Tuple2(source, (Object)binaryClassName);
        }, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Analyze$.$anonfun$apply$10($this, log$1, analysis$1, loader$1, classNames$1, sourceToClassFiles$1, binaryClassNameToLoadedClass$1, newClass$1, classFile$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$6(Analyze$ $this, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Map sourceMap$1, Set classNames$1, HashMap sourceToClassFiles$1, HashMap binaryClassNameToLoadedClass$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File newClass = (File)tuple2._1();
        ClassFile classFile = (ClassFile)tuple2._2();
        classFile.sourceFile().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.guessSourceName(newClass.getName())).foreach((Function1 & Serializable & scala.Serializable)_ -> {
            Analyze$.$anonfun$apply$8($this, log$1, analysis$1, loader$1, sourceMap$1, classNames$1, sourceToClassFiles$1, binaryClassNameToLoadedClass$1, newClass, classFile, _);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$apply$13(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(Class x$4) {
        return x$4.getCanonicalName() != null;
    }

    private static final Option getMappedSource$1(String className, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        Option nonLocalSourceName = binaryClassNameToLoadedClass$1.get((Object)className).flatMap((Function1 & Serializable & scala.Serializable)loadedClass -> MODULE$.binaryToSourceName((Class<?>)loadedClass).map((Function1 & Serializable & scala.Serializable)sourceName -> sourceName));
        return nonLocalSourceName.orElse((Function0 & Serializable & scala.Serializable)() -> localClassesToSources$1.get((Object)className));
    }

    private static final Option loadFromClassloader$1(Logger log$1, ClassLoader loader$1, scala.collection.mutable.Map classfilesCache$1, String onBinaryName$1) {
        return Option$.MODULE$.apply((Object)loader$1.getResource(MODULE$.classNameToClassFile(onBinaryName$1))).flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.urlAsFile((URL)url, log$1).map((Function1 & Serializable & scala.Serializable)file -> {
            classfilesCache$1.update((Object)onBinaryName$1, file);
            return file;
        }));
    }

    private static final void processDependency$1(String onBinaryName, DependencyContext context, String fromBinaryName, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, File source$2, Map localClassesToSources$1) {
        Option option = Analyze$.getMappedSource$1(fromBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            String fromClassName = (String)some.value();
            MODULE$.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String scalaLikeTypeName = onBinaryName.replace('$', '.');
                if (classNames$1.contains((Object)scalaLikeTypeName)) {
                    analysis$1.classDependency(scalaLikeTypeName, fromClassName, context);
                } else {
                    Option cachedOrigin = classfilesCache$1.get((Object)onBinaryName);
                    cachedOrigin.orElse((Function0 & Serializable & scala.Serializable)() -> Analyze$.loadFromClassloader$1(log$1, loader$1, classfilesCache$1, onBinaryName)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                        analysis$1.binaryDependency(file, onBinaryName, fromClassName, source$2, context);
                        return BoxedUnit.UNIT;
                    });
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private static final void processDependencies$1(Iterable binaryClassNames, DependencyContext context, String fromBinaryClassName, Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, File source$2, Map localClassesToSources$1) {
        binaryClassNames.foreach((Function1 & Serializable & scala.Serializable)binaryClassName -> {
            Analyze$.processDependency$1(binaryClassName, context, fromBinaryClassName, log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source$2, localClassesToSources$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$30(Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, File source$2, Map localClassesToSources$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String binaryClassName = (String)tuple2._1();
        scala.collection.immutable.Set binaryClassNameDeps = (scala.collection.immutable.Set)tuple2._2();
        Analyze$.processDependencies$1((Iterable)binaryClassNameDeps, DependencyContext.DependencyByMemberRef, binaryClassName, log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source$2, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Map readInheritanceDependencies$1(Seq classes, Function2 readAPI$1, File source$2) {
        scala.collection.immutable.Set api = (scala.collection.immutable.Set)readAPI$1.apply((Object)source$2, (Object)classes);
        return api.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1()).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> (scala.collection.immutable.Set)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._2(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$apply$34(Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, File source$2, Map localClassesToSources$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String className = (String)tuple2._1();
        scala.collection.immutable.Set inheritanceDeps = (scala.collection.immutable.Set)tuple2._2();
        Analyze$.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.DependencyByInheritance, className, log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source$2, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$36(Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, File source$2, Map localClassesToSources$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String className = (String)tuple2._1();
        scala.collection.immutable.Set inheritanceDeps = (scala.collection.immutable.Set)tuple2._2();
        Analyze$.processDependencies$1((Iterable)inheritanceDeps, DependencyContext.LocalDependencyByInheritance, className, log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source$2, localClassesToSources$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$14(Logger log$1, AnalysisCallback analysis$1, ClassLoader loader$1, Function2 readAPI$1, Set classNames$1, HashMap binaryClassNameToLoadedClass$1, scala.collection.mutable.Map classfilesCache$1, Tuple2 x$9) {
        Tuple2 tuple2;
        Buffer classFiles;
        File source;
        Tuple2 tuple22 = x$9;
        if (tuple22 != null) {
            source = (File)tuple22._1();
            classFiles = (Buffer)tuple22._2();
            analysis$1.startSource(source);
            Buffer loadedClasses = (Buffer)classFiles.map((Function1 & Serializable & scala.Serializable)c -> (Class)binaryClassNameToLoadedClass$1.apply((Object)c.className()), Buffer$.MODULE$.canBuildFrom());
            Tuple2 tuple23 = loadedClasses.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$apply$16(x$4)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Buffer nonLocalClasses = (Buffer)tuple23._1();
            Buffer localClassesOrStale = (Buffer)tuple23._2();
            tuple2 = new Tuple2((Object)nonLocalClasses, (Object)localClassesOrStale);
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple24 = tuple2;
        Buffer nonLocalClasses = (Buffer)tuple24._1();
        Buffer localClassesOrStale = (Buffer)tuple24._2();
        Buffer localToSourcesSeq = (Buffer)localClassesOrStale.flatMap((Function1 & Serializable & scala.Serializable)cls -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(cls.getEnclosingClass()).flatMap((Function1 & Serializable & scala.Serializable)enclosingCls -> MODULE$.binaryToSourceName((Class<?>)enclosingCls).map((Function1 & Serializable & scala.Serializable)sourceOfEnclosing -> new Tuple2((Object)cls.getName(), sourceOfEnclosing)))), Buffer$.MODULE$.canBuildFrom());
        Map localClassesToSources = localToSourcesSeq.toMap(Predef$.MODULE$.$conforms());
        Map typesInSource = ((TraversableOnce)classFiles.map((Function1 & Serializable & scala.Serializable)cf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cf.className()), cf.types()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        typesInSource.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Analyze$.$anonfun$apply$30(log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source, localClassesToSources, x0$1);
            return BoxedUnit.UNIT;
        });
        Map nonLocalInherited = Analyze$.readInheritanceDependencies$1((Seq)nonLocalClasses, readAPI$1, source);
        nonLocalInherited.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Analyze$.$anonfun$apply$34(log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source, localClassesToSources, x0$2);
            return BoxedUnit.UNIT;
        });
        Buffer localClasses = (Buffer)localClassesOrStale.filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)localClassesToSources.contains((Object)cls.getName())));
        Map localInherited = Analyze$.readInheritanceDependencies$1((Seq)localClasses, readAPI$1, source);
        localInherited.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Analyze$.$anonfun$apply$36(log$1, analysis$1, loader$1, classNames$1, binaryClassNameToLoadedClass$1, classfilesCache$1, source, localClassesToSources, x0$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$guessSourcePath$2(char x$10) {
        return x$10 != '$';
    }

    private static final List make$1(List sources$1) {
        return (List)sources$1.map((Function1 & Serializable & scala.Serializable)x$11 -> (File)x$11._1(), List$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ List $anonfun$refine$2(String x$13, Tuple2 x0$4) {
        block3: {
            block2: {
                var3_2 = x0$4;
                if (var3_2 == null) break block2;
                src = (File)var3_2._1();
                pre = (File)var3_2._2();
                if (pre == null) ** GOTO lbl-1000
                v0 = pre.getName();
                var6_5 = x$13;
                if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
                    var7_6 = new Tuple2((Object)src, (Object)pre.getParentFile());
                    v1 = Nil$.MODULE$.$colon$colon((Object)var7_6);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = Nil$.MODULE$;
                }
                break block3;
            }
            throw new MatchError((Object)var3_2);
        }
        var2_7 = v1;
        return var2_7;
    }

    private Analyze$() {
        MODULE$ = this;
    }
}

