/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.RetryException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public final class QueueExecutorService {
    final ExecutorService _executor;
    final Thread _thread;

    QueueExecutorService(ExecutorService executor) {
        this._executor = executor;
        this._thread = this.executeNoThrow(new Callable<Thread>(){

            @Override
            public Thread call() {
                return Thread.currentThread();
            }
        });
    }

    public <T> T executeNoThrow(Callable<T> callable) {
        try {
            return this.execute(callable);
        }
        catch (RetryException ex) {
            assert (false);
            return null;
        }
    }

    public <T> T execute(Callable<T> callable) throws RetryException {
        if (this._thread == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                assert (ex instanceof RetryException);
                throw (RetryException)ex;
            }
        }
        boolean interrupted = false;
        try {
            Future<T> future = this._executor.submit(callable);
            while (true) {
                T t;
                try {
                    T value;
                    t = value = future.get();
                }
                catch (InterruptedException ex) {
                    try {
                        interrupted = true;
                        continue;
                    }
                    catch (RejectedExecutionException e) {
                        throw new CommunicatorDestroyedException();
                    }
                    catch (ExecutionException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (RuntimeException ex2) {
                            throw ex2;
                        }
                        catch (Throwable ex3) {
                            assert (ex3 instanceof RetryException);
                            throw (RetryException)ex3;
                        }
                    }
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

