/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.WordIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUserDictionary
implements UserDictionaryProvider {
    private final String fileBase;
    private File file;

    public FileUserDictionary() {
        this("");
    }

    public FileUserDictionary(String string) {
        if (string == null) {
            string = "";
        }
        string = string.trim();
        if ((string = string.replace('\\', '/')).length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        this.fileBase = string;
    }

    @Override
    public void addWord(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            if (this.file.length() > 0L) {
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            SpellChecker.getMessageHandler().handleException(exception);
        }
    }

    @Override
    public Iterator<String> getWords(Locale locale) {
        this.file = new File(this.fileBase + "UserDictionary_" + locale + ".txt");
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            return new WordIterator(fileInputStream, "UTF8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void setUserWords(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            SpellChecker.getMessageHandler().handleException(exception);
        }
    }
}

