/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddSelectionToRelations
extends AbstractRelationAction
implements SelectionChangedListener {
    public AddSelectionToRelations() {
        new ImageProvider("dialogs/conflict", "copyendright").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last member", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Relation orig : this.relations) {
            Command c = GenericRelationEditor.addPrimitivesToRelation(orig, MainApplication.getLayerManager().getActiveDataSet().getSelected());
            if (c == null) continue;
            cmds.add(c);
        }
        if (!cmds.isEmpty()) {
            MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Add selection to relation", new Object[0]), cmds));
            new Notification("<html>" + I18n.tr("{0}Add selection to relation{1}: Verify every single relation to avoid damage!", "<strong>", "</strong>") + "</html>").setIcon(2).show();
        }
    }

    @Override
    public void updateEnabledState() {
        int size = this.relations.size();
        this.putValue("Name", I18n.trn("Add selection to {0} relation", "Add selection to {0} relations", size, size));
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            this.selectionChanged(ds.getSelected());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        GuiHelper.runInEDT(() -> this.setEnabled(newSelection != null && !newSelection.isEmpty() && OsmUtils.isOsmCollectionEditable(this.relations)));
    }
}

