/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.RotationAngle;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public final class ExpressionFactory {
    private static final List<Method> arrayFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctions = new ArrayList<Method>();
    private static final List<Method> parameterFunctionsEnv = new ArrayList<Method>();

    private ExpressionFactory() {
    }

    public static Expression createFunctionExpression(String name, List<Expression> args) {
        if ("cond".equals(name) && args.size() == 3) {
            return new CondOperator(args.get(0), args.get(1), args.get(2));
        }
        if ("and".equals(name)) {
            return new AndOperator(args);
        }
        if ("or".equals(name)) {
            return new OrOperator(args);
        }
        if ("length".equals(name) && args.size() == 1) {
            return new LengthFunction(args.get(0));
        }
        if ("max".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, true);
        }
        if ("min".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, false);
        }
        for (Method m : arrayFunctions) {
            if (!m.getName().equals(name)) continue;
            return new ArrayFunction(m, args);
        }
        for (Method m : parameterFunctions) {
            if (!m.getName().equals(name) || args.size() != m.getParameterTypes().length) continue;
            return new ParameterFunction(m, args, false);
        }
        for (Method m : parameterFunctionsEnv) {
            if (!m.getName().equals(name) || args.size() != m.getParameterTypes().length - 1) continue;
            return new ParameterFunction(m, args, true);
        }
        return NullExpression.INSTANCE;
    }

    static {
        for (Method m : Functions.class.getDeclaredMethods()) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (paramTypes.length == 1 && paramTypes[0].isArray()) {
                arrayFunctions.add(m);
                continue;
            }
            if (paramTypes.length >= 1 && paramTypes[0].equals(Environment.class)) {
                parameterFunctionsEnv.add(m);
                continue;
            }
            parameterFunctions.add(m);
        }
        try {
            parameterFunctions.add(Math.class.getMethod("abs", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("acos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("asin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan2", Double.TYPE, Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("ceil", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cosh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("exp", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("floor", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("log", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("max", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("min", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("random", new Class[0]));
            parameterFunctions.add(Math.class.getMethod("round", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("signum", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sinh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sqrt", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tanh", Double.TYPE));
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new JosmRuntimeException(ex);
        }
    }

    public static class ArrayFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final Class<?> arrayComponentType;

        public ArrayFunction(Method m, List<Expression> args) {
            this.m = m;
            this.nullable = m.getAnnotation(NullableArguments.class) != null;
            this.args = args;
            this.expectedParameterTypes = m.getParameterTypes();
            this.arrayComponentType = this.expectedParameterTypes[0].getComponentType();
        }

        @Override
        public Object evaluate(Environment env) {
            Object[] convertedArgs = new Object[this.expectedParameterTypes.length];
            Object arrayArg = Array.newInstance(this.arrayComponentType, this.args.size());
            for (int i = 0; i < this.args.size(); ++i) {
                Object o = Cascade.convertTo(this.args.get(i).evaluate(env), this.arrayComponentType);
                if (o == null && !this.nullable) {
                    return null;
                }
                Array.set(arrayArg, i, o);
            }
            convertedArgs[0] = arrayArg;
            Object result = null;
            try {
                result = this.m.invoke(null, convertedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex);
                return null;
            }
            return result;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ArrayFunction~");
            b.append(this.m.getName()).append('(');
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.arrayComponentType).append(' ').append(this.args.get(i));
            }
            b.append(')');
            return b.toString();
        }
    }

    public static class ParameterFunction
    implements Expression {
        private final Method m;
        private final boolean nullable;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;
        private final boolean needsEnvironment;

        public ParameterFunction(Method m, List<Expression> args, boolean needsEnvironment) {
            this.m = m;
            this.nullable = m.getAnnotation(NullableArguments.class) != null;
            this.args = args;
            this.expectedParameterTypes = m.getParameterTypes();
            this.needsEnvironment = needsEnvironment;
        }

        @Override
        public Object evaluate(Environment env) {
            int i;
            Object[] convertedArgs;
            if (this.needsEnvironment) {
                convertedArgs = new Object[this.args.size() + 1];
                convertedArgs[0] = env;
                for (i = 1; i < convertedArgs.length; ++i) {
                    convertedArgs[i] = Cascade.convertTo(this.args.get(i - 1).evaluate(env), this.expectedParameterTypes[i]);
                    if (convertedArgs[i] != null || this.nullable) continue;
                    return null;
                }
            } else {
                convertedArgs = new Object[this.args.size()];
                for (i = 0; i < convertedArgs.length; ++i) {
                    convertedArgs[i] = Cascade.convertTo(this.args.get(i).evaluate(env), this.expectedParameterTypes[i]);
                    if (convertedArgs[i] != null || this.nullable) continue;
                    return null;
                }
            }
            Object result = null;
            try {
                result = this.m.invoke(null, convertedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex);
                return null;
            }
            return result;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ParameterFunction~");
            b.append(this.m.getName()).append('(');
            for (int i = 0; i < this.expectedParameterTypes.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.expectedParameterTypes[i]);
                if (!this.needsEnvironment) {
                    b.append(' ').append(this.args.get(i));
                    continue;
                }
                if (i <= 0) continue;
                b.append(' ').append(this.args.get(i - 1));
            }
            b.append(')');
            return b.toString();
        }
    }

    public static class MinMaxFunction
    implements Expression {
        private final List<Expression> args;
        private final boolean computeMax;

        public MinMaxFunction(List<Expression> args, boolean computeMax) {
            this.args = args;
            this.computeMax = computeMax;
        }

        public Float aggregateList(List<?> lst) {
            List<Float> floats = Utils.transform(lst, x -> Cascade.convertTo(x, Float.TYPE));
            SubclassFilteredCollection<Float, Float> nonNullList = SubclassFilteredCollection.filter(floats, Objects::nonNull);
            return nonNullList.isEmpty() ? Float.valueOf(Float.NaN) : (this.computeMax ? (Float)Collections.max(nonNullList) : (Float)Collections.min(nonNullList));
        }

        @Override
        public Object evaluate(Environment env) {
            List<Object> l = Cascade.convertTo(this.args.get(0).evaluate(env), List.class);
            if (this.args.size() != 1 || l == null) {
                l = Utils.transform(this.args, x -> x.evaluate(env));
            }
            return this.aggregateList(l);
        }
    }

    public static class LengthFunction
    implements Expression {
        private final Expression arg;

        public LengthFunction(Expression args) {
            this.arg = args;
        }

        @Override
        public Object evaluate(Environment env) {
            List l = Cascade.convertTo(this.arg.evaluate(env), List.class);
            if (l != null) {
                return l.size();
            }
            String s = Cascade.convertTo(this.arg.evaluate(env), String.class);
            if (s != null) {
                return s.length();
            }
            return null;
        }
    }

    public static class OrOperator
    implements Expression {
        private final List<Expression> args;

        public OrOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            for (Expression arg : this.args) {
                Boolean b = Cascade.convertTo(arg.evaluate(env), Boolean.TYPE);
                if (b == null || !b.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    public static class AndOperator
    implements Expression {
        private final List<Expression> args;

        public AndOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            for (Expression arg : this.args) {
                Boolean b = Cascade.convertTo(arg.evaluate(env), Boolean.TYPE);
                if (b != null && b.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }

    public static class CondOperator
    implements Expression {
        private final Expression condition;
        private final Expression firstOption;
        private final Expression secondOption;

        public CondOperator(Expression condition, Expression firstOption, Expression secondOption) {
            this.condition = condition;
            this.firstOption = firstOption;
            this.secondOption = secondOption;
        }

        @Override
        public Object evaluate(Environment env) {
            Boolean b = Cascade.convertTo(this.condition.evaluate(env), Boolean.TYPE);
            if (b != null && b.booleanValue()) {
                return this.firstOption.evaluate(env);
            }
            return this.secondOption.evaluate(env);
        }
    }

    public static class NullExpression
    implements Expression {
        public static final NullExpression INSTANCE = new NullExpression();

        @Override
        public Object evaluate(Environment env) {
            return null;
        }
    }

    public static final class Functions {
        private Functions() {
        }

        public static Object eval(Object o) {
            return o;
        }

        public static float plus(float ... args) {
            float res = 0.0f;
            for (float f : args) {
                res += f;
            }
            return res;
        }

        public static Float minus(float ... args) {
            if (args.length == 0) {
                return Float.valueOf(0.0f);
            }
            if (args.length == 1) {
                return Float.valueOf(-args[0]);
            }
            float res = args[0];
            for (int i = 1; i < args.length; ++i) {
                res -= args[i];
            }
            return Float.valueOf(res);
        }

        public static float times(float ... args) {
            float res = 1.0f;
            for (float f : args) {
                res *= f;
            }
            return res;
        }

        public static Float divided_by(float ... args) {
            if (args.length == 0) {
                return Float.valueOf(1.0f);
            }
            float res = args[0];
            for (int i = 1; i < args.length; ++i) {
                if (args[i] == 0.0f) {
                    return null;
                }
                res /= args[i];
            }
            return Float.valueOf(res);
        }

        public static List<Object> list(Object ... args) {
            return Arrays.asList(args);
        }

        public static Integer count(List<?> lst) {
            return lst.size();
        }

        @NullableArguments
        public static Object any(Object ... args) {
            return Utils.firstNonNull(args);
        }

        public static Object get(List<?> lst, float n) {
            int idx = Math.round(n);
            if (idx >= 0 && idx < lst.size()) {
                return lst.get(idx);
            }
            return null;
        }

        public static List<String> split(String sep, String toSplit) {
            return Arrays.asList(toSplit.split(Pattern.quote(sep), -1));
        }

        public static Color rgb(float r, float g, float b) {
            try {
                return new Color(r, g, b);
            }
            catch (IllegalArgumentException e) {
                Logging.trace(e);
                return null;
            }
        }

        public static Color rgba(float r, float g, float b, float alpha) {
            try {
                return new Color(r, g, b, alpha);
            }
            catch (IllegalArgumentException e) {
                Logging.trace(e);
                return null;
            }
        }

        public static Color hsb_color(float h, float s, float b) {
            try {
                return Color.getHSBColor(h, s, b);
            }
            catch (IllegalArgumentException e) {
                Logging.trace(e);
                return null;
            }
        }

        public static Color html2color(String html) {
            return ColorHelper.html2color(html);
        }

        public static String color2html(Color c) {
            return ColorHelper.color2html(c);
        }

        public static float red(Color c) {
            return Utils.colorInt2float(c.getRed()).floatValue();
        }

        public static float green(Color c) {
            return Utils.colorInt2float(c.getGreen()).floatValue();
        }

        public static float blue(Color c) {
            return Utils.colorInt2float(c.getBlue()).floatValue();
        }

        public static float alpha(Color c) {
            return Utils.colorInt2float(c.getAlpha()).floatValue();
        }

        @NullableArguments
        public static String concat(Object ... args) {
            return Utils.join("", Arrays.asList(args));
        }

        @NullableArguments
        public static String join(String ... args) {
            return Utils.join(args[0], Arrays.asList(args).subList(1, args.length));
        }

        public static String join_list(String separator, List<String> values) {
            return Utils.join(separator, values);
        }

        public static Object prop(Environment env, String key) {
            return Functions.prop(env, key, null);
        }

        public static Object prop(Environment env, String key, String layer) {
            return env.getCascade(layer).get(key);
        }

        public static Boolean is_prop_set(Environment env, String key) {
            return Functions.is_prop_set(env, key, null);
        }

        public static Boolean is_prop_set(Environment env, String key, String layer) {
            return env.getCascade(layer).containsKey(key);
        }

        public static String tag(Environment env, String key) {
            return env.osm == null ? null : env.osm.get(key);
        }

        public static String parent_tag(Environment env, String key) {
            if (env.parent == null) {
                if (env.osm != null) {
                    for (OsmPrimitive parent : env.osm.getReferrers()) {
                        String value = parent.get(key);
                        if (value == null) continue;
                        return value;
                    }
                }
                return null;
            }
            return env.parent.get(key);
        }

        public static List<String> parent_tags(Environment env, String key) {
            if (env.parent == null) {
                if (env.osm != null) {
                    TreeSet<String> tags = new TreeSet<String>(AlphanumComparator.getInstance());
                    for (OsmPrimitive parent : env.osm.getReferrers()) {
                        String value = parent.get(key);
                        if (value == null) continue;
                        tags.add(value);
                    }
                    return new ArrayList<String>(tags);
                }
                return Collections.emptyList();
            }
            return Collections.singletonList(env.parent.get(key));
        }

        public static String child_tag(Environment env, String key) {
            return env.child == null ? null : env.child.get(key);
        }

        public static Long parent_osm_id(Environment env) {
            return env.parent == null ? null : Long.valueOf(env.parent.getUniqueId());
        }

        public static boolean has_tag_key(Environment env, String key) {
            return env.osm.hasKey(key);
        }

        public static Float index(Environment env) {
            if (env.index == null) {
                return null;
            }
            return Float.valueOf((float)env.index.intValue() + 1.0f);
        }

        public static String role(Environment env) {
            return env.getRole();
        }

        public static Float areasize(Environment env) {
            Double area = Geometry.computeArea(env.osm);
            return area == null ? null : Float.valueOf(area.floatValue());
        }

        public static Float waylength(Environment env) {
            if (env.osm instanceof Way) {
                return Float.valueOf((float)((Way)env.osm).getLength());
            }
            return null;
        }

        public static boolean not(boolean b) {
            return !b;
        }

        public static boolean greater_equal(float a, float b) {
            return a >= b;
        }

        public static boolean less_equal(float a, float b) {
            return a <= b;
        }

        public static boolean greater(float a, float b) {
            return a > b;
        }

        public static boolean less(float a, float b) {
            return a < b;
        }

        public static double degree_to_radians(double degree) {
            return Utils.toRadians(degree);
        }

        public static Double cardinal_to_radians(String cardinal) {
            try {
                return RotationAngle.parseCardinalRotation(cardinal);
            }
            catch (IllegalArgumentException ignore) {
                Logging.trace(ignore);
                return null;
            }
        }

        public static boolean equal(Object a, Object b) {
            if (a.getClass() == b.getClass()) {
                return a.equals(b);
            }
            if (a.equals(Cascade.convertTo(b, a.getClass()))) {
                return true;
            }
            return b.equals(Cascade.convertTo(a, b.getClass()));
        }

        public static boolean not_equal(Object a, Object b) {
            return !Functions.equal(a, b);
        }

        public static Boolean JOSM_search(Environment env, String searchStr) {
            SearchCompiler.Match m;
            try {
                m = SearchCompiler.compile(searchStr);
            }
            catch (SearchParseError ex) {
                Logging.trace(ex);
                return null;
            }
            return m.match(env.osm);
        }

        public static String JOSM_pref(Environment env, String key, String def) {
            return MapPaintStyles.getStyles().getPreferenceCached(key, def);
        }

        public static boolean regexp_test(String pattern, String target) {
            return Pattern.matches(pattern, target);
        }

        public static boolean regexp_test(String pattern, String target, String flags) {
            int f = 0;
            if (flags.contains("i")) {
                f |= 2;
            }
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            return Pattern.compile(pattern, f).matcher(target).matches();
        }

        public static List<String> regexp_match(String pattern, String target, String flags) {
            int f = 0;
            if (flags.contains("i")) {
                f |= 2;
            }
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            return Utils.getMatches(Pattern.compile(pattern, f).matcher(target));
        }

        public static List<String> regexp_match(String pattern, String target) {
            return Utils.getMatches(Pattern.compile(pattern).matcher(target));
        }

        public static long osm_id(Environment env) {
            return env.osm.getUniqueId();
        }

        @NullableArguments
        public static String tr(String ... args) {
            String text = args[0];
            System.arraycopy(args, 1, args, 0, args.length - 1);
            return I18n.tr(text, args);
        }

        public static String substring(String s, float begin) {
            return s == null ? null : s.substring((int)begin);
        }

        public static String substring(String s, float begin, float end) {
            return s == null ? null : s.substring((int)begin, (int)end);
        }

        public static String replace(String s, String target, String replacement) {
            return s == null ? null : s.replace(target, replacement);
        }

        public static String upper(String s) {
            return s == null ? null : s.toUpperCase(Locale.ENGLISH);
        }

        public static String lower(String s) {
            return s == null ? null : s.toLowerCase(Locale.ENGLISH);
        }

        public static String trim(String s) {
            return Utils.strip(s);
        }

        public static String URL_decode(String s) {
            if (s == null) {
                return null;
            }
            try {
                return Utils.decodeUrl(s);
            }
            catch (IllegalStateException e) {
                Logging.debug(e);
                return s;
            }
        }

        public static String URL_encode(String s) {
            return s == null ? null : Utils.encodeUrl(s);
        }

        public static String XML_encode(String s) {
            return s == null ? null : XmlWriter.encode(s);
        }

        public static long CRC32_checksum(String s) {
            CRC32 cs = new CRC32();
            cs.update(s.getBytes(StandardCharsets.UTF_8));
            return cs.getValue();
        }

        public static boolean is_right_hand_traffic(Environment env) {
            return RightAndLefthandTraffic.isRightHandTraffic(Functions.center(env));
        }

        public static boolean is_clockwise(Environment env) {
            if (!(env.osm instanceof Way)) {
                return false;
            }
            Way way = (Way)env.osm;
            return way.isClosed() && Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
        }

        public static boolean is_anticlockwise(Environment env) {
            if (!(env.osm instanceof Way)) {
                return false;
            }
            Way way = (Way)env.osm;
            return way.isClosed() && !Geometry.isClockwise(way) || !way.isClosed() && way.getNodesCount() > 2 && !Geometry.angleIsClockwise(way.getNode(0), way.getNode(1), way.lastNode());
        }

        @NullableArguments
        public static Object print(Object o) {
            System.out.print(o == null ? "none" : o.toString());
            return o;
        }

        @NullableArguments
        public static Object println(Object o) {
            System.out.println(o == null ? "none" : o.toString());
            return o;
        }

        public static int number_of_tags(Environment env) {
            return env.osm.getNumKeys();
        }

        public static Object setting(Environment env, String key) {
            return env.source.settingValues.get(key);
        }

        public static LatLon center(Environment env) {
            return env.osm instanceof Node ? ((Node)env.osm).getCoor() : env.osm.getBBox().getCenter();
        }

        public static boolean inside(Environment env, String codes) {
            for (String code : codes.toUpperCase(Locale.ENGLISH).split(",")) {
                if (!Territories.isIso3166Code(code.trim(), Functions.center(env))) continue;
                return true;
            }
            return false;
        }

        public static boolean outside(Environment env, String codes) {
            return !Functions.inside(env, codes);
        }

        public static boolean at(Environment env, double lat, double lon) {
            return new LatLon(lat, lon).equalsEpsilon(Functions.center(env));
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NullableArguments {
    }
}

