/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class PopupMenuLauncher
extends MouseAdapter {
    protected JPopupMenu menu;
    private final boolean checkEnabled;

    public PopupMenuLauncher() {
        this(null);
    }

    public PopupMenuLauncher(JPopupMenu menu) {
        this(menu, false);
    }

    public PopupMenuLauncher(JPopupMenu menu, boolean checkEnabled) {
        this.menu = menu;
        this.checkEnabled = checkEnabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processEvent(e);
    }

    private void processEvent(MouseEvent e) {
        if (e.isPopupTrigger() && (!this.checkEnabled || e.getComponent().isEnabled())) {
            this.launch(e);
        }
    }

    public void launch(MouseEvent evt) {
        Component component;
        if (evt != null && this.checkSelection(component = evt.getComponent(), evt.getPoint())) {
            this.checkFocusAndShowMenu(component, evt);
        }
    }

    protected boolean checkSelection(Component component, Point p) {
        if (component instanceof JList) {
            return this.checkListSelection((JList)component, p) > -1;
        }
        if (component instanceof JTable) {
            return this.checkTableSelection((JTable)component, p) > -1;
        }
        if (component instanceof JTree) {
            return this.checkTreeSelection((JTree)component, p) != null;
        }
        return true;
    }

    protected void checkFocusAndShowMenu(final Component component, final MouseEvent evt) {
        if (component != null && component.isFocusable() && !component.hasFocus() && component.requestFocusInWindow()) {
            component.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    PopupMenuLauncher.this.showMenu(evt);
                    component.removeFocusListener(this);
                }
            });
        } else {
            this.showMenu(evt);
        }
    }

    protected void showMenu(MouseEvent evt) {
        if (this.menu != null && evt != null) {
            this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    protected int checkListSelection(JList<?> list, Point p) {
        int idx = list.locationToIndex(p);
        if (idx >= 0 && idx < list.getModel().getSize() && list.getSelectedIndices().length < 2 && !list.isSelectedIndex(idx)) {
            list.setSelectedIndex(idx);
        }
        return idx;
    }

    protected int checkTableSelection(JTable table, Point p) {
        int row = table.rowAtPoint(p);
        if (row >= 0 && row < table.getRowCount() && table.getSelectedRowCount() < 2 && table.getSelectedRow() != row) {
            table.getSelectionModel().setSelectionInterval(row, row);
        }
        return row;
    }

    protected TreePath checkTreeSelection(JTree tree, Point p) {
        TreePath path = tree.getPathForLocation(p.x, p.y);
        if (path != null && tree.getSelectionCount() < 2 && !tree.isPathSelected(path)) {
            tree.setSelectionPath(path);
        }
        return path;
    }

    protected static boolean isDoubleClick(MouseEvent e) {
        return e != null && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2;
    }

    public final JPopupMenu getMenu() {
        return this.menu;
    }
}

