/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.protege.editor.core.log.LogView;
import org.protege.editor.core.log.LoggingEventTranslator;
import org.protege.editor.core.ui.error.ErrorLogListener;
import org.slf4j.LoggerFactory;

public class LogManager {
    private final LogView logView;
    private final AppenderBase<ILoggingEvent> appender;
    private final List<ErrorLogListener> listenerList = new ArrayList<ErrorLogListener>();
    private final LoggingEventTranslator translator = new LoggingEventTranslator();
    private final JDialog logViewDialog;

    public LogManager(LogView logView) {
        this.logView = logView;
        this.appender = new AppenderBase<ILoggingEvent>(){

            protected void append(ILoggingEvent event) {
                LogManager.this.logView.append(LogManager.this.translator.toLogRecord(event));
                if (event.getLevel() == Level.ERROR) {
                    LogManager.this.fireErrorLogged();
                }
            }
        };
        JOptionPane op = new JOptionPane(logView.asJComponent(), -1);
        this.logViewDialog = op.createDialog(null, "Log");
        this.logViewDialog.setModal(false);
        this.logViewDialog.setResizable(true);
    }

    public void addErrorLogListener(ErrorLogListener listener) {
        this.listenerList.add(listener);
    }

    public void removeErrorLogListener(ErrorLogListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireErrorLogged() {
        new ArrayList<ErrorLogListener>(this.listenerList).stream().forEach(ErrorLogListener::errorLogged);
    }

    private Logger getRootLogger() {
        return (Logger)LoggerFactory.getLogger((String)"ROOT");
    }

    public void bind() {
        Logger rootLogger = this.getRootLogger();
        rootLogger.addAppender(this.appender);
        this.appender.start();
    }

    public void unbind() {
        this.appender.stop();
        this.getRootLogger().detachAppender(this.appender);
    }

    public void showLogView() {
        this.logViewDialog.setVisible(true);
    }
}

