/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.FXVKCharEntities;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.resources.EmbeddedResources;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.util.Duration;

public class FXVKSkin
extends SkinBase<FXVK, BehaviorBase<FXVK>> {
    private static Popup vkPopup;
    private static Popup secondaryPopup;
    private static FXVK primaryVK;
    private static Timeline slideInTimeline;
    private static Timeline slideOutTimeline;
    private static FXVK secondaryVK;
    private static Timeline secondaryVKDelay;
    private static CharKey secondaryVKKey;
    private Node attachedNode;
    FXVK fxvk;
    Control[][] keyRows;
    private State state = State.NORMAL;
    static final double VK_WIDTH = 640.0;
    static final double VK_HEIGHT = 243.0;
    static final double VK_PORTRAIT_HEIGHT = 326.0;
    static final double VK_SLIDE_MILLIS = 250.0;
    static final double PREF_KEY_WIDTH = 56.0;
    static final double PREF_PORTRAIT_KEY_WIDTH = 40.0;
    static final double PREF_KEY_HEIGHT = 56.0;
    double keyWidth = 56.0;
    double keyHeight = 56.0;
    private ShiftKey shiftKey;
    private SymbolKey symbolKey;
    private VBox vbox;
    private static DoubleProperty winY;

    public FXVKSkin(final FXVK fXVK) {
        super(fXVK, new BehaviorBase<FXVK>(fXVK));
        this.fxvk = fXVK;
        fXVK.setFocusTraversable(false);
        fXVK.attachedNodeProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                Node node = FXVKSkin.this.attachedNode;
                FXVKSkin.this.attachedNode = fXVK.getAttachedNode();
                if (fXVK != FXVK.vk) {
                    return;
                }
                if (FXVKSkin.this.attachedNode != null) {
                    if (FXVKSkin.this.keyRows == null) {
                        FXVKSkin.this.createKeys();
                    }
                    Scene scene = FXVKSkin.this.attachedNode.getScene();
                    fXVK.setVisible(true);
                    if (fXVK != secondaryVK) {
                        if (secondaryVKDelay == null) {
                            secondaryVKDelay = new Timeline();
                        }
                        KeyFrame keyFrame = new KeyFrame(Duration.millis(500.0), new EventHandler<ActionEvent>(){

                            @Override
                            public void handle(ActionEvent actionEvent) {
                                if (secondaryVKKey != null) {
                                    FXVKSkin.this.showSecondaryVK(secondaryVKKey);
                                }
                            }
                        }, new KeyValue[0]);
                        secondaryVKDelay.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame});
                        if (vkPopup == null) {
                            vkPopup = new Popup();
                            double d = Utils.getScreen(FXVKSkin.this.attachedNode).getBounds().getHeight();
                            double d2 = Utils.getScreen(FXVKSkin.this.attachedNode).getVisualBounds().getHeight();
                            d2 = Math.min(d, d2 + 4.0);
                            slideInTimeline = new Timeline();
                            slideInTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), new KeyValue(winY, d2 - fXVK.prefHeight(-1.0), Interpolator.EASE_BOTH))});
                            slideOutTimeline = new Timeline();
                            slideOutTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(250.0), new KeyValue(winY, d, Interpolator.EASE_BOTH))});
                        }
                        vkPopup.getContent().setAll((Node[])new Node[]{fXVK});
                        if (!vkPopup.isShowing()) {
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    Rectangle2D rectangle2D = Utils.getScreen(FXVKSkin.this.attachedNode).getBounds();
                                    vkPopup.show(FXVKSkin.this.attachedNode, (rectangle2D.getWidth() - fXVK.prefWidth(-1.0)) / 2.0, rectangle2D.getHeight() - fXVK.prefHeight(-1.0));
                                }
                            });
                        }
                        if (node == null || node.getScene() != FXVKSkin.this.attachedNode.getScene()) {
                            fXVK.setPrefWidth(scene.getWidth());
                            fXVK.setMaxWidth(Double.NEGATIVE_INFINITY);
                            fXVK.setPrefHeight(200.0);
                        }
                        if (fXVK.getHeight() > 0.0 && (fXVK.getLayoutY() == 0.0 || fXVK.getLayoutY() > scene.getHeight() - fXVK.getHeight())) {
                            slideOutTimeline.stop();
                            winY.set(vkPopup.getY());
                            slideInTimeline.playFromStart();
                        }
                        if (node == null || node.getScene() != FXVKSkin.this.attachedNode.getScene()) {
                            fXVK.setPrefWidth(640.0);
                            fXVK.setMinWidth(Double.NEGATIVE_INFINITY);
                            fXVK.setMaxWidth(Double.NEGATIVE_INFINITY);
                            fXVK.setPrefHeight(243.0);
                            fXVK.setMinHeight(Double.NEGATIVE_INFINITY);
                        }
                    }
                } else {
                    if (fXVK != secondaryVK) {
                        slideInTimeline.stop();
                        winY.set(vkPopup.getY());
                        slideOutTimeline.playFromStart();
                    }
                    if (secondaryVK != null) {
                        secondaryVK.setAttachedNode(null);
                        secondaryPopup.hide();
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void createKeys() {
        Object object;
        int n;
        String[] stringArray;
        this.getChildren().clear();
        if (this.fxvk.chars != null) {
            int n2 = this.fxvk.chars.length;
            if (n2 > 1) {
                stringArray = new String[n2];
                int n3 = 0;
                for (String string : this.fxvk.chars) {
                    if (!Character.isLetter(string.charAt(0))) continue;
                    stringArray[n3++] = string;
                }
                for (String string : this.fxvk.chars) {
                    if (Character.isLetter(string.charAt(0))) continue;
                    stringArray[n3++] = string;
                }
                int n4 = (int)Math.floor(Math.sqrt(Math.max(1, n2 - 2)));
                n = (int)Math.ceil((double)n2 / (double)n4);
                this.keyRows = new Control[n4][];
                for (int i = 0; i < n4; ++i) {
                    this.keyRows[i] = this.makeKeyRow(Arrays.copyOfRange(stringArray, i * n, Math.min((i + 1) * n, n2)));
                }
            } else {
                this.keyRows = new Control[0][];
            }
        } else {
            ArrayList<Control[]> arrayList = new ArrayList<Control[]>();
            stringArray = new ArrayList();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            String string = FXVK.VK_TYPE_NAMES[this.fxvk.vkType];
            n = 0;
            try {
                String string2 = "FXVK." + string + ".row%d.key%02d";
                while (EmbeddedResources.getBundle().containsKey(String.format(string2, ++n, 1))) {
                    int n5 = 0;
                    while (EmbeddedResources.getBundle().containsKey(String.format(string2, n, ++n5))) {
                        void object2;
                        stringArray.add(EmbeddedResources.getString(String.format(string2, n, n5)));
                        Double d = -1.0;
                        object = String.format(string2 + ".width", n, n5);
                        if (EmbeddedResources.getBundle().containsKey((String)object)) {
                            try {
                                Double d2 = new Double(EmbeddedResources.getString((String)object));
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println((String)object + "=" + EmbeddedResources.getString((String)object));
                                System.err.println(numberFormatException);
                            }
                        }
                        arrayList2.add((Double)object2);
                    }
                    arrayList.add(this.makeKeyRow((List<String>)stringArray, arrayList2));
                    stringArray.clear();
                    arrayList2.clear();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.keyRows = (Control[][])arrayList.toArray((T[])new Control[arrayList.size()][]);
        }
        this.vbox = new VBox();
        this.vbox.setId("vbox");
        this.getChildren().add(this.vbox);
        for (Control[] controlArray : this.keyRows) {
            HBox hBox = new HBox();
            hBox.setId("hbox");
            hBox.setAlignment(this.fxvk.chars != null ? Pos.CENTER_LEFT : Pos.CENTER);
            this.vbox.getChildren().add(hBox);
            for (Control control : controlArray) {
                hBox.getChildren().add(control);
                HBox.setHgrow(control, Priority.ALWAYS);
                if (!(control instanceof Key)) continue;
                object = (Key)control;
                int n2 = ((Labeled)object).getText().length();
                if (n2 != 1 && object.getClass().getSimpleName().equals("CharKey")) {
                    ((Labeled)object).setGraphicTextGap(((Labeled)object).getGraphicTextGap() + (double)(2 * n2));
                }
                if (!(((Labeled)object).getGraphic() instanceof Label)) continue;
            }
        }
    }

    private Control[] makeKeyRow(String ... stringArray) {
        return this.makeKeyRow(Arrays.asList(stringArray), null);
    }

    private Control[] makeKeyRow(List<String> list, List<Double> list2) {
        Control[] controlArray = new Control[list.size()];
        for (int i = 0; i < controlArray.length; ++i) {
            CommandKey commandKey;
            String string = list.get(i);
            Double d = 1.0;
            if (list2 != null && list2.get(i) > 0.0) {
                d = list2.get(i);
            }
            if ("BACKSPACE".equals(string)) {
                commandKey = new CommandKey("\u232b", KeyCode.BACK_SPACE, d);
                commandKey.setId("backspace-key");
                this.setIcon(commandKey, "fxvk-backspace-button.png");
                controlArray[i] = commandKey;
                continue;
            }
            if ("ENTER".equals(string)) {
                commandKey = new CommandKey("\u21b5", KeyCode.ENTER, d);
                commandKey.setId("enter-key");
                this.setIcon(commandKey, "fxvk-enter-button.png");
                controlArray[i] = commandKey;
                continue;
            }
            if ("SHIFT".equals(string)) {
                this.shiftKey = new ShiftKey(d);
                this.shiftKey.setId("shift-key");
                this.setIcon(this.shiftKey, "fxvk-shift-button.png");
                controlArray[i] = this.shiftKey;
                continue;
            }
            if ("SYM".equals(string)) {
                this.symbolKey = new SymbolKey("!#123 ABC", d);
                this.symbolKey.setId("symbol-key");
                controlArray[i] = this.symbolKey;
                continue;
            }
            controlArray[i] = new CharKey(list.get(i), d);
        }
        return controlArray;
    }

    private void setState(State state) {
        this.state = state;
        this.shiftKey.setPressState(state == State.SHIFTED || state == State.SHIFT_LOCK);
        this.shiftKey.setDisable(state == State.NUMERIC);
        this.shiftKey.setId(state == State.SHIFT_LOCK ? "capslock-key" : "shift-key");
        switch (state) {
            case NUMERIC: {
                this.setIcon(this.shiftKey, null);
                break;
            }
            case SHIFT_LOCK: {
                this.setIcon(this.shiftKey, "fxvk-capslock-button.png");
                break;
            }
            default: {
                this.setIcon(this.shiftKey, "fxvk-shift-button.png");
            }
        }
        if (this.fxvk == secondaryVK) {
            ((FXVKSkin)primaryVK.getSkin()).updateLabels();
        } else {
            this.updateLabels();
        }
    }

    private void setIcon(Key key, String string) {
        if (string != null) {
            String string2 = this.getClass().getResource("caspian/" + string).toExternalForm();
            key.setGraphic(new ImageView(string2));
        } else {
            key.setGraphic(null);
        }
    }

    private void updateLabels() {
        Control[][] controlArray = this.keyRows;
        int n = controlArray.length;
        for (int i = 0; i < n; ++i) {
            Control[] controlArray2;
            for (Control control : controlArray2 = controlArray[i]) {
                String string;
                if (!(control instanceof CharKey)) continue;
                CharKey charKey = (CharKey)control;
                String string2 = charKey.chars[0];
                String string3 = string = charKey.chars.length > 1 ? charKey.chars[1] : "";
                if (charKey.chars.length > 1 && this.state == State.NUMERIC) {
                    string2 = charKey.chars[1];
                    string = charKey.chars.length > 2 && !Character.isLetter(charKey.chars[2].charAt(0)) ? charKey.chars[2] : "";
                } else if (this.state == State.SHIFTED || this.state == State.SHIFT_LOCK) {
                    string2 = string2.toUpperCase();
                }
                charKey.setText(string2);
                if (charKey.graphic == null) continue;
                charKey.graphic.setText(string);
            }
        }
        if (this.symbolKey != null) {
            this.symbolKey.setText(this.symbolKey.chars[this.state == State.NUMERIC ? 1 : 0]);
        }
    }

    private void fireKeyEvent(Node node, EventType<? extends KeyEvent> eventType, KeyCode keyCode, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        try {
            Field field = FXRobotHelper.class.getDeclaredField("inputAccessor");
            field.setAccessible(true);
            FXRobotHelper.FXRobotInputAccessor fXRobotInputAccessor = (FXRobotHelper.FXRobotInputAccessor)field.get(null);
            node.fireEvent(fXRobotInputAccessor.createKeyEvent(eventType, keyCode, string, string2, bl, bl2, bl3, bl4));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public void layoutChildren() {
        double d;
        double d2;
        int n;
        Insets insets = this.getInsets();
        if (this.vbox == null) {
            this.createKeys();
        }
        HBox hBox = (HBox)this.vbox.getChildren().get(0);
        double d3 = hBox.getSpacing();
        double d4 = 0.0;
        int n2 = 0;
        for (Node node : this.vbox.getChildren()) {
            hBox = (HBox)node;
            n = 0;
            double d5 = 0.0;
            for (Node node2 : hBox.getChildren()) {
                Key node3 = (Key)node2;
                ++n;
                d5 += node3.keyWidth;
            }
            n2 = Math.max(n2, n);
            d4 = Math.max(d4, d5);
        }
        if (this.fxvk == secondaryVK) {
            d2 = 40.0;
            d = ((FXVKSkin)FXVKSkin.primaryVK.getSkin()).keyHeight;
        } else {
            d2 = (hBox.getWidth() - (double)(n2 - 1) * d3) / Math.max(d4, 10.0);
            d = (this.getHeight() - insets.getTop() - insets.getBottom() - (double)(this.keyRows.length - 1) * this.vbox.getSpacing()) / (double)this.keyRows.length;
        }
        if (this.keyWidth != d2 || this.keyHeight != d) {
            this.keyWidth = d2;
            this.keyHeight = d;
            this.createKeys();
        }
        super.layoutChildren();
        for (Node node : this.vbox.getChildren()) {
            hBox = (HBox)node;
            n = 0;
            int n3 = 0;
            double d5 = 0.0;
            for (Node node2 : hBox.getChildren()) {
                Key key = (Key)node2;
                ++n;
                if (key.keyWidth > 1.0) {
                    ++n3;
                }
                d5 += key.keyWidth;
            }
            double d7 = hBox.getWidth() - (double)(n - 1) * d3 - d5 * d2;
            for (Node node3 : hBox.getChildren()) {
                Key key = (Key)node3;
                if ((this.fxvk.vkType != 1 || this.fxvk.getStyleClass().contains("fxvk-portrait")) && d7 > 0.0 && key.keyWidth > 1.0) {
                    key.setPrefWidth(key.keyWidth * this.keyWidth + d7 / (double)n3);
                    continue;
                }
                key.setPrefWidth(key.keyWidth * this.keyWidth);
            }
        }
    }

    private void showSecondaryVK(final CharKey charKey) {
        if (charKey != null) {
            Object object;
            primaryVK = this.fxvk;
            Node node = primaryVK.getAttachedNode();
            if (secondaryVK == null) {
                secondaryVK = new FXVK();
                secondaryVK.getStyleClass().addAll((String[])new String[]{"fxvk-secondary", "fxvk-portrait"});
                secondaryVK.setSkin(new FXVKSkin(secondaryVK));
                secondaryPopup = new Popup();
                secondaryPopup.setAutoHide(true);
                secondaryPopup.getContent().add(secondaryVK);
                secondaryVK.impl_processCSS(false);
            }
            if (this.state == State.NUMERIC) {
                object = new ArrayList<String>();
                for (String string : charKey.chars) {
                    if (Character.isLetter(string.charAt(0))) continue;
                    ((ArrayList)object).add(string);
                }
                FXVKSkin.secondaryVK.chars = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
            } else {
                object = new ArrayList();
                for (String string : charKey.chars) {
                    if (!Character.isLetter(string.charAt(0))) continue;
                    if (this.state == State.SHIFTED || this.state == State.SHIFT_LOCK) {
                        ((ArrayList)object).add(string.toUpperCase());
                        continue;
                    }
                    ((ArrayList)object).add(string);
                }
                if (charKey.chars.length > 1 && !Character.isLetter(charKey.chars[1].charAt(0))) {
                    ((ArrayList)object).add(charKey.chars[1]);
                }
                FXVKSkin.secondaryVK.chars = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
            }
            if (FXVKSkin.secondaryVK.chars.length > 1) {
                if (secondaryVK.getSkin() != null) {
                    ((FXVKSkin)secondaryVK.getSkin()).createKeys();
                }
                secondaryVK.setAttachedNode(node);
                object = (FXVKSkin)primaryVK.getSkin();
                FXVKSkin fXVKSkin = (FXVKSkin)secondaryVK.getSkin();
                Insets insets = fXVKSkin.getInsets();
                int n = FXVKSkin.secondaryVK.chars.length;
                int n2 = (int)Math.floor(Math.sqrt(Math.max(1, n - 2)));
                int n3 = (int)Math.ceil((double)n / (double)n2);
                HBox hBox = (HBox)this.vbox.getChildren().get(0);
                final double d = insets.getLeft() + insets.getRight() + (double)n3 * 40.0 + (double)(n3 - 1) * hBox.getSpacing();
                final double d2 = insets.getTop() + insets.getBottom() + (double)n2 * ((FXVKSkin)object).keyHeight + (double)(n2 - 1) * this.vbox.getSpacing();
                secondaryVK.setPrefWidth(d);
                secondaryVK.setMinWidth(Double.NEGATIVE_INFINITY);
                secondaryVK.setPrefHeight(d2);
                secondaryVK.setMinHeight(Double.NEGATIVE_INFINITY);
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        Point2D point2D = Utils.pointRelativeTo(charKey, d, d2, HPos.CENTER, VPos.TOP, 5.0, -3.0, true);
                        double d3 = point2D.getX();
                        double d22 = point2D.getY();
                        Scene scene = charKey.getScene();
                        d3 = Math.min(d3, scene.getWindow().getX() + scene.getWidth() - d);
                        secondaryPopup.show(charKey.getScene().getWindow(), d3, d22);
                    }
                });
            }
        } else if (secondaryVK != null) {
            secondaryVK.setAttachedNode(null);
            secondaryPopup.hide();
        }
    }

    static {
        winY = new SimpleDoubleProperty();
        winY.addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (vkPopup != null) {
                    vkPopup.setY(winY.get());
                }
            }
        });
    }

    private class CharKey
    extends Key {
        String str;
        String[] chars;
        Label graphic;
        EventHandler<ActionEvent> actionHandler;

        CharKey(String string, double d) {
            super(null, d);
            this.actionHandler = new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (FXVKSkin.this.fxvk != secondaryVK && secondaryPopup != null && secondaryPopup.isShowing()) {
                        return;
                    }
                    Node node = FXVKSkin.this.fxvk.getAttachedNode();
                    if (node instanceof EventTarget) {
                        String string = CharKey.this.getText();
                        if (string.length() > 1 && string.contains(" ")) {
                            string = string.split(" ")[0];
                        }
                        for (int i = 0; i < string.length(); ++i) {
                            String string2 = string.substring(i, i + 1);
                            FXVKSkin.this.fireKeyEvent(node, KeyEvent.KEY_TYPED, null, string2, string2, FXVKSkin.this.state == State.SHIFTED, false, false, false);
                        }
                        if (FXVKSkin.this.state == State.SHIFTED) {
                            FXVKSkin.this.setState(State.NORMAL);
                        }
                    }
                    if (FXVKSkin.this.fxvk == secondaryVK) {
                        FXVKSkin.this.showSecondaryVK(null);
                    }
                }
            };
            this.str = string;
            this.setOnAction(this.actionHandler);
            if (FXVKSkin.this.fxvk != secondaryVK) {
                this.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        FXVKSkin.this.showSecondaryVK(null);
                        secondaryVKKey = CharKey.this;
                        secondaryVKDelay.playFromStart();
                    }
                });
                this.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        secondaryVKDelay.stop();
                    }
                });
            }
            if (string.length() == 1) {
                this.chars = new String[]{string};
            } else {
                this.chars = string.split(" ");
                for (int i = 0; i < this.chars.length; ++i) {
                    this.chars[i] = FXVKCharEntities.get(this.chars[i]);
                }
            }
            this.setContentDisplay(ContentDisplay.TOP);
            this.setGraphicTextGap(-16.0);
            this.setText(this.chars[0]);
            this.setId(this.chars[0]);
            if (this.getText().length() > 1) {
                this.getStyleClass().add("multi-char-key");
            }
            this.graphic = new Label(this.chars.length > 1 ? this.chars[1] : " ");
            this.graphic.setPrefWidth(FXVKSkin.this.keyWidth - 6.0);
            this.graphic.setMinWidth(Double.NEGATIVE_INFINITY);
            this.graphic.setPrefHeight(FXVKSkin.this.keyHeight / 2.0 - 8.0);
            this.setGraphic(this.graphic);
        }
    }

    private class CommandKey
    extends Key {
        KeyCode code;
        EventHandler<ActionEvent> actionHandler;

        CommandKey(String string, KeyCode keyCode, double d) {
            super(string, d);
            this.actionHandler = new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    FXVKSkin.this.showSecondaryVK(null);
                    Node node = FXVKSkin.this.fxvk.getAttachedNode();
                    if (node instanceof EventTarget) {
                        String string = CommandKey.this.getText();
                        FXVKSkin.this.fireKeyEvent(node, KeyEvent.KEY_PRESSED, CommandKey.this.code, null, null, false, false, false, false);
                        if (FXVKSkin.this.state == State.SHIFTED) {
                            FXVKSkin.this.setState(State.NORMAL);
                        }
                    }
                }
            };
            this.code = keyCode;
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.getStyleClass().add("special-key");
            this.setOnAction(this.actionHandler);
        }
    }

    private class Key
    extends Button {
        private double keyWidth;

        private Key(String string, double d) {
            super(string);
            this.keyWidth = d;
            this.getStyleClass().add("key");
            this.setFocusTraversable(false);
            this.setMinHeight(Double.NEGATIVE_INFINITY);
            this.setPrefHeight(FXVKSkin.this.keyHeight);
        }
    }

    private class ShiftKey
    extends Key {
        EventHandler<ActionEvent> actionHandler;

        ShiftKey(double d) {
            super("\u21d1", d);
            this.actionHandler = new EventHandler<ActionEvent>(){
                long lastTime = -1L;

                @Override
                public void handle(ActionEvent actionEvent) {
                    FXVKSkin.this.showSecondaryVK(null);
                    long l = System.currentTimeMillis();
                    if (this.lastTime > 0L && l - this.lastTime < 600L) {
                        FXVKSkin.this.setState(State.SHIFT_LOCK);
                    } else if (FXVKSkin.this.state == State.SHIFTED || FXVKSkin.this.state == State.SHIFT_LOCK) {
                        FXVKSkin.this.setState(State.NORMAL);
                    } else {
                        FXVKSkin.this.setState(State.SHIFTED);
                    }
                    this.lastTime = l;
                }
            };
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.getStyleClass().add("special-key");
            this.setFocusTraversable(false);
            this.setOnAction(this.actionHandler);
        }

        private void setPressState(boolean bl) {
            this.setPressed(bl);
        }
    }

    static enum State {
        NORMAL,
        SHIFTED,
        SHIFT_LOCK,
        NUMERIC;

    }

    private class SymbolKey
    extends Key {
        String str;
        String[] chars;
        EventHandler<ActionEvent> actionHandler;

        SymbolKey(String string, double d) {
            super(null, d);
            this.actionHandler = new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    FXVKSkin.this.setState(FXVKSkin.this.state == State.NUMERIC ? State.NORMAL : State.NUMERIC);
                    FXVKSkin.this.showSecondaryVK(null);
                }
            };
            this.str = string;
            this.getStyleClass().add("special-key");
            this.chars = string.length() == 1 ? new String[]{string} : string.split(" ");
            this.setText(this.chars[0]);
            this.setOnAction(this.actionHandler);
        }
    }
}

