/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class LiveActions {
    private TreeNode _target;
    private Action[] _array = new Action[25];

    public Action get(int index) {
        return this._array[index];
    }

    public boolean[] setTarget(TreeNode target) {
        this._target = target;
        boolean[] availableActions = this._target == null ? new boolean[25] : this._target.getAvailableActions();
        for (int i = 0; i < this._array.length; ++i) {
            this._array[i].setEnabled(availableActions[i]);
        }
        return availableActions;
    }

    LiveActions() {
        this._array[0] = new AbstractAction("Start", Utils.getIcon("/icons/16x16/start.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.start();
            }
        };
        this._array[0].putValue("ShortDescription", "Start this server or service");
        this._array[1] = new AbstractAction("Stop", Utils.getIcon("/icons/16x16/stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.stop();
            }
        };
        this._array[1].putValue("ShortDescription", "Stop this server or service");
        this._array[2] = new AbstractAction("Enable", Utils.getIcon("/icons/16x16/enable.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.enable();
            }
        };
        this._array[2].putValue("ShortDescription", "Enable this server");
        this._array[3] = new AbstractAction("Disable", Utils.getIcon("/icons/16x16/disable.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.disable();
            }
        };
        this._array[3].putValue("ShortDescription", "Disable this server");
        this._array[4] = new SendSignal("SIGHUP");
        this._array[5] = new SendSignal("SIGINT");
        this._array[6] = new SendSignal("SIGQUIT");
        this._array[7] = new SendSignal("SIGKILL");
        this._array[8] = new SendSignal("SIGUSR1");
        this._array[9] = new SendSignal("SIGUSR2");
        this._array[10] = new SendSignal("SIGTERM");
        this._array[11] = new AbstractAction("Write Message"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.writeMessage();
            }
        };
        this._array[11].putValue("ShortDescription", "Write message to stdout or stderr");
        this._array[12] = new AbstractAction("Retrieve Ice log"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.retrieveIceLog();
            }
        };
        this._array[12].putValue("ShortDescription", "Attach RemoteLogger to Ice logger");
        this._array[13] = new AbstractAction("Retrieve stdout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.retrieveOutput(true);
            }
        };
        this._array[13].putValue("ShortDescription", "Retrieve stdout if redirected to file");
        this._array[14] = new AbstractAction("Retrieve stderr"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.retrieveOutput(false);
            }
        };
        this._array[14].putValue("ShortDescription", "Retrieve stderr if redirected to file");
        this._array[15] = new AbstractAction("Retrieve log file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.retrieveLogFile();
            }
        };
        this._array[15].putValue("ShortDescription", "Retrieve log file");
        this._array[16] = new AbstractAction("Shutdown"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.shutdownNode();
            }
        };
        this._array[17] = new AbstractAction("Shutdown"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.shutdownRegistry();
            }
        };
        this._array[18] = new AbstractAction("Patch Distribution"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.patchServer();
            }
        };
        this._array[19] = new AbstractAction("Add Well-known Object"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.addObject();
            }
        };
        this._array[20] = new AbstractAction("Open Definition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.openDefinition();
            }
        };
        this._array[21] = new AbstractAction("Enable Metrics View"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.enableMetricsView(true);
            }
        };
        this._array[22] = new AbstractAction("Disable Metrics View"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.enableMetricsView(false);
            }
        };
        this._array[23] = new AbstractAction("Start All Servers"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.startAllServers();
            }
        };
        this._array[24] = new AbstractAction("Stop All Servers"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveActions.this._target.stopAllServers();
            }
        };
    }

    class SendSignal
    extends AbstractAction {
        private String _name;

        SendSignal(String name) {
            super(name);
            this._name = name;
            this.putValue("ShortDescription", "Send " + this._name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LiveActions.this._target.signal(this._name);
        }
    }
}

