/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Serializer;

public class DefaultCacheLockingManager
implements CacheLockingManager,
Closeable {
    private final PersistentCache cache;

    public DefaultCacheLockingManager(CacheRepository cacheRepository, ArtifactCacheMetadata cacheMetaData) {
        this.cache = cacheRepository.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("artifact cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public <T> T withFileLock(Factory<? extends T> action) {
        return (T)this.cache.withFileLock(action);
    }

    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    public <T> T useCache(Factory<? extends T> action) {
        return (T)this.cache.useCache(action);
    }

    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        PersistentIndexedCache persistentCache = this.cache.createCache(new PersistentIndexedCacheParameters(cacheFileInMetaDataStore, keySerializer, valueSerializer));
        return new CacheLockingPersistentCache(persistentCache);
    }

    private class CacheLockingPersistentCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private final PersistentIndexedCache<K, V> persistentCache;

        public CacheLockingPersistentCache(PersistentIndexedCache<K, V> persistentCache) {
            this.persistentCache = persistentCache;
        }

        @Nullable
        public V get(final K key) {
            return (V)DefaultCacheLockingManager.this.cache.useCache(new Factory<V>(){

                public V create() {
                    return CacheLockingPersistentCache.this.persistentCache.get(key);
                }
            });
        }

        public V get(final K key, final Transformer<? extends V, ? super K> producer) {
            return (V)DefaultCacheLockingManager.this.cache.useCache(new Factory<V>(){

                public V create() {
                    return CacheLockingPersistentCache.this.persistentCache.get(key, producer);
                }
            });
        }

        public void put(final K key, final V value) {
            DefaultCacheLockingManager.this.cache.useCache(new Runnable(){

                @Override
                public void run() {
                    CacheLockingPersistentCache.this.persistentCache.put(key, value);
                }
            });
        }

        public void remove(final K key) {
            DefaultCacheLockingManager.this.cache.useCache(new Runnable(){

                @Override
                public void run() {
                    CacheLockingPersistentCache.this.persistentCache.remove(key);
                }
            });
        }
    }
}

