/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderBin;
import javax.media.j3d.VirtualUniverse;

class AttributeBin
implements ObjectUpdate {
    RenderingAttributesRetained definingRenderingAttributes = null;
    RenderBin renderBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin next = null;
    AttributeBin prev = null;
    ShaderBin shaderBinList = null;
    ArrayList<ShaderBin> addShaderBins = new ArrayList();
    boolean soleUser = false;
    AppearanceRetained app = null;
    int onUpdateList = 0;
    static int ON_OBJ_UPDATE_LIST = 1;
    static int ON_CHANGED_FREQUENT_UPDATE_LIST = 2;
    boolean ignoreVertexColors = false;
    RenderingAttributesRetained renderingAttrs;
    int numEditingShaderBins = 0;

    AttributeBin(AppearanceRetained appearanceRetained, RenderingAttributesRetained renderingAttributesRetained, RenderBin renderBin) {
        this.reset(appearanceRetained, renderingAttributesRetained, renderBin);
    }

    void reset(AppearanceRetained appearanceRetained, RenderingAttributesRetained renderingAttributesRetained, RenderBin renderBin) {
        this.prev = null;
        this.next = null;
        this.shaderBinList = null;
        this.onUpdateList = 0;
        this.numEditingShaderBins = 0;
        this.renderingAttrs = renderingAttributesRetained;
        this.renderBin = renderBin;
        this.soleUser = false;
        if (VirtualUniverse.mc.allowSoleUser && appearanceRetained != null) {
            boolean bl = this.soleUser = (appearanceRetained.changedFrequent & 0x40) != 0;
        }
        if (this.soleUser) {
            this.app = appearanceRetained;
        } else {
            appearanceRetained = null;
        }
        if (renderingAttributesRetained != null) {
            if (renderingAttributesRetained.changedFrequent != 0) {
                this.definingRenderingAttributes = renderingAttributesRetained;
                if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) == 0) {
                    this.renderBin.aBinUpdateList.add(this);
                    this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
                }
            } else if (this.definingRenderingAttributes != null) {
                this.definingRenderingAttributes.set(renderingAttributesRetained);
            } else {
                this.definingRenderingAttributes = (RenderingAttributesRetained)renderingAttributesRetained.clone();
            }
            this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
        } else {
            this.definingRenderingAttributes = null;
            this.ignoreVertexColors = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean equals(RenderingAttributesRetained renderingAttributesRetained, RenderAtom renderAtom) {
        if (this.soleUser || renderAtom.geometryAtom.source.appearance != null && (renderAtom.geometryAtom.source.appearance.changedFrequent & 0x40) != 0) {
            if (this.app != renderAtom.geometryAtom.source.appearance) return false;
            if (this.numEditingShaderBins != 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes == null) {
            if (renderingAttributesRetained == null) return true;
            return false;
        }
        if (this.definingRenderingAttributes.changedFrequent != 0 || renderingAttributesRetained != null && renderingAttributesRetained.changedFrequent != 0) {
            if (this.definingRenderingAttributes != renderingAttributesRetained) return false;
            if (this.definingRenderingAttributes.compChanged == 0) return true;
            if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) return true;
            this.renderBin.aBinUpdateList.add(this);
            this.onUpdateList |= ON_CHANGED_FREQUENT_UPDATE_LIST;
            return true;
        }
        if (this.definingRenderingAttributes.equivalent(renderingAttributesRetained)) return true;
        return false;
    }

    public void updateObject() {
        int n = this.addShaderBins.size();
        if (n > 0) {
            ShaderBin shaderBin = this.addShaderBins.get(0);
            if (this.shaderBinList == null) {
                this.shaderBinList = shaderBin;
            } else {
                shaderBin.next = this.shaderBinList;
                this.shaderBinList.prev = shaderBin;
                this.shaderBinList = shaderBin;
            }
            for (int i = 1; i < n; ++i) {
                shaderBin = this.addShaderBins.get(i);
                shaderBin.next = this.shaderBinList;
                this.shaderBinList.prev = shaderBin;
                this.shaderBinList = shaderBin;
            }
        }
        this.addShaderBins.clear();
        this.onUpdateList &= ~ON_OBJ_UPDATE_LIST;
    }

    void addShaderBin(ShaderBin shaderBin, RenderBin renderBin, ShaderAppearanceRetained shaderAppearanceRetained) {
        shaderBin.attributeBin = this;
        if (shaderAppearanceRetained != null) {
            assert (shaderAppearanceRetained.isMirror);
            shaderBin.shaderProgram = shaderAppearanceRetained.shaderProgram;
            shaderBin.shaderAttributeSet = shaderAppearanceRetained.shaderAttributeSet;
        }
        shaderBin.shaderAppearance = shaderAppearanceRetained;
        this.addShaderBins.add(shaderBin);
        if ((this.onUpdateList & ON_OBJ_UPDATE_LIST) == 0) {
            this.onUpdateList |= ON_OBJ_UPDATE_LIST;
            renderBin.objUpdateList.add(this);
        }
    }

    void removeShaderBin(ShaderBin shaderBin) {
        if (this.addShaderBins.contains(shaderBin)) {
            this.addShaderBins.remove(this.addShaderBins.indexOf(shaderBin));
        } else if (shaderBin.prev == null) {
            this.shaderBinList = shaderBin.next;
            if (shaderBin.next != null) {
                shaderBin.next.prev = null;
            }
        } else {
            shaderBin.prev.next = shaderBin.next;
            if (shaderBin.next != null) {
                shaderBin.next.prev = shaderBin.prev;
            }
        }
        shaderBin.clear();
        if (this.shaderBinList == null && this.addShaderBins.size() == 0) {
            this.environmentSet.removeAttributeBin(this);
        }
    }

    void render(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = bl = this.definingRenderingAttributes == null || this.definingRenderingAttributes.visible;
        if (this.renderBin.view.viewCache.visibilityPolicy == 0 && !bl || this.renderBin.view.viewCache.visibilityPolicy == 1 && bl) {
            return;
        }
        canvas3D.setStateToUpdate(2, this);
        ShaderBin shaderBin = this.shaderBinList;
        while (shaderBin != null) {
            shaderBin.render(canvas3D);
            shaderBin = shaderBin.next;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        if ((canvas3D.canvasDirty & 0x200) != 0) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.renderingAttrs;
        } else if (canvas3D.renderingAttrs != this.renderingAttrs && canvas3D.attributeBin != this) {
            if (this.definingRenderingAttributes == null) {
                canvas3D.resetRenderingAttributes(canvas3D.ctx, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            } else {
                this.definingRenderingAttributes.updateNative(canvas3D, canvas3D.depthBufferWriteEnableOverride, canvas3D.depthBufferEnableOverride);
            }
            canvas3D.renderingAttrs = this.renderingAttrs;
        }
        canvas3D.attributeBin = this;
        canvas3D.canvasDirty &= 0xFFFFFDFF;
    }

    void updateNodeComponent() {
        if ((this.onUpdateList & ON_CHANGED_FREQUENT_UPDATE_LIST) != 0) {
            if (this.soleUser) {
                boolean bl = this.definingRenderingAttributes != null && this.definingRenderingAttributes != this.renderingAttrs;
                this.renderingAttrs = this.app.renderingAttributes;
                if (this.renderingAttrs == null) {
                    this.definingRenderingAttributes = null;
                    this.ignoreVertexColors = false;
                } else {
                    if (this.renderingAttrs.changedFrequent != 0) {
                        this.definingRenderingAttributes = this.renderingAttrs;
                    } else if (bl) {
                        this.definingRenderingAttributes.set(this.renderingAttrs);
                    } else {
                        this.definingRenderingAttributes = (RenderingAttributesRetained)this.renderingAttrs.clone();
                    }
                    this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
                }
            } else {
                this.ignoreVertexColors = this.definingRenderingAttributes.ignoreVertexColors;
            }
        }
        this.onUpdateList &= ~ON_CHANGED_FREQUENT_UPDATE_LIST;
    }

    void incrActiveShaderBin() {
        ++this.numEditingShaderBins;
    }

    void decrActiveShaderBin() {
        --this.numEditingShaderBins;
    }

    void updateFromShaderBin(RenderAtom renderAtom) {
        RenderingAttributesRetained renderingAttributesRetained;
        AppearanceRetained appearanceRetained = renderAtom.geometryAtom.source.appearance;
        RenderingAttributesRetained renderingAttributesRetained2 = renderingAttributesRetained = appearanceRetained == null ? null : appearanceRetained.renderingAttributes;
        if (!this.soleUser && this.renderingAttrs != renderingAttributesRetained) {
            this.renderingAttrs = this.definingRenderingAttributes;
        }
    }
}

