/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.deps.behavior.DEGTBehavior;
import net.adaptivebox.deps.behavior.PSGTBehavior;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.ILibEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;

public class DEPSAgent
implements ILibEngine {
    private ProblemEncoder problemEncoder;
    private IGoodnessCompareEngine qualityComparator;
    private SearchPoint trailPoint;
    private AbsGTBehavior selectGTBehavior;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;
    private SearchPoint pbest_t;
    private DEGTBehavior deGTBehavior;
    private PSGTBehavior psGTBehavior;
    public double switchP = 0.5;

    public void setLibrary(Library lib) {
        this.deGTBehavior.setLibrary(lib);
        this.psGTBehavior.setLibrary(lib);
    }

    public void setProblemEncoder(ProblemEncoder encoder) {
        this.problemEncoder = encoder;
        this.trailPoint = this.problemEncoder.getFreshSearchPoint();
        this.pold_t = this.problemEncoder.getFreshSearchPoint();
        this.pcurrent_t = this.problemEncoder.getFreshSearchPoint();
    }

    public void setSpecComparator(IGoodnessCompareEngine comparer) {
        this.qualityComparator = comparer;
    }

    public void setPbest(SearchPoint pbest) {
        this.pbest_t = pbest;
    }

    private AbsGTBehavior getGTBehavior() {
        if (Math.random() < this.switchP) {
            return this.deGTBehavior;
        }
        return this.psGTBehavior;
    }

    public void setGTBehavior(AbsGTBehavior gtBehavior) {
        if (gtBehavior instanceof DEGTBehavior) {
            this.deGTBehavior = (DEGTBehavior)gtBehavior;
            this.deGTBehavior.setPbest(this.pbest_t);
            return;
        }
        if (gtBehavior instanceof PSGTBehavior) {
            this.psGTBehavior = (PSGTBehavior)gtBehavior;
            this.psGTBehavior.setMemPoints(this.pbest_t, this.pcurrent_t, this.pold_t);
            return;
        }
    }

    public void generatePoint() {
        this.selectGTBehavior = this.getGTBehavior();
        this.selectGTBehavior.generateBehavior(this.trailPoint, this.problemEncoder);
        this.problemEncoder.evaluate(this.trailPoint);
    }

    public void learn() {
        this.selectGTBehavior.testBehavior(this.trailPoint, this.qualityComparator);
    }

    public SearchPoint getMGState() {
        return this.trailPoint;
    }
}

