/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.reflect.Type;

public abstract class VirtualBeanPropertyWriter
extends BeanPropertyWriter {
    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        this(propDef, contextAnnotations, declaredType, null, null, null, propDef.findInclusion());
    }

    protected VirtualBeanPropertyWriter() {
    }

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, JavaType serType, JsonInclude.Include inclusion) {
        super(propDef, propDef.getPrimaryMember(), contextAnnotations, declaredType, ser, typeSer, serType, VirtualBeanPropertyWriter._suppressNulls(inclusion), VirtualBeanPropertyWriter._suppressableValue(inclusion));
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base) {
        super(base);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter base, PropertyName name2) {
        super((BeanPropertyWriter)base, name2);
    }

    protected static boolean _suppressNulls(JsonInclude.Include inclusion) {
        return inclusion != JsonInclude.Include.ALWAYS;
    }

    protected static Object _suppressableValue(JsonInclude.Include inclusion) {
        if (inclusion == JsonInclude.Include.NON_EMPTY || inclusion == JsonInclude.Include.NON_EMPTY) {
            return MARKER_FOR_EMPTY;
        }
        return null;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public Class<?> getPropertyType() {
        return this._declaredType.getRawClass();
    }

    @Override
    public Type getGenericPropertyType() {
        return this.getPropertyType();
    }

    protected abstract Object value(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    public abstract VirtualBeanPropertyWriter withConfig(MapperConfig<?> var1, AnnotatedClass var2, BeanPropertyDefinition var3, JavaType var4);

    @Override
    public void serializeAsField(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        Object value = this.value(bean2, gen2, prov);
        if (value == null) {
            if (this._nullSerializer != null) {
                gen2.writeFieldName(this._name);
                this._nullSerializer.serialize(null, gen2, prov);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean2 && this._handleSelfReference(bean2, gen2, prov, ser)) {
            return;
        }
        gen2.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, gen2, prov);
        } else {
            ser.serializeWithType(value, gen2, prov, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsElement(Object bean2, JsonGenerator gen2, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map2;
        Object value = this.value(bean2, gen2, prov);
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, gen2, prov);
            } else {
                gen2.writeNull();
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map2 = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map2, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(prov, value)) {
                    this.serializeAsPlaceholder(bean2, gen2, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean2, gen2, prov);
                return;
            }
        }
        if (value == bean2 && this._handleSelfReference(bean2, gen2, prov, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, gen2, prov);
        } else {
            ser.serializeWithType(value, gen2, prov, this._typeSerializer);
        }
    }
}

