/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;

public class Nation
extends FreeColGameObjectType {
    public static final String UNKNOWN_NATION_ID = "model.nation.unknownEnemy";
    public static final Color UNKNOWN_NATION_COLOR = Color.BLACK;
    private static final Map<String, Color> defaultColors = new HashMap<String, Color>();
    private static final List<String> EUROPEAN_NATIONS;
    private NationType type;
    private boolean selectable;
    private Nation refNation;
    private int preferredLatitude = 0;
    private boolean startsOnEastCoast = true;
    private Color color;
    private static final String COLOR_TAG = "color";
    private static final String NATION_TYPE_TAG = "nation-type";
    private static final String PREFERRED_LATITUDE_TAG = "preferred-latitude";
    private static final String REF_TAG = "ref";
    private static final String SELECTABLE_TAG = "selectable";
    private static final String STARTS_ON_EAST_COAST_TAG = "starts-on-east-coast";
    private static final String OLD_PREFERRED_LATITUDE_TAG = "preferredLatitude";
    private static final String OLD_STARTS_ON_EAST_COAST_TAG = "startsOnEastCoast";

    public Nation(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean isUnknownEnemy() {
        return UNKNOWN_NATION_ID.equals(this.getId());
    }

    public final NationType getType() {
        return this.type;
    }

    public final void setType(NationType type) {
        this.type = type;
    }

    public final boolean isSelectable() {
        return this.selectable;
    }

    public final Nation getREFNation() {
        return this.refNation;
    }

    public final Nation getRebelNation() {
        return CollectionUtils.find(this.getSpecification().getEuropeanNations(), n -> n.getREFNation() == this);
    }

    public final int getPreferredLatitude() {
        return this.preferredLatitude;
    }

    public final boolean startsOnEastCoast() {
        return this.startsOnEastCoast;
    }

    public final String getRulerNameKey() {
        return Messages.rulerKey(this.getId());
    }

    public String getRulerName() {
        return Messages.message(this.getRulerNameKey());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color forceDefaultColor() {
        Color ret = defaultColors.get(this.getId());
        this.setColor(ret);
        return ret;
    }

    public static String getRandomNonPlayerNationNameKey(Game game, Random random) {
        int nations = EUROPEAN_NATIONS.size();
        int start = RandomUtils.randomInt(logger, "Random nation", random, nations);
        for (int index = 0; index < nations; ++index) {
            String nationId = "model.nation." + EUROPEAN_NATIONS.get((start + index) % nations);
            if (game.getPlayerByNationId(nationId) != null) continue;
            return Messages.nameKey(nationId);
        }
        return "";
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NATION_TYPE_TAG, this.type);
        xw.writeAttribute(SELECTABLE_TAG, this.selectable);
        xw.writeAttribute(PREFERRED_LATITUDE_TAG, this.preferredLatitude);
        xw.writeAttribute(STARTS_ON_EAST_COAST_TAG, this.startsOnEastCoast);
        if (this.refNation != null) {
            xw.writeAttribute(REF_TAG, this.refNation);
        }
        if (this.color != null) {
            xw.writeAttribute(COLOR_TAG, this.color.getRGB());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.type = xr.getType(spec, NATION_TYPE_TAG, NationType.class, null);
        this.selectable = xr.getAttribute(SELECTABLE_TAG, false);
        this.preferredLatitude = xr.hasAttribute(OLD_PREFERRED_LATITUDE_TAG) ? xr.getAttribute(OLD_PREFERRED_LATITUDE_TAG, 0) : xr.getAttribute(PREFERRED_LATITUDE_TAG, 0);
        this.startsOnEastCoast = xr.hasAttribute(OLD_STARTS_ON_EAST_COAST_TAG) ? xr.getAttribute(OLD_STARTS_ON_EAST_COAST_TAG, true) : xr.getAttribute(STARTS_ON_EAST_COAST_TAG, true);
        this.refNation = xr.getType(spec, REF_TAG, Nation.class, null);
        int rgb = xr.getAttribute(COLOR_TAG, Integer.MIN_VALUE);
        if (rgb != Integer.MIN_VALUE) {
            this.setColor(new Color(rgb));
        }
    }

    @Override
    public String getXMLTagName() {
        return Nation.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "nation";
    }

    static {
        defaultColors.put("model.nation.dutch", new Color(16751932));
        defaultColors.put("model.nation.french", new Color(255));
        defaultColors.put("model.nation.english", new Color(0xFF0000));
        defaultColors.put("model.nation.spanish", new Color(0xFFFF00));
        defaultColors.put("model.nation.inca", new Color(16052420));
        defaultColors.put("model.nation.aztec", new Color(12886048));
        defaultColors.put("model.nation.arawak", new Color(6850752));
        defaultColors.put("model.nation.cherokee", new Color(7093272));
        defaultColors.put("model.nation.iroquois", new Color(7644236));
        defaultColors.put("model.nation.sioux", new Color(12627076));
        defaultColors.put("model.nation.apache", new Color(0x900000));
        defaultColors.put("model.nation.tupi", new Color(285700));
        defaultColors.put("model.nation.dutchREF", new Color(0xCC5500));
        defaultColors.put("model.nation.frenchREF", new Color(6312156));
        defaultColors.put("model.nation.englishREF", new Color(14561635));
        defaultColors.put("model.nation.spanishREF", new Color(0xFFDF00));
        defaultColors.put("model.nation.portuguese", new Color(65280));
        defaultColors.put("model.nation.swedish", new Color(49151));
        defaultColors.put("model.nation.danish", new Color(0xFF00BF));
        defaultColors.put("model.nation.russian", new Color(0xFFFFFF));
        defaultColors.put("model.nation.portugueseREF", new Color(0xBFFF00));
        defaultColors.put("model.nation.swedishREF", new Color(3569032));
        defaultColors.put("model.nation.danishREF", new Color(9502829));
        defaultColors.put("model.nation.russianREF", new Color(0xBEBEBE));
        defaultColors.put(UNKNOWN_NATION_ID, UNKNOWN_NATION_COLOR);
        EUROPEAN_NATIONS = CollectionUtils.makeUnmodifiableList("dutch", "english", "french", "spanish", "danish", "portuguese", "swedish", "russian", "austrian", "german", "prussian", "turkish");
    }
}

