/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassSetAnalysisUpdater;
import org.gradle.api.internal.tasks.compile.incremental.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalAnnotationProcessingCompiler;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalResultStoringDecorator;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.SelectiveCompiler;
import org.gradle.api.internal.tasks.compile.incremental.cache.CompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotMaker;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.TextUtil;

public class IncrementalCompilerDecorator {
    private static final Logger LOG = Logging.getLogger(IncrementalCompilerDecorator.class);
    private final JarClasspathSnapshotMaker jarClasspathSnapshotMaker;
    private final CompileCaches compileCaches;
    private final CleaningJavaCompiler cleaningCompiler;
    private final String displayName;
    private final RecompilationSpecProvider staleClassDetecter;
    private final ClassSetAnalysisUpdater classSetAnalysisUpdater;
    private final CompilationSourceDirs sourceDirs;
    private final FileCollection annotationProcessorPath;
    private final AnnotationProcessorDetector annotationProcessorDetector;
    private final IncrementalCompilationInitializer compilationInitializer;

    public IncrementalCompilerDecorator(JarClasspathSnapshotMaker jarClasspathSnapshotMaker, CompileCaches compileCaches, IncrementalCompilationInitializer compilationInitializer, CleaningJavaCompiler cleaningCompiler, String displayName, RecompilationSpecProvider staleClassDetecter, ClassSetAnalysisUpdater classSetAnalysisUpdater, CompilationSourceDirs sourceDirs, FileCollection annotationProcessorPath, AnnotationProcessorDetector annotationProcessorDetector) {
        this.jarClasspathSnapshotMaker = jarClasspathSnapshotMaker;
        this.compileCaches = compileCaches;
        this.compilationInitializer = compilationInitializer;
        this.cleaningCompiler = cleaningCompiler;
        this.displayName = displayName;
        this.staleClassDetecter = staleClassDetecter;
        this.classSetAnalysisUpdater = classSetAnalysisUpdater;
        this.sourceDirs = sourceDirs;
        this.annotationProcessorPath = annotationProcessorPath;
        this.annotationProcessorDetector = annotationProcessorDetector;
    }

    public Compiler<JavaCompileSpec> prepareCompiler(IncrementalTaskInputs inputs) {
        Compiler<JavaCompileSpec> compiler = this.getCompiler(inputs, this.sourceDirs);
        IncrementalResultStoringDecorator compilationFinalizer = new IncrementalResultStoringDecorator(compiler, this.jarClasspathSnapshotMaker, this.classSetAnalysisUpdater, this.compileCaches.getAnnotationProcessorPathStore());
        return new IncrementalAnnotationProcessingCompiler(compilationFinalizer, this.annotationProcessorDetector);
    }

    private Compiler<JavaCompileSpec> getCompiler(IncrementalTaskInputs inputs, CompilationSourceDirs sourceDirs) {
        if (!inputs.isIncremental()) {
            LOG.info("{} - is not incremental (e.g. outputs have changed, no previous execution, etc.).", (Object)this.displayName);
            return this.cleaningCompiler;
        }
        if (!sourceDirs.canInferSourceRoots()) {
            LOG.info("{} - is not incremental. Unable to infer the source directories.", (Object)this.displayName);
            return this.cleaningCompiler;
        }
        List<AnnotationProcessorDeclaration> nonIncrementalProcessors = this.getNonIncrementalProcessors();
        if (!nonIncrementalProcessors.isEmpty()) {
            this.warnAboutNonIncrementalProcessors(nonIncrementalProcessors);
            return this.cleaningCompiler;
        }
        ClassSetAnalysisData data = this.compileCaches.getLocalClassSetAnalysisStore().get();
        if (data == null) {
            LOG.info("{} - is not incremental. No class analysis data available from the previous build.", (Object)this.displayName);
            return this.cleaningCompiler;
        }
        PreviousCompilation previousCompilation = new PreviousCompilation(new ClassSetAnalysis(data), this.compileCaches.getLocalJarClasspathSnapshotStore(), this.compileCaches.getJarSnapshotCache(), this.compileCaches.getAnnotationProcessorPathStore());
        return new SelectiveCompiler(inputs, previousCompilation, this.cleaningCompiler, this.staleClassDetecter, this.compilationInitializer, this.jarClasspathSnapshotMaker);
    }

    private List<AnnotationProcessorDeclaration> getNonIncrementalProcessors() {
        Map<String, AnnotationProcessorDeclaration> allProcessors = this.annotationProcessorDetector.detectProcessors((Iterable<File>)this.annotationProcessorPath);
        ArrayList nonIncrementalProcessors = Lists.newArrayListWithCapacity((int)allProcessors.size());
        for (AnnotationProcessorDeclaration processor : allProcessors.values()) {
            if (processor.getType().isIncremental()) continue;
            nonIncrementalProcessors.add(processor);
        }
        return nonIncrementalProcessors;
    }

    private void warnAboutNonIncrementalProcessors(List<AnnotationProcessorDeclaration> nonIncrementalProcessors) {
        if (LOG.isInfoEnabled()) {
            StringBuilder processorListing = new StringBuilder();
            for (AnnotationProcessorDeclaration processor : nonIncrementalProcessors) {
                processorListing.append(TextUtil.getPlatformLineSeparator()).append('\t').append(processor);
            }
            LOG.info("{} - is not incremental. The following annotation processors don't support incremental compilation:{}", (Object)this.displayName, (Object)processorListing);
        }
    }
}

