/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 393216;
    private static final MethodVisitor EMPTY_VISITOR = new MethodVisitor(393216, null){};
    private final LocalVariableVisitor localVariableVisitor;
    private final IntSet constants;
    private final Set<String> superTypes;
    private final Set<String> types;
    private final Predicate<String> typeFilter;
    private boolean isAnnotationType;
    private boolean dependencyToAll;

    public ClassDependenciesVisitor(IntSet constantsCollector) {
        this(constantsCollector, null, null, null);
    }

    private ClassDependenciesVisitor(IntSet constantsCollector, Set<String> types, Predicate<String> typeFilter, ClassReader reader) {
        super(393216);
        this.constants = constantsCollector;
        this.types = types;
        this.superTypes = types == null ? null : Sets.newHashSet();
        this.localVariableVisitor = types == null ? null : new LocalVariableVisitor();
        this.typeFilter = typeFilter;
        if (reader != null) {
            this.collectClassDependencies(reader);
        }
    }

    public static ClassAnalysis analyze(String className, ClassReader reader) {
        IntOpenHashSet constants = new IntOpenHashSet(2);
        HashSet classDependencies = Sets.newHashSet();
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor((IntSet)constants, classDependencies, new ClassRelevancyFilter(className), reader);
        reader.accept((ClassVisitor)visitor, 6);
        return new ClassAnalysis(className, classDependencies, visitor.isDependencyToAll(), (IntSet)constants, visitor.getSuperTypes());
    }

    public static IntSet retrieveConstants(ClassReader reader) {
        IntOpenHashSet constants = new IntOpenHashSet(2);
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor((IntSet)constants);
        reader.accept((ClassVisitor)visitor, 6);
        return constants;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotationType = this.isAnnotationType(interfaces);
        if (superName != null) {
            String type = this.typeOfFromSlashyString(superName);
            this.maybeAddSuperType(type);
            this.maybeAddDependentType(type);
        }
        for (String s : interfaces) {
            String interfaceType = this.typeOfFromSlashyString(s);
            this.maybeAddDependentType(interfaceType);
            this.maybeAddSuperType(interfaceType);
        }
    }

    private void collectClassDependencies(ClassReader reader) {
        char[] charBuffer = new char[reader.getMaxStringLength()];
        for (int i = 1; i < reader.getItemCount(); ++i) {
            int itemOffset = reader.getItem(i);
            if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) continue;
            String name = type.getClassName();
            this.maybeAddDependentType(name);
        }
    }

    protected void maybeAddSuperType(String type) {
        if (this.superTypes != null && this.typeFilter.apply((Object)type)) {
            this.superTypes.add(type);
        }
    }

    protected void maybeAddDependentType(String type) {
        if (this.types != null && this.typeFilter.apply((Object)type)) {
            this.types.add(type);
        }
    }

    protected String typeOfFromSlashyString(String slashyStyleDesc) {
        return Type.getObjectType((String)slashyStyleDesc).getClassName();
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.maybeAddDependentType(this.descTypeOf(desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value) && this.constants != null) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return null;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && !ClassDependenciesVisitor.isPrivate(access) && value != null;
    }

    protected String descTypeOf(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 9 && type.getDimensions() > 0) {
            type = type.getElementType();
        }
        return type.getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(methodType.getReturnType().getClassName());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(argType.getClassName());
        }
        return this.localVariableVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return new RetentionPolicyAnalyzer();
        }
        return null;
    }

    private static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }

    private class RetentionPolicyAnalyzer
    extends AnnotationVisitor {
        public RetentionPolicyAnalyzer() {
            super(393216);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAll = true;
            }
        }
    }

    private class LocalVariableVisitor
    extends InstructionAdapter {
        protected LocalVariableVisitor() {
            super(393216, EMPTY_VISITOR);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.descTypeOf(desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }
}

