/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.component;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.initialization.BuildIdentity;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;

public class DefaultComponentIdentifierFactory
implements ComponentIdentifierFactory {
    private final BuildIdentity buildIdentity;

    public DefaultComponentIdentifierFactory(BuildIdentity buildIdentity) {
        this.buildIdentity = buildIdentity;
    }

    @Override
    public ComponentIdentifier createComponentIdentifier(Module module) {
        String projectPath = module.getProjectPath();
        if (projectPath != null) {
            return new DefaultProjectComponentIdentifier(this.buildIdentity.getCurrentBuild(), projectPath);
        }
        return new DefaultModuleComponentIdentifier(module.getGroup(), module.getName(), module.getVersion());
    }

    @Override
    public ProjectComponentSelector createProjectComponentSelector(String projectPath) {
        return DefaultProjectComponentSelector.newSelector(this.buildIdentity.getCurrentBuild(), projectPath);
    }

    @Override
    public ProjectComponentIdentifier createProjectComponentIdentifier(ProjectComponentSelector selector) {
        BuildIdentifier currentBuild = this.buildIdentity.getCurrentBuild();
        if (selector.getBuildName().equals(currentBuild.getName())) {
            return new DefaultProjectComponentIdentifier(currentBuild, selector.getProjectPath());
        }
        return new DefaultProjectComponentIdentifier((BuildIdentifier)new DefaultBuildIdentifier(selector.getBuildName()), selector.getProjectPath());
    }
}

