/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.RelativePathSpec;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSpecFactory {
    public static final PatternSpecFactory INSTANCE = new PatternSpecFactory();
    private final List<String> previousDefaultExcludes = Lists.newArrayList();
    private final Map<Boolean, Spec<FileTreeElement>> defaultExcludeSpecs = new HashMap<Boolean, Spec<FileTreeElement>>(2);

    public Spec<FileTreeElement> createSpec(PatternSet patternSet) {
        return Specs.intersect((Spec[])new Spec[]{this.createIncludeSpec(patternSet), Specs.negate(this.createExcludeSpec(patternSet))});
    }

    public Spec<FileTreeElement> createIncludeSpec(PatternSet patternSet) {
        ArrayList<Spec<FileTreeElement>> allIncludeSpecs = new ArrayList<Spec<FileTreeElement>>(1 + patternSet.getIncludeSpecs().size());
        if (!patternSet.getIncludes().isEmpty()) {
            allIncludeSpecs.add(this.createSpec(patternSet.getIncludes(), true, patternSet.isCaseSensitive()));
        }
        allIncludeSpecs.addAll(patternSet.getIncludeSpecs());
        return Specs.union(allIncludeSpecs);
    }

    public Spec<FileTreeElement> createExcludeSpec(PatternSet patternSet) {
        ArrayList<Spec<FileTreeElement>> allExcludeSpecs = new ArrayList<Spec<FileTreeElement>>(2 + patternSet.getExcludeSpecs().size());
        if (!patternSet.getExcludes().isEmpty()) {
            allExcludeSpecs.add(this.createSpec(patternSet.getExcludes(), false, patternSet.isCaseSensitive()));
        }
        allExcludeSpecs.add(this.getDefaultExcludeSpec(patternSet.isCaseSensitive()));
        allExcludeSpecs.addAll(patternSet.getExcludeSpecs());
        if (allExcludeSpecs.isEmpty()) {
            return Specs.satisfyNone();
        }
        return Specs.union(allExcludeSpecs);
    }

    private synchronized Spec<FileTreeElement> getDefaultExcludeSpec(boolean caseSensitive) {
        Spec<FileTreeElement> specs = this.defaultExcludeSpecs.get(caseSensitive);
        List<String> defaultExcludes = Arrays.asList(DirectoryScanner.getDefaultExcludes());
        if (specs == null) {
            specs = this.updateDefaultExcludeCache(defaultExcludes, caseSensitive);
        } else if (!this.previousDefaultExcludes.equals(defaultExcludes)) {
            specs = this.updateDefaultExcludeCache(defaultExcludes, caseSensitive);
        }
        return specs;
    }

    private Spec<FileTreeElement> updateDefaultExcludeCache(List<String> defaultExcludes, boolean caseSensitive) {
        this.previousDefaultExcludes.clear();
        this.previousDefaultExcludes.addAll(defaultExcludes);
        this.defaultExcludeSpecs.put(caseSensitive, this.createSpec(defaultExcludes, false, true));
        this.defaultExcludeSpecs.put(caseSensitive, this.createSpec(defaultExcludes, false, false));
        return this.defaultExcludeSpecs.get(caseSensitive);
    }

    protected Spec<FileTreeElement> createSpec(Collection<String> patterns, boolean include, boolean caseSensitive) {
        if (patterns.isEmpty()) {
            return include ? Specs.satisfyAll() : Specs.satisfyNone();
        }
        ArrayList<Spec<RelativePath>> matchers = new ArrayList<Spec<RelativePath>>(patterns.size());
        for (String pattern : patterns) {
            Spec<RelativePath> patternMatcher = PatternMatcherFactory.getPatternMatcher(include, caseSensitive, pattern);
            matchers.add(patternMatcher);
        }
        return new RelativePathSpec((Spec<? super RelativePath>)Specs.union(matchers));
    }
}

