/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmPropertyDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.descriptors.UtilKt;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$WhenMappings;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolDeclaration;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "unsubstitutedArrayOfFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createArrayOfExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arrayElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "arrayElements", "", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "EnumConstructorCallTransformer", "backend"})
public final class EnumClassLowering
implements ClassLoweringPass {
    private final FunctionDescriptor unsubstitutedArrayOfFun;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        ClassDescriptor classDescriptor = irClass.getDescriptor();
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        new EnumClassTransformer(irClass).run();
    }

    private final IrExpression createArrayOfExpression(KotlinType arrayElementType, List<? extends IrExpression> arrayElements) {
        IrCallImpl irCallImpl;
        ValueParameterDescriptor valueParameter0;
        TypeParameterDescriptor typeParameter0;
        TypeParameterDescriptor typeParameterDescriptor = typeParameter0 = this.unsubstitutedArrayOfFun.getTypeParameters().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter0");
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameterDescriptor.getTypeConstructor(), (Object)new TypeProjectionImpl(arrayElementType))));
        FunctionDescriptor functionDescriptor = this.unsubstitutedArrayOfFun.substitute(typeSubstitutor2);
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        FunctionDescriptor substitutedArrayOfFun = functionDescriptor;
        Map typeArguments2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameter0, (Object)arrayElementType));
        FunctionDescriptor functionDescriptor2 = substitutedArrayOfFun;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"substitutedArrayOfFun");
        ValueParameterDescriptor valueParameterDescriptor = valueParameter0 = functionDescriptor2.getValueParameters().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueParameter0");
        KotlinType arg0VarargType = valueParameterDescriptor.getType();
        KotlinType kotlinType = valueParameter0.getVarargElementType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType arg0VarargElementType = kotlinType;
        KotlinType kotlinType2 = arg0VarargType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"arg0VarargType");
        IrVarargImpl arg0 = new IrVarargImpl(-1, -1, kotlinType2, arg0VarargElementType, arrayElements);
        IrCallImpl $receiver = irCallImpl = new IrCallImpl(-1, -1, substitutedArrayOfFun, typeArguments2, null, null, 48, null);
        $receiver.putValueArgument(0, arg0);
        return irCallImpl;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public EnumClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        KotlinBuiltIns kotlinBuiltIns = this.context.getBuiltIns();
        Name name = Name.identifier("arrayOf");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"arrayOf\")");
        this.unsubstitutedArrayOfFun = KotlinUtilsKt.findSingleFunction(kotlinBuiltIns, name);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend"})
    private static interface EnumConstructorCallTransformer {
        @NotNull
        public IrExpression transform(@NotNull IrEnumConstructorCall var1);

        @NotNull
        public IrExpression transform(@NotNull IrDelegatingConstructorCall var1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0005789:;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0010H\u0002J\b\u0010+\u001a\u00020\u0018H\u0002J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010/\u001a\u00020\u0018H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010\u00032\b\u00101\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u00102\u001a\u00020\u0018J\b\u00103\u001a\u00020\u0018H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "enumEntriesByField", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "enumEntryFields", "Ljava/util/ArrayList;", "enumEntryOrdinals", "Lorg/jetbrains/kotlin/gnu/trove/TObjectIntHashMap;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "loweredEnumConstructorParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "valueOfFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "valuesFieldDescriptor", "valuesFunctionDescriptor", "assignOrdinalsToEnumEntries", "", "createFieldForEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "createSyntheticValuesFieldDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFieldImpl;", "createSyntheticValuesFieldDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "valuesArrayType", "Lorg/jetbrains/kotlin/types/SimpleType;", "createSyntheticValuesFieldInitializerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "findFunctionDescriptorForMemberWithSyntheticBodyKind", "kind", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBodyKind;", "lowerConstructorValueParameter", "loweredConstructorDescriptor", "valueParameterDescriptor", "lowerEnumClassBody", "lowerEnumConstructor", "constructorDescriptor", "lowerEnumConstructors", "lowerEnumEntries", "lowerEnumEntryClass", "enumEntryClass", "run", "setupSynthesizedEnumClassMembers", "transformEnumConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "enumConstructor", "EnumClassBodyTransformer", "InEnumClassConstructor", "InEnumEntry", "InEnumEntryClassConstructor", "InEnumEntryInitializer", "backend"})
    private final class EnumClassTransformer {
        private final TObjectIntHashMap<ClassDescriptor> enumEntryOrdinals;
        private final HashMap<ClassConstructorDescriptor, ClassConstructorDescriptor> loweredEnumConstructors;
        private final HashMap<ValueParameterDescriptor, ValueParameterDescriptor> loweredEnumConstructorParameters;
        private final HashMap<PropertyDescriptor, ClassDescriptor> enumEntriesByField;
        private final ArrayList<PropertyDescriptor> enumEntryFields;
        private PropertyDescriptor valuesFieldDescriptor;
        private FunctionDescriptor valuesFunctionDescriptor;
        private FunctionDescriptor valueOfFunctionDescriptor;
        @NotNull
        private final IrClass irClass;

        public final void run() {
            this.assignOrdinalsToEnumEntries();
            this.lowerEnumConstructors(this.irClass);
            this.lowerEnumEntries();
            this.setupSynthesizedEnumClassMembers();
            this.lowerEnumClassBody();
        }

        private final void assignOrdinalsToEnumEntries() {
            int ordinal = 0;
            Iterable $receiver$iv = this.irClass.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                if (!(it instanceof IrEnumEntry)) continue;
                this.enumEntryOrdinals.put(((IrEnumEntry)it).getDescriptor(), ordinal);
                int n = ordinal;
                ordinal = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void lowerEnumConstructors(IrClass irClass) {
            List<IrDeclaration> $receiver$iv = irClass.getDeclarations();
            Iterable $receiver$iv$iv = $receiver$iv;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void declaration;
                IrElement irElement;
                void item$iv;
                int n = index$iv$iv++;
                IrElement irElement2 = (IrElement)item$iv$iv;
                int i$iv = n;
                IrDeclaration irDeclaration = (IrDeclaration)item$iv;
                int n2 = i$iv;
                List<IrDeclaration> list2 = $receiver$iv;
                IrElement irElement3 = irElement = declaration instanceof IrConstructor ? (IrElement)this.transformEnumConstructor((IrConstructor)declaration) : (IrElement)declaration;
                if (irElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                list2.set(n2, (IrDeclaration)irElement3);
            }
        }

        private final IrConstructor transformEnumConstructor(IrConstructor enumConstructor) {
            ClassConstructorDescriptor constructorDescriptor = enumConstructor.getDescriptor();
            ClassConstructorDescriptor loweredConstructorDescriptor = this.lowerEnumConstructor(constructorDescriptor);
            int n = enumConstructor.getStartOffset();
            int n2 = enumConstructor.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = enumConstructor.getOrigin();
            IrBody irBody = enumConstructor.getBody();
            if (irBody == null) {
                Intrinsics.throwNpe();
            }
            return new IrConstructorImpl(n, n2, irDeclarationOrigin, loweredConstructorDescriptor, irBody);
        }

        /*
         * WARNING - void declaration
         */
        private final ClassConstructorDescriptor lowerEnumConstructor(ClassConstructorDescriptor constructorDescriptor) {
            Collection<ValueParameterDescriptor> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            ClassConstructorDescriptorImpl loweredConstructorDescriptor = ClassConstructorDescriptorImpl.createSynthesized(constructorDescriptor.getContainingDeclaration(), constructorDescriptor.getAnnotations(), constructorDescriptor.isPrimary(), constructorDescriptor.getSource());
            Object[] objectArray = new ValueParameterDescriptor[2];
            ClassConstructorDescriptorImpl classConstructorDescriptorImpl = loweredConstructorDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptorImpl, (String)"loweredConstructorDescriptor");
            CallableMemberDescriptor callableMemberDescriptor = classConstructorDescriptorImpl;
            SimpleType simpleType2 = EnumClassLowering.this.getContext().getBuiltIns().getStringType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.stringType");
            objectArray[0] = UtilKt.createValueParameter(callableMemberDescriptor, 0, "name", simpleType2);
            CallableMemberDescriptor callableMemberDescriptor2 = loweredConstructorDescriptor;
            SimpleType simpleType3 = EnumClassLowering.this.getContext().getBuiltIns().getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"context.builtIns.intType");
            objectArray[1] = UtilKt.createValueParameter(callableMemberDescriptor2, 1, "ordinal", simpleType3);
            Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
            List<ValueParameterDescriptor> list2 = constructorDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constructorDescriptor.valueParameters");
            Object object = list2;
            Collection collection3 = collection2;
            ClassConstructorDescriptorImpl classConstructorDescriptorImpl2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                ClassConstructorDescriptor classConstructorDescriptor = loweredConstructorDescriptor;
                void v9 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                ValueParameterDescriptor valueParameterDescriptor2 = this.lowerConstructorValueParameter(classConstructorDescriptor, (ValueParameterDescriptor)v9);
                collection.add(valueParameterDescriptor2);
            }
            collection = (List)destination$iv$iv;
            List valueParameters = CollectionsKt.plus((Collection)collection3, (Iterable)collection);
            loweredConstructorDescriptor.initialize(valueParameters, Visibilities.PROTECTED);
            loweredConstructorDescriptor.setReturnType(constructorDescriptor.getReturnType());
            object = this.loweredEnumConstructors;
            classConstructorDescriptorImpl2 = loweredConstructorDescriptor;
            object.put(constructorDescriptor, classConstructorDescriptorImpl2);
            return loweredConstructorDescriptor;
        }

        private final ValueParameterDescriptor lowerConstructorValueParameter(ClassConstructorDescriptor loweredConstructorDescriptor, ValueParameterDescriptor valueParameterDescriptor) {
            CallableDescriptor callableDescriptor = loweredConstructorDescriptor;
            Name name = valueParameterDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"valueParameterDescriptor.name");
            ValueParameterDescriptor loweredValueParameterDescriptor = valueParameterDescriptor.copy(callableDescriptor, name, valueParameterDescriptor.getIndex() + 2);
            Map map2 = this.loweredEnumConstructorParameters;
            ValueParameterDescriptor valueParameterDescriptor2 = loweredValueParameterDescriptor;
            map2.put(valueParameterDescriptor, valueParameterDescriptor2);
            return loweredValueParameterDescriptor;
        }

        private final void lowerEnumEntries() {
            List<IrDeclaration> $receiver$iv = this.irClass.getDeclarations();
            int i$iv = 0;
            while (i$iv < $receiver$iv.size()) {
                List transformed$iv;
                IrDeclaration item$iv = $receiver$iv.get(i$iv);
                IrDeclaration declaration = item$iv;
                List list2 = transformed$iv = declaration instanceof IrEnumEntry ? CollectionsKt.listOfNotNull((Object[])new IrSymbolDeclaration[]{this.createFieldForEnumEntry((IrEnumEntry)declaration), this.lowerEnumEntryClass(((IrEnumEntry)declaration).getCorrespondingClass())}) : null;
                if (transformed$iv == null) {
                    ++i$iv;
                    continue;
                }
                $receiver$iv.addAll(i$iv, transformed$iv);
                $receiver$iv.remove(i$iv += transformed$iv.size());
            }
        }

        private final IrClass lowerEnumEntryClass(IrClass enumEntryClass) {
            if (enumEntryClass == null) {
                return null;
            }
            this.lowerEnumConstructors(enumEntryClass);
            return enumEntryClass;
        }

        private final IrField createFieldForEnumEntry(IrEnumEntry enumEntry) {
            PropertyDescriptor fieldPropertyDescriptor = EnumClassLowering.this.getContext().getSpecialDescriptorsFactory().getFieldDescriptorForEnumEntry(enumEntry.getDescriptor());
            Map map2 = this.enumEntriesByField;
            ClassDescriptor classDescriptor = enumEntry.getDescriptor();
            map2.put(fieldPropertyDescriptor, classDescriptor);
            this.enumEntryFields.add(fieldPropertyDescriptor);
            IrExpression irExpression = enumEntry.getInitializerExpression();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            IrExpression enumEntryInitializer = irExpression;
            return new IrFieldImpl(enumEntry.getStartOffset(), enumEntry.getEndOffset(), JvmLoweredDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE, fieldPropertyDescriptor, new IrExpressionBodyImpl(enumEntryInitializer));
        }

        private final void setupSynthesizedEnumClassMembers() {
            IrFieldImpl irField = this.createSyntheticValuesFieldDeclaration();
            this.irClass.getDeclarations().add(irField);
            this.valuesFunctionDescriptor = this.findFunctionDescriptorForMemberWithSyntheticBodyKind(IrSyntheticBodyKind.ENUM_VALUES);
            this.valueOfFunctionDescriptor = this.findFunctionDescriptorForMemberWithSyntheticBodyKind(IrSyntheticBodyKind.ENUM_VALUEOF);
        }

        private final FunctionDescriptor findFunctionDescriptorForMemberWithSyntheticBodyKind(IrSyntheticBodyKind kind) {
            Object element$iv2;
            block2: {
                Iterable $receiver$iv = this.irClass.getDeclarations();
                for (Object element$iv2 : $receiver$iv) {
                    IrBody irBody;
                    IrBody body;
                    IrDeclaration it = (IrDeclaration)element$iv2;
                    if (!(it instanceof IrFunction && (body = (irBody = ((IrFunction)it).getBody())) instanceof IrSyntheticBody && ((IrSyntheticBody)body).getKind() == kind)) continue;
                    break block2;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            DeclarationDescriptor declarationDescriptor = ((IrDeclaration)element$iv2).getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            return (FunctionDescriptor)declarationDescriptor;
        }

        private final IrFieldImpl createSyntheticValuesFieldDeclaration() {
            SimpleType valuesArrayType;
            SimpleType simpleType2 = valuesArrayType = EnumClassLowering.this.getContext().getBuiltIns().getArrayType(Variance.INVARIANT, this.irClass.getDescriptor().getDefaultType());
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"valuesArrayType");
            this.valuesFieldDescriptor = this.createSyntheticValuesFieldDescriptor(simpleType2);
            IrExpression irValuesInitializer = this.createSyntheticValuesFieldInitializerExpression();
            IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE;
            PropertyDescriptor propertyDescriptor = this.valuesFieldDescriptor;
            if (propertyDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valuesFieldDescriptor");
            }
            return new IrFieldImpl(-1, -1, irDeclarationOrigin, propertyDescriptor, new IrExpressionBodyImpl(-1, -1, irValuesInitializer));
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression createSyntheticValuesFieldInitializerExpression() {
            void var3_5;
            Collection<IrGetFieldImpl> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            SimpleType simpleType2 = this.irClass.getDescriptor().getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"irClass.descriptor.defaultType");
            Iterable iterable = this.enumEntryFields;
            KotlinType kotlinType = simpleType2;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            void var2_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void fieldDescriptor;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                IrGetFieldImpl irGetFieldImpl = new IrGetFieldImpl(-1, -1, (PropertyDescriptor)fieldDescriptor, null, null, 24, null);
                collection.add(irGetFieldImpl);
            }
            collection = (List)var3_5;
            return enumClassLowering.createArrayOfExpression(kotlinType, (List)collection);
        }

        private final PropertyDescriptorImpl createSyntheticValuesFieldDescriptor(SimpleType valuesArrayType) {
            Name name = Name.identifier("$VALUES");
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"\\$VALUES\")");
            KotlinType kotlinType = valuesArrayType;
            DeclarationDescriptor declarationDescriptor = this.irClass.getDescriptor();
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PRIVATE");
            SourceElement sourceElement = this.irClass.getDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"irClass.descriptor.source");
            return JvmPropertyDescriptorImpl.Companion.createStaticVal(name, kotlinType, declarationDescriptor, annotations2, Modality.FINAL, visibility, 4096, sourceElement);
        }

        private final void lowerEnumClassBody() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassBodyTransformer());
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public EnumClassTransformer(@NotNull IrClass irClass) {
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.enumEntryOrdinals = new TObjectIntHashMap();
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntriesByField = new HashMap();
            this.enumEntryFields = new ArrayList();
        }

        @NotNull
        public static final /* synthetic */ PropertyDescriptor access$getValuesFieldDescriptor$p(EnumClassTransformer $this) {
            PropertyDescriptor propertyDescriptor = $this.valuesFieldDescriptor;
            if (propertyDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valuesFieldDescriptor");
            }
            return propertyDescriptor;
        }

        public static final /* synthetic */ void access$setValuesFieldDescriptor$p(EnumClassTransformer $this, @NotNull PropertyDescriptor propertyDescriptor) {
            $this.valuesFieldDescriptor = propertyDescriptor;
        }

        @NotNull
        public static final /* synthetic */ FunctionDescriptor access$getValueOfFunctionDescriptor$p(EnumClassTransformer $this) {
            FunctionDescriptor functionDescriptor = $this.valueOfFunctionDescriptor;
            if (functionDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueOfFunctionDescriptor");
            }
            return functionDescriptor;
        }

        public static final /* synthetic */ void access$setValueOfFunctionDescriptor$p(EnumClassTransformer $this, @NotNull FunctionDescriptor functionDescriptor) {
            $this.valueOfFunctionDescriptor = functionDescriptor;
        }

        @NotNull
        public static final /* synthetic */ FunctionDescriptor access$getValuesFunctionDescriptor$p(EnumClassTransformer $this) {
            FunctionDescriptor functionDescriptor = $this.valuesFunctionDescriptor;
            if (functionDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valuesFunctionDescriptor");
            }
            return functionDescriptor;
        }

        public static final /* synthetic */ void access$setValuesFunctionDescriptor$p(EnumClassTransformer $this, @NotNull FunctionDescriptor functionDescriptor) {
            $this.valuesFunctionDescriptor = functionDescriptor;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumClassConstructor;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "enumClassConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;)V", "getEnumClassConstructor", "()Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend"})
        private final class InEnumClassConstructor
        implements EnumConstructorCallTransformer {
            @NotNull
            private final ClassConstructorDescriptor enumClassConstructor;

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrEnumConstructorCall enumConstructorCall) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)enumConstructorCall, (String)"enumConstructorCall");
                int startOffset = enumConstructorCall.getStartOffset();
                int endOffset = enumConstructorCall.getEndOffset();
                IrStatementOrigin origin = enumConstructorCall.getOrigin();
                IrDelegatingConstructorCallImpl result2 = new IrDelegatingConstructorCallImpl(startOffset, endOffset, enumConstructorCall.getDescriptor(), null, 8, null);
                boolean bl2 = bl = result2.getDescriptor().getValueParameters().size() == 2;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Enum(String, Int) constructor call expected:\n" + DumpIrTreeKt.dump(result2);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                List<ValueParameterDescriptor> list2 = this.enumClassConstructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"enumClassConstructor.valueParameters");
                List<ValueParameterDescriptor> $i$a$1$assert = list2;
                int n = 0;
                if (n > CollectionsKt.getLastIndex($i$a$1$assert)) {
                    int it = n;
                    throw (Throwable)((Object)new AssertionError((Object)("No 'name' parameter in enum constructor: " + this.enumClassConstructor)));
                }
                ValueParameterDescriptor nameParameter = $i$a$1$assert.get(n);
                List<ValueParameterDescriptor> list3 = this.enumClassConstructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"enumClassConstructor.valueParameters");
                List<ValueParameterDescriptor> list4 = list3;
                int n2 = 1;
                if (n2 > CollectionsKt.getLastIndex(list4)) {
                    int it = n2;
                    throw (Throwable)((Object)new AssertionError((Object)("No 'ordinal' parameter in enum constructor: " + this.enumClassConstructor)));
                }
                ValueParameterDescriptor ordinalParameter = list4.get(n2);
                ValueParameterDescriptor valueParameterDescriptor = nameParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"nameParameter");
                result2.putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, valueParameterDescriptor, origin));
                ValueParameterDescriptor valueParameterDescriptor2 = ordinalParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"ordinalParameter");
                result2.putValueArgument(1, new IrGetValueImpl(startOffset, endOffset, valueParameterDescriptor2, origin));
                return result2;
            }

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrDelegatingConstructorCall delegatingConstructorCall) {
                Intrinsics.checkParameterIsNotNull((Object)delegatingConstructorCall, (String)"delegatingConstructorCall");
                ClassConstructorDescriptor descriptor2 = delegatingConstructorCall.getDescriptor();
                int startOffset = delegatingConstructorCall.getStartOffset();
                int endOffset = delegatingConstructorCall.getEndOffset();
                Map map2 = EnumClassTransformer.this.loweredEnumConstructors;
                Object v = map2.get(descriptor2);
                if (v == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Constructor called in enum entry initializer should've been lowered: " + descriptor2)));
                }
                ClassConstructorDescriptor loweredDelegatedConstructor = (ClassConstructorDescriptor)v;
                IrDelegatingConstructorCallImpl result2 = new IrDelegatingConstructorCallImpl(startOffset, endOffset, loweredDelegatedConstructor, null, 8, null);
                ValueParameterDescriptor valueParameterDescriptor = this.enumClassConstructor.getValueParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"enumClassConstructor.valueParameters[0]");
                result2.putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, valueParameterDescriptor, null, 8, null));
                ValueParameterDescriptor valueParameterDescriptor2 = this.enumClassConstructor.getValueParameters().get(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"enumClassConstructor.valueParameters[1]");
                result2.putValueArgument(1, new IrGetValueImpl(startOffset, endOffset, valueParameterDescriptor2, null, 8, null));
                List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
                Iterable $receiver$iv = list2;
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor valueParameter = (ValueParameterDescriptor)element$iv;
                    int i = valueParameter.getIndex();
                    result2.putValueArgument(i + 2, delegatingConstructorCall.getValueArgument(i));
                }
                return result2;
            }

            @NotNull
            public final ClassConstructorDescriptor getEnumClassConstructor() {
                return this.enumClassConstructor;
            }

            public InEnumClassConstructor(@NotNull ClassConstructorDescriptor enumClassConstructor) {
                Intrinsics.checkParameterIsNotNull((Object)enumClassConstructor, (String)"enumClassConstructor");
                this.enumClassConstructor = enumClassConstructor;
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "enumEntry", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend"})
        private abstract class InEnumEntry
        implements EnumConstructorCallTransformer {
            private final ClassDescriptor enumEntry;

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrEnumConstructorCall enumConstructorCall) {
                Intrinsics.checkParameterIsNotNull((Object)enumConstructorCall, (String)"enumConstructorCall");
                String name = this.enumEntry.getName().asString();
                int ordinal = EnumClassTransformer.this.enumEntryOrdinals.get(this.enumEntry);
                ClassConstructorDescriptor descriptor2 = enumConstructorCall.getDescriptor();
                int startOffset = enumConstructorCall.getStartOffset();
                int endOffset = enumConstructorCall.getEndOffset();
                Map map2 = EnumClassTransformer.this.loweredEnumConstructors;
                Object v = map2.get(descriptor2);
                if (v == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Constructor called in enum entry initializer should've been lowered: " + descriptor2)));
                }
                ClassConstructorDescriptor loweredConstructor = (ClassConstructorDescriptor)v;
                IrMemberAccessExpression result2 = this.createConstructorCall(startOffset, endOffset, loweredConstructor);
                SimpleType simpleType2 = EnumClassLowering.this.getContext().getBuiltIns().getStringType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.stringType");
                KotlinType kotlinType = simpleType2;
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                result2.putValueArgument(0, IrConstImpl.Companion.string(startOffset, endOffset, kotlinType, string));
                SimpleType simpleType3 = EnumClassLowering.this.getContext().getBuiltIns().getIntType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"context.builtIns.intType");
                result2.putValueArgument(1, IrConstImpl.Companion.int(startOffset, endOffset, simpleType3, ordinal));
                List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
                Iterable $receiver$iv = list2;
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor valueParameter = (ValueParameterDescriptor)element$iv;
                    int i = valueParameter.getIndex();
                    result2.putValueArgument(i + 2, enumConstructorCall.getValueArgument(i));
                }
                return result2;
            }

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrDelegatingConstructorCall delegatingConstructorCall) {
                Intrinsics.checkParameterIsNotNull((Object)delegatingConstructorCall, (String)"delegatingConstructorCall");
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected delegating constructor call within enum entry: " + this.enumEntry)));
            }

            @NotNull
            public abstract IrMemberAccessExpression createConstructorCall(int var1, int var2, @NotNull ClassConstructorDescriptor var3);

            public InEnumEntry(@NotNull ClassDescriptor enumEntry) {
                Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
                this.enumEntry = enumEntry;
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntryClassConstructor;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "enumEntry", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrDelegatingConstructorCallImpl;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "backend"})
        private final class InEnumEntryClassConstructor
        extends InEnumEntry {
            @Override
            @NotNull
            public IrDelegatingConstructorCallImpl createConstructorCall(int startOffset, int endOffset, @NotNull ClassConstructorDescriptor loweredConstructor) {
                Intrinsics.checkParameterIsNotNull((Object)loweredConstructor, (String)"loweredConstructor");
                return new IrDelegatingConstructorCallImpl(startOffset, endOffset, loweredConstructor, null, 8, null);
            }

            public InEnumEntryClassConstructor(@NotNull ClassDescriptor enumEntry) {
                Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
                super(enumEntry);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntryInitializer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "enumEntry", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "backend"})
        private final class InEnumEntryInitializer
        extends InEnumEntry {
            @Override
            @NotNull
            public IrCallImpl createConstructorCall(int startOffset, int endOffset, @NotNull ClassConstructorDescriptor loweredConstructor) {
                Intrinsics.checkParameterIsNotNull((Object)loweredConstructor, (String)"loweredConstructor");
                return new IrCallImpl(startOffset, endOffset, loweredConstructor, null, null, null, 56, null);
            }

            public InEnumEntryInitializer(@NotNull ClassDescriptor enumEntry) {
                Intrinsics.checkParameterIsNotNull((Object)enumEntry, (String)"enumEntry");
                super(enumEntry);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "enumConstructorCallTransformer", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "createEnumValueOfBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "createEnumValuesBody", "valuesFieldDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSyntheticBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBody;", "backend"})
        private final class EnumClassBodyTransformer
        extends IrElementTransformerVoid {
            private EnumConstructorCallTransformer enumConstructorCallTransformer;

            @Override
            @NotNull
            public IrStatement visitField(@NotNull IrField declaration) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                ClassDescriptor enumEntry = (ClassDescriptor)EnumClassTransformer.this.enumEntriesByField.get(declaration.getDescriptor());
                if (enumEntry == null) {
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                    return declaration;
                }
                boolean bl2 = bl = this.enumConstructorCallTransformer == null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration);
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.enumConstructorCallTransformer = new InEnumEntryInitializer(enumEntry);
                IrStatement result2 = super.visitField(declaration);
                this.enumConstructorCallTransformer = null;
                return result2;
            }

            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                ClassConstructorDescriptor constructorDescriptor = declaration.getDescriptor();
                ClassDescriptor containingClass = constructorDescriptor.getContainingDeclaration();
                EnumConstructorCallTransformer previous = this.enumConstructorCallTransformer;
                if (containingClass.getKind() == ClassKind.ENUM_ENTRY) {
                    boolean bl2 = bl = this.enumConstructorCallTransformer == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration);
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    this.enumConstructorCallTransformer = new InEnumEntryClassConstructor(containingClass);
                } else if (containingClass.getKind() == ClassKind.ENUM_CLASS) {
                    boolean bl3 = bl = this.enumConstructorCallTransformer == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration);
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    this.enumConstructorCallTransformer = new InEnumClassConstructor(constructorDescriptor);
                }
                IrStatement result2 = super.visitConstructor(declaration);
                this.enumConstructorCallTransformer = previous;
                return result2;
            }

            @Override
            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                EnumConstructorCallTransformer enumConstructorCallTransformer = this.enumConstructorCallTransformer;
                if (enumConstructorCallTransformer == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Enum constructor call outside of enum entry initialization or enum class constructor:\n" + DumpIrTreeKt.dump(EnumClassTransformer.this.getIrClass()))));
                }
                EnumConstructorCallTransformer callTransformer = enumConstructorCallTransformer;
                return callTransformer.transform(expression2);
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (expression2.getDescriptor().getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
                    EnumConstructorCallTransformer enumConstructorCallTransformer = this.enumConstructorCallTransformer;
                    if (enumConstructorCallTransformer == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Enum constructor call outside of enum entry initialization or enum class constructor:\n" + DumpIrTreeKt.dump(EnumClassTransformer.this.getIrClass()))));
                    }
                    EnumConstructorCallTransformer callTransformer = enumConstructorCallTransformer;
                    return callTransformer.transform(expression2);
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Map map2 = EnumClassTransformer.this.loweredEnumConstructorParameters;
                ValueDescriptor valueDescriptor = expression2.getDescriptor();
                ValueParameterDescriptor loweredParameter = (ValueParameterDescriptor)map2.get(valueDescriptor);
                return loweredParameter != null ? (IrExpression)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), loweredParameter, expression2.getOrigin()) : (IrExpression)expression2;
            }

            @Override
            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body) {
                IrBody irBody;
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                switch (EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$WhenMappings.$EnumSwitchMapping$0[body.getKind().ordinal()]) {
                    case 1: {
                        irBody = this.createEnumValuesBody(EnumClassTransformer.access$getValuesFieldDescriptor$p(EnumClassTransformer.this));
                        break;
                    }
                    case 2: {
                        irBody = this.createEnumValueOfBody();
                        break;
                    }
                    default: {
                        irBody = body;
                    }
                }
                return irBody;
            }

            private final IrBody createEnumValueOfBody() {
                FunctionDescriptor substitutedValueOf;
                FunctionDescriptor unsubstitutedValueOf = EnumClassLowering.this.getContext().getIrBuiltIns().getEnumValueOf();
                TypeParameterDescriptor typeParameterT = unsubstitutedValueOf.getTypeParameters().get(0);
                SimpleType enumClassType = EnumClassTransformer.this.getIrClass().getDescriptor().getDefaultType();
                TypeParameterDescriptor typeParameterDescriptor = typeParameterT;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterT");
                TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameterDescriptor.getTypeConstructor(), (Object)new TypeProjectionImpl(enumClassType))));
                FunctionDescriptor functionDescriptor = unsubstitutedValueOf.substitute(typeSubstitutor2);
                if (functionDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                FunctionDescriptor functionDescriptor2 = substitutedValueOf = functionDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"substitutedValueOf");
                IrCallImpl irValueOfCall = new IrCallImpl(-1, -1, functionDescriptor2, MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameterT, (Object)enumClassType)), null, null, 48, null);
                ValueParameterDescriptor valueParameterDescriptor = EnumClassTransformer.access$getValueOfFunctionDescriptor$p(EnumClassTransformer.this).getValueParameters().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueOfFunctionDescriptor.valueParameters[0]");
                irValueOfCall.putValueArgument(0, new IrGetValueImpl(-1, -1, valueParameterDescriptor, null, 8, null));
                return new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, EnumClassTransformer.access$getValueOfFunctionDescriptor$p(EnumClassTransformer.this), (IrExpression)irValueOfCall)));
            }

            private final IrBody createEnumValuesBody(PropertyDescriptor valuesFieldDescriptor) {
                IrCallImpl irCallImpl;
                MemberScope memberScope2 = valuesFieldDescriptor.getType().getMemberScope();
                Name name = Name.identifier("clone");
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"clone\")");
                FunctionDescriptor cloneFun = KotlinUtilsKt.findSingleFunction(memberScope2, name);
                IrCallImpl $receiver = irCallImpl = new IrCallImpl(-1, -1, cloneFun, null, null, null, 56, null);
                $receiver.setDispatchReceiver(new IrGetFieldImpl(-1, -1, valuesFieldDescriptor, null, null, 24, null));
                IrCallImpl irCloneValues = irCallImpl;
                return new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf((Object)new IrReturnImpl(-1, -1, EnumClassTransformer.access$getValuesFunctionDescriptor$p(EnumClassTransformer.this), (IrExpression)irCloneValues)));
            }
        }
    }
}

