/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.cache.CleanupAction;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class CleanupActionFactory {
    private final BuildOperationExecutor buildOperationExecutor;

    public CleanupActionFactory(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public CleanupAction create(CleanupAction action) {
        return new BuildOperationCacheCleanupDecorator(action, this.buildOperationExecutor);
    }

    private static class BuildOperationCacheCleanupDecorator
    implements CleanupAction {
        private final BuildOperationExecutor buildOperationExecutor;
        private final CleanupAction delegate;

        public BuildOperationCacheCleanupDecorator(CleanupAction delegate, BuildOperationExecutor buildOperationExecutor) {
            this.buildOperationExecutor = buildOperationExecutor;
            this.delegate = delegate;
        }

        @Override
        public void clean(final PersistentCache persistentCache) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    BuildOperationCacheCleanupDecorator.this.delegate.clean(persistentCache);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Clean up " + persistentCache));
                }
            });
        }
    }
}

