/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.Locale;

public class WindowsShortcut {
    private boolean isDirectory;
    private boolean isLocal;
    private String realFile;

    public static boolean isPotentialValidLink(File file) throws IOException {
        int minimum_length = 100;
        boolean isPotentiallyValid = false;
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            isPotentiallyValid = file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".lnk") && fis.available() >= 100 && WindowsShortcut.isMagicPresent(WindowsShortcut.getBytes(fis, 32));
        }
        return isPotentiallyValid;
    }

    public WindowsShortcut(File file) throws IOException, ParseException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.parseLink(WindowsShortcut.getBytes(in));
        }
    }

    public String getRealFilename() {
        return this.realFile;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        return WindowsShortcut.getBytes(in, null);
    }

    private static byte[] getBytes(InputStream in, Integer max) throws IOException {
        int n;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[256];
        while ((max == null || max > 0) && (n = in.read(buff)) != -1) {
            bout.write(buff, 0, n);
            if (max == null) continue;
            max = max - n;
        }
        in.close();
        return bout.toByteArray();
    }

    private static boolean isMagicPresent(byte[] link) {
        int magic = 76;
        boolean magic_offset = false;
        return link.length >= 32 && WindowsShortcut.bytesToDword(link, 0) == 76;
    }

    private void parseLink(byte[] link) throws ParseException {
        try {
            if (!WindowsShortcut.isMagicPresent(link)) {
                throw new ParseException("Invalid shortcut; magic is missing", 0);
            }
            byte flags = link[20];
            int fileAttsOffset = 24;
            byte fileAtts = link[24];
            int isDirMask = 16;
            this.isDirectory = (fileAtts & isDirMask) > 0;
            int shellOffset = 76;
            boolean hasShellMask = true;
            int shellLen = 0;
            if ((flags & 1) > 0) {
                shellLen = WindowsShortcut.bytesToWord(link, 76) + 2;
            }
            int fileStart = 76 + shellLen;
            int fileLocationInfoFlagOffsetOffset = 8;
            byte fileLocationInfoFlag = link[fileStart + 8];
            this.isLocal = (fileLocationInfoFlag & 2) == 0;
            int basenameOffsetOffset = 16;
            int networkVolumeTableOffsetOffset = 20;
            int finalnameOffsetOffset = 24;
            int finalnameOffset = link[fileStart + 24] + fileStart;
            String finalname = WindowsShortcut.getNullDelimitedString(link, finalnameOffset);
            if (this.isLocal) {
                int basenameOffset = link[fileStart + 16] + fileStart;
                String basename = WindowsShortcut.getNullDelimitedString(link, basenameOffset);
                this.realFile = basename + finalname;
            } else {
                int networkVolumeTableOffset = link[fileStart + 20] + fileStart;
                int shareNameOffsetOffset = 8;
                int shareNameOffset = link[networkVolumeTableOffset + shareNameOffsetOffset] + networkVolumeTableOffset;
                String shareName = WindowsShortcut.getNullDelimitedString(link, shareNameOffset);
                this.realFile = shareName + "\\" + finalname;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ParseException ex = new ParseException("Could not be parsed, probably not a valid WindowsShortcut", 0);
            ex.initCause(e);
            throw ex;
        }
    }

    private static String getNullDelimitedString(byte[] bytes, int off) {
        int len = 0;
        while (bytes[off + len] != 0) {
            ++len;
        }
        return new String(bytes, off, len, StandardCharsets.UTF_8);
    }

    private static int bytesToWord(byte[] bytes, int off) {
        return (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
    }

    private static int bytesToDword(byte[] bytes, int off) {
        return WindowsShortcut.bytesToWord(bytes, off + 2) << 16 | WindowsShortcut.bytesToWord(bytes, off);
    }
}

